# Pokemon League - Custom NPC Skins Resource Pack

Ce resource pack permet d'ajouter des skins PNG personnalisés pour les NPCs de la Pokemon League.

## Structure des fichiers

```
pokemon-league-resourcepack/
├── pack.mcmeta
├── assets/
│   └── pokemonleague/
│       ├── textures/
│       │   └── npcs/
│       │       ├── gym_leader_rock.png      <- Tes PNG custom ici
│       │       ├── gym_leader_water.png
│       │       ├── gym_trainer_rock_1.png
│       │       └── ...
│       └── bedrock/
│           └── npcs/
│               └── variations/
│                   ├── gym_leader_rock/
│                   │   └── 0_gym_leader_rock.json
│                   └── ...
└── data/
    └── pokemonleague/
        └── npcs/
            ├── gym_leader_rock.json
            └── ...
```

## Comment ajouter un skin custom

### 1. Ajouter ton PNG

Place ton fichier PNG dans :
```
assets/pokemonleague/textures/npcs/ton_skin.png
```

**Format du PNG :** 64x64 pixels (format skin Minecraft standard)

### 2. Creer la variation

Cree un fichier dans `assets/pokemonleague/bedrock/npcs/variations/ton_npc/0_ton_npc.json` :

```json
{
  "name": "pokemonleague:ton_npc",
  "order": 0,
  "variations": [
    {
      "aspects": [],
      "poser": "cobblemon:standard",
      "model": "cobblemon:trainer.geo",
      "texture": "pokemonleague:textures/npcs/ton_skin.png",
      "layers": []
    }
  ]
}
```

### 3. Creer la definition NPC

Cree un fichier dans `data/pokemonleague/npcs/ton_npc.json` :

```json
{
  "resourceIdentifier": "pokemonleague:ton_npc",
  "hitbox": "player",
  "names": ["Nom du NPC"],
  "battleConfiguration": {
    "canChallenge": true
  },
  "skill": 4
}
```

### 4. Utiliser dans la config

Dans `gym_config.json` ou `config.json`, utilise :
```json
"npcSkin": "pokemonleague:ton_npc"
```

## NPCs pre-configures

| ID | Description | Fichier PNG |
|----|-------------|-------------|
| `pokemonleague:gym_leader_rock` | Champion Roche (Pierrette) | gym_leader_rock.png |
| `pokemonleague:gym_leader_water` | Champion Eau (Ondine) | gym_leader_water.png |
| `pokemonleague:gym_leader_electric` | Champion Electrik (Major Bob) | gym_leader_electric.png |
| `pokemonleague:gym_leader_grass` | Champion Plante (Erika) | gym_leader_grass.png |
| `pokemonleague:gym_leader_psychic` | Champion Psy (Morgane) | gym_leader_psychic.png |
| `pokemonleague:gym_trainer_rock_1` | Trainer Roche 1 | gym_trainer_rock_1.png |
| `pokemonleague:gym_trainer_rock_2` | Trainer Roche 2 | gym_trainer_rock_2.png |
| `pokemonleague:gym_trainer_rock_3` | Trainer Roche 3 | gym_trainer_rock_3.png |
| `pokemonleague:league_champion_1` | Champion League 1 (Feu) | league_champion_1.png |
| `pokemonleague:league_champion_2` | Champion League 2 (Plante) | league_champion_2.png |
| `pokemonleague:league_champion_3` | Champion League 3 (Roche) | league_champion_3.png |
| `pokemonleague:league_champion_4` | Champion League 4 (Insecte) | league_champion_4.png |
| `pokemonleague:league_champion_5` | Champion League 5 (Eau) | league_champion_5.png |
| `pokemonleague:league_champion_6` | Champion League 6 (Tenebres) | league_champion_6.png |
| `pokemonleague:league_champion_7` | Champion League Final (Dragon) | league_champion_7.png |

## Installation

1. Place ce dossier dans le dossier `resourcepacks` de ton serveur
2. Ou zip le contenu et place le .zip dans `resourcepacks`
3. Active le resource pack

## Modeles disponibles

- `cobblemon:trainer.geo` - Modele trainer standard
- `cobblemon:steve.geo` - Modele Steve (joueur)
- `cobblemon:alex.geo` - Modele Alex (joueur slim)
- `cobblemon:sacchi.geo` - Modele Sacchi

## Posers disponibles

- `cobblemon:standard` - Animations standard
