/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.fabric.network;

import com.cobblemon.mod.common.battles.BattleFormat;
import com.necro.raid.dens.common.network.ClientPacket;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.network.ServerPacket;
import com.necro.raid.dens.common.network.packets.CloseReadyOverlayPacket;
import com.necro.raid.dens.common.network.packets.JoinRaidPacket;
import com.necro.raid.dens.common.network.packets.LeaveRaidPacket;
import com.necro.raid.dens.common.network.packets.OpenInvitationGuiPacket;
import com.necro.raid.dens.common.network.packets.RaidAspectPacket;
import com.necro.raid.dens.common.network.packets.RaidChallengePacket;
import com.necro.raid.dens.common.network.packets.RaidConfirmPacket;
import com.necro.raid.dens.common.network.packets.RaidConfirmResponsePacket;
import com.necro.raid.dens.common.network.packets.RaidCrystalSpawnPacket;
import com.necro.raid.dens.common.network.packets.RaidInvitationPacket;
import com.necro.raid.dens.common.network.packets.RaidInvitationResponsePacket;
import com.necro.raid.dens.common.network.packets.RaidInviteListPacket;
import com.necro.raid.dens.common.network.packets.RaidInviteSendPacket;
import com.necro.raid.dens.common.network.packets.RaidLogPacket;
import com.necro.raid.dens.common.network.packets.RaidReadyPacket;
import com.necro.raid.dens.common.network.packets.RaidReadyResponsePacket;
import com.necro.raid.dens.common.network.packets.RaidReadySyncPacket;
import com.necro.raid.dens.common.network.packets.RequestPacket;
import com.necro.raid.dens.common.network.packets.RequestResponsePacket;
import com.necro.raid.dens.common.network.packets.ResizePacket;
import com.necro.raid.dens.common.network.packets.RewardPacket;
import com.necro.raid.dens.common.network.packets.RewardResponsePacket;
import com.necro.raid.dens.common.network.packets.SyncHealthPacket;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class NetworkMessages {
    public static void registerPayload() {
        PayloadTypeRegistry.playS2C().register(SyncHealthPacket.PACKET_TYPE, SyncHealthPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(JoinRaidPacket.PACKET_TYPE, JoinRaidPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RequestPacket.PACKET_TYPE, RequestPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RewardPacket.PACKET_TYPE, RewardPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(ResizePacket.PACKET_TYPE, ResizePacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RaidAspectPacket.PACKET_TYPE, RaidAspectPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RaidLogPacket.PACKET_TYPE, RaidLogPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RaidConfirmPacket.PACKET_TYPE, RaidConfirmPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RaidInviteListPacket.PACKET_TYPE, RaidInviteListPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RaidInvitationPacket.PACKET_TYPE, RaidInvitationPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RaidReadyPacket.PACKET_TYPE, RaidReadyPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RaidReadySyncPacket.PACKET_TYPE, RaidReadySyncPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RaidCrystalSpawnPacket.PACKET_TYPE, RaidCrystalSpawnPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(OpenInvitationGuiPacket.PACKET_TYPE, OpenInvitationGuiPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(CloseReadyOverlayPacket.PACKET_TYPE, CloseReadyOverlayPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RaidChallengePacket.PACKET_TYPE, RaidChallengePacket.CODEC);
        PayloadTypeRegistry.playC2S().register(LeaveRaidPacket.PACKET_TYPE, LeaveRaidPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestResponsePacket.PACKET_TYPE, RequestResponsePacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RewardResponsePacket.PACKET_TYPE, RewardResponsePacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RaidConfirmResponsePacket.PACKET_TYPE, RaidConfirmResponsePacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RaidInviteSendPacket.PACKET_TYPE, RaidInviteSendPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RaidInvitationResponsePacket.PACKET_TYPE, RaidInvitationResponsePacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RaidReadyResponsePacket.PACKET_TYPE, RaidReadyResponsePacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(RaidChallengePacket.PACKET_TYPE, NetworkMessages::handle);
        ServerPlayNetworking.registerGlobalReceiver(LeaveRaidPacket.PACKET_TYPE, NetworkMessages::handle);
        ServerPlayNetworking.registerGlobalReceiver(RequestResponsePacket.PACKET_TYPE, NetworkMessages::handle);
        ServerPlayNetworking.registerGlobalReceiver(RewardResponsePacket.PACKET_TYPE, NetworkMessages::handle);
        ServerPlayNetworking.registerGlobalReceiver(RaidConfirmResponsePacket.PACKET_TYPE, NetworkMessages::handle);
        ServerPlayNetworking.registerGlobalReceiver(RaidInviteSendPacket.PACKET_TYPE, NetworkMessages::handle);
        ServerPlayNetworking.registerGlobalReceiver(RaidInvitationResponsePacket.PACKET_TYPE, NetworkMessages::handle);
        ServerPlayNetworking.registerGlobalReceiver(RaidReadyResponsePacket.PACKET_TYPE, NetworkMessages::handle);
    }

    public static void registerS2CPackets() {
        ClientPlayNetworking.registerGlobalReceiver(SyncHealthPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(JoinRaidPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(RequestPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(RewardPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(ResizePacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(RaidAspectPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(RaidLogPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(RaidConfirmPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(RaidInviteListPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(RaidInvitationPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(RaidReadyPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(RaidReadySyncPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(RaidCrystalSpawnPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(OpenInvitationGuiPacket.PACKET_TYPE, NetworkMessages::handle);
        ClientPlayNetworking.registerGlobalReceiver(CloseReadyOverlayPacket.PACKET_TYPE, NetworkMessages::handle);
    }

    public static void init() {
        RaidDenNetworkMessages.SYNC_HEALTH = (player, healthRatio) -> NetworkMessages.sendPacketToPlayer(player, new SyncHealthPacket(healthRatio.floatValue()));
        RaidDenNetworkMessages.JOIN_RAID = (player, isJoining) -> NetworkMessages.sendPacketToPlayer(player, new JoinRaidPacket((boolean)isJoining));
        RaidDenNetworkMessages.REQUEST_PACKET = (player, name) -> NetworkMessages.sendPacketToPlayer(player, new RequestPacket((String)name));
        RaidDenNetworkMessages.REWARD_PACKET = (player, isCatchable, pokemon) -> NetworkMessages.sendPacketToPlayer(player, new RewardPacket((boolean)isCatchable, (String)pokemon));
        RaidDenNetworkMessages.RESIZE = (level, entity, scale) -> NetworkMessages.sendPacketToLevel(level, new ResizePacket(entity.method_5628(), scale.floatValue()));
        RaidDenNetworkMessages.RAID_ASPECT = (player, entity) -> NetworkMessages.sendPacketToPlayer(player, new RaidAspectPacket(entity.method_5628()));
        RaidDenNetworkMessages.RAID_LOG = (player, pokemon, move) -> NetworkMessages.sendPacketToPlayer(player, new RaidLogPacket((String)pokemon, (String)move));
        RaidDenNetworkMessages.RAID_CHALLENGE = (pokemonEntity, pokemon) -> NetworkMessages.sendPacketToServer(new RaidChallengePacket(pokemonEntity.method_5628(), pokemon.getUuid(), BattleFormat.Companion.getGEN_9_SINGLES()));
        RaidDenNetworkMessages.LEAVE_RAID = () -> NetworkMessages.sendPacketToServer(new LeaveRaidPacket());
        RaidDenNetworkMessages.REQUEST_RESPONSE = (accept, player) -> NetworkMessages.sendPacketToServer(new RequestResponsePacket((boolean)accept, (String)player));
        RaidDenNetworkMessages.REWARD_RESPONSE = catchPokemon -> NetworkMessages.sendPacketToServer(new RewardResponsePacket((boolean)catchPokemon));
        RaidDenNetworkMessages.OPEN_INVITATION_GUI = player -> NetworkMessages.sendPacketToPlayer(player, new OpenInvitationGuiPacket());
        RaidDenNetworkMessages.INVITATION_RESPONSE = (accepted, hostUuid) -> NetworkMessages.sendPacketToServer(new RaidInvitationResponsePacket((boolean)accepted, (UUID)hostUuid));
        RaidDenNetworkMessages.READY_RESPONSE = raidId -> NetworkMessages.sendPacketToServer(new RaidReadyResponsePacket((UUID)raidId));
        RaidDenNetworkMessages.SEND_CONFIRM = (player, tier, bossSpecies, bossLevel, crystalUuid) -> NetworkMessages.sendPacketToPlayer(player, new RaidConfirmPacket(tier, bossSpecies, bossLevel, crystalUuid));
        RaidDenNetworkMessages.CONFIRM_RESPONSE = (confirmed, crystalUuid) -> NetworkMessages.sendPacketToServer(new RaidConfirmResponsePacket((boolean)confirmed, (UUID)crystalUuid));
        RaidDenNetworkMessages.SEND_INVITES = (invitedPlayers, crystalUuid, startSolo) -> NetworkMessages.sendPacketToServer(new RaidInviteSendPacket(invitedPlayers, crystalUuid, startSolo));
        RaidDenNetworkMessages.SEND_INVITE_LIST = (player, playerNames, maxInvites, crystalUuid) -> NetworkMessages.sendPacketToPlayer(player, new RaidInviteListPacket(playerNames, maxInvites, crystalUuid));
        RaidDenNetworkMessages.SEND_INVITATION = (player, hostName, tier, bossSpecies, hostUuid) -> NetworkMessages.sendPacketToPlayer(player, new RaidInvitationPacket(hostName, tier, bossSpecies, hostUuid));
        RaidDenNetworkMessages.SEND_READY = (player, timeoutSeconds, participantNames, raidId) -> NetworkMessages.sendPacketToPlayer(player, new RaidReadyPacket(timeoutSeconds, participantNames, raidId));
        RaidDenNetworkMessages.SEND_READY_SYNC = (player, packet) -> NetworkMessages.sendPacketToPlayer(player, packet);
        RaidDenNetworkMessages.SEND_CRYSTAL_SPAWN = (player, packet) -> NetworkMessages.sendPacketToPlayer(player, packet);
        RaidDenNetworkMessages.CLOSE_READY_OVERLAY = (player, raidId) -> NetworkMessages.sendPacketToPlayer(player, new CloseReadyOverlayPacket((UUID)raidId));
    }

    public static void sendPacketToServer(class_8710 packet) {
        ClientPlayNetworking.send((class_8710)packet);
    }

    public static void sendPacketToAll(MinecraftServer server, class_8710 packet) {
        server.method_3760().method_14571().forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)packet));
    }

    public static void sendPacketToLevel(class_3218 level, class_8710 packet) {
        level.method_18456().forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)packet));
    }

    public static void sendPacketToPlayer(class_3222 player, class_8710 packet) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }

    private static void handle(ClientPacket packet, ClientPlayNetworking.Context context) {
        packet.handleClient();
    }

    private static void handle(ServerPacket packet, ServerPlayNetworking.Context context) {
        packet.handleServer(context.player());
    }
}

