/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.util;

import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ActivePokemonState;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.BlockTags;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.components.ModComponents;
import com.necro.raid.dens.common.data.dimension.RaidRegion;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.items.ItemTags;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.RaidState;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.raids.helpers.RaidRegionHelper;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IRaidTeleporter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3738;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;

public class RaidUtils {
    private static final Set<String> POKEMON_BLACKLIST = new HashSet<String>();
    private static final Set<String> ABILITY_BLACKLIST = new HashSet<String>();
    private static final Set<String> MOVE_BLACKLIST = new HashSet<String>();
    private static final Set<String> COMMAND_BLACKLIST = new HashSet<String>();
    private static int MAX_COMMAND_SPLIT;

    public static boolean isPokemonBlacklisted(Pokemon pokemon) {
        return POKEMON_BLACKLIST.contains(pokemon.getSpecies().getName().toLowerCase());
    }

    public static boolean isAbilityBlacklisted(Ability ability) {
        return ABILITY_BLACKLIST.contains(ability.getName());
    }

    public static boolean isMoveBlacklisted(String move) {
        return MOVE_BLACKLIST.contains(move);
    }

    public static boolean isCommandBlacklisted(String command) {
        return COMMAND_BLACKLIST.contains(command);
    }

    public static int getMaxCommandSplit() {
        return MAX_COMMAND_SPLIT;
    }

    public static boolean hasSkyAccess(class_4538 level, class_2338 blockPos) {
        int topY = level.method_22350(blockPos).method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF);
        return blockPos.method_10264() >= topY;
    }

    public static void teleportPlayerToRaid(class_3222 player, MinecraftServer server, RaidRegion region) {
        class_3218 level = ModDimensions.getRaidDimension(server);
        if (level == null) {
            return;
        }
        ((IRaidTeleporter)player).crd_setHomePos(player.method_19538());
        ((IRaidTeleporter)player).crd_setHomeLevel(player.method_37908().method_27983().method_29177());
        class_243 playerPos = region.getPlayerPos();
        PlayerExtensionsKt.party((class_3222)player).forEach(pokemon -> {
            if (pokemon.getState() instanceof ActivePokemonState) {
                pokemon.recall();
            }
        });
        server.method_18858((Runnable)new class_3738(server.method_3780() + 5, () -> {
            if (player.method_5805() && player.field_13987 != null) {
                player.method_48105(level, playerPos.field_1352, playerPos.field_1351, playerPos.field_1350, new HashSet(), 180.0f, 0.0f);
            }
        }));
    }

    public static void teleportPlayerSafe(class_3222 player, class_3218 level, class_243 targetPos, float yaw, float pitch) {
        PlayerExtensionsKt.party((class_3222)player).forEach(pokemon -> {
            if (pokemon.getState() instanceof ActivePokemonState) {
                pokemon.recall();
            }
        });
        int groundY = level.method_22350(class_2338.method_49638((class_2374)targetPos)).method_12005(class_2902.class_2903.field_13203, (int)targetPos.method_10216(), (int)targetPos.method_10215()) + 1;
        player.method_48105(level, targetPos.method_10216(), (double)groundY, targetPos.method_10215(), new HashSet(), yaw, pitch);
    }

    public static void leaveRaid(class_1657 player) {
        RaidDenNetworkMessages.JOIN_RAID.accept((class_3222)player, false);
        RaidJoinHelper.Participant participant = RaidJoinHelper.getParticipant(player);
        if (participant == null) {
            return;
        }
        UUID raid = participant.raid();
        RaidRegion region = RaidRegionHelper.getRegion(raid);
        if (region == null) {
            RaidUtils.leaveRaidFallback(player);
            return;
        }
        class_3218 level = ModDimensions.getRaidDimension(player.method_5682());
        if (level == null) {
            return;
        }
        RaidInstance instance = RaidHelper.ACTIVE_RAIDS.get(raid);
        if (instance == null) {
            RaidUtils.leaveRaidFallback(player);
            return;
        }
        if (instance.getRaidState() != RaidState.NOT_STARTED) {
            RaidUtils.leaveRaidFallback(player);
            return;
        }
        int players = level.method_8390(class_1657.class, region.bound(), p -> RaidJoinHelper.isParticipating(p, false)).size();
        if (players > (RaidUtils.isRaidDimension(player.method_37908()) ? 1 : 0)) {
            return;
        }
        int items = level.method_18467(class_1542.class, region.bound()).size();
        if (items > 0 && RaidUtils.isRaidDimension(player.method_37908())) {
            return;
        }
        instance.removePlayer((class_3222)player);
        instance.closeRaid(player.method_5682());
        PokemonEntity entity = instance.getBossEntity();
        if (!entity.method_31481()) {
            ((IRaidAccessor)entity).crd_flagForRemoval();
        }
    }

    private static void leaveRaidFallback(class_1657 player) {
        RaidHelper.removeRequests(player.method_5667());
        RaidJoinHelper.removeParticipant(player);
    }

    public static boolean isRaidDenKey(class_1799 itemStack) {
        return itemStack.method_31573(ItemTags.RAID_DEN_KEY) || (Boolean)itemStack.method_57825((class_9331)ModComponents.RAID_DEN_KEY.comp_349(), (Object)false) != false;
    }

    public static boolean isRaidDimension(class_1937 level) {
        return level.method_40134().method_40225(ModDimensions.RAID_DIM_TYPE);
    }

    public static boolean cannotBreak(class_1657 player, class_1937 level) {
        return RaidUtils.isRaidDimension(level) && !player.method_7337();
    }

    public static boolean cannotPlace(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        return RaidUtils.isRaidDimension(level) && !player.method_7337() && !level.method_8320(hitResult.method_17777()).method_26164(BlockTags.CAN_INTERACT);
    }

    public static boolean canBreak(class_1937 level, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        RaidCrystalBlockEntity raidCrystal;
        if (RaidUtils.cannotBreak(player, level)) {
            return false;
        }
        return !(blockEntity instanceof RaidCrystalBlockEntity) || (raidCrystal = (RaidCrystalBlockEntity)blockEntity).getPlayerCount() == 0;
    }

    public static class_1269 canPlace(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        return RaidUtils.cannotPlace(player, level, hand, hitResult) ? class_1269.field_5814 : class_1269.field_5811;
    }

    public static void init() {
        POKEMON_BLACKLIST.addAll(List.of(CobblemonRaidDens.BLACKLIST_CONFIG.pokemon));
        ABILITY_BLACKLIST.addAll(List.of(CobblemonRaidDens.BLACKLIST_CONFIG.abilities));
        MOVE_BLACKLIST.addAll(List.of(CobblemonRaidDens.BLACKLIST_CONFIG.moves));
        COMMAND_BLACKLIST.addAll(List.of(CobblemonRaidDens.BLACKLIST_CONFIG.commands));
        int maxSplit = 1;
        for (String command : COMMAND_BLACKLIST) {
            maxSplit = Math.max(maxSplit, command.split(" ").length);
        }
        MAX_COMMAND_SPLIT = Math.min(maxSplit, 4);
    }
}

