/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.showdown;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.dispatch.InstructionSet;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.showdown.instructions.CheerBoostInstruction;
import com.necro.raid.dens.common.showdown.instructions.CheerInstruction;
import com.necro.raid.dens.common.showdown.instructions.PlayerJoinInstruction;
import com.necro.raid.dens.common.showdown.instructions.RaidBoostInstruction;
import com.necro.raid.dens.common.showdown.instructions.RaidDamageInstruction;
import com.necro.raid.dens.common.showdown.instructions.RaidEnergyInstruction;
import com.necro.raid.dens.common.showdown.instructions.RaidHealInstruction;
import com.necro.raid.dens.common.showdown.instructions.ResetBossInstruction;
import com.necro.raid.dens.common.showdown.instructions.ResetPlayerInstruction;
import com.necro.raid.dens.common.showdown.instructions.ShieldAddInstruction;
import com.necro.raid.dens.common.showdown.instructions.ShieldRemoveInstruction;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function6;

public class RaidDensShowdownRegistry {
    public static void registerInstructions() {
        try {
            Method registerUpdate = ShowdownInterpreter.class.getMethod("registerUpdateInstructionParser", String.class, Function4.class);
            Method registerSplit = ShowdownInterpreter.class.getMethod("registerSplitInstructionParser", String.class, Function6.class);
            registerUpdate.invoke((Object)ShowdownInterpreter.INSTANCE, "cheer", (battle, instruction, message, messageIterator) -> new CheerInstruction((BattleMessage)message));
            registerUpdate.invoke((Object)ShowdownInterpreter.INSTANCE, "cheerboost", (battle, instruction, message, messageIterator) -> new CheerBoostInstruction((PokemonBattle)battle, (BattleMessage)message));
            registerUpdate.invoke((Object)ShowdownInterpreter.INSTANCE, "clearboss", (battle, instruction, message, messageIterator) -> new ResetBossInstruction((PokemonBattle)battle, (BattleMessage)message));
            registerUpdate.invoke((Object)ShowdownInterpreter.INSTANCE, "clearplayer", (battle, instruction, message, messageIterator) -> new ResetPlayerInstruction((PokemonBattle)battle, (BattleMessage)message));
            registerUpdate.invoke((Object)ShowdownInterpreter.INSTANCE, "raidenergy", (battle, instruction, message, messageIterator) -> new RaidEnergyInstruction((PokemonBattle)battle, (BattleMessage)message));
            registerUpdate.invoke((Object)ShowdownInterpreter.INSTANCE, "playerjoin", (battle, instruction, message, messageIterator) -> new PlayerJoinInstruction((PokemonBattle)battle, (BattleMessage)message));
            registerUpdate.invoke((Object)ShowdownInterpreter.INSTANCE, "shieldadd", (battle, instruction, message, messageIterator) -> new ShieldAddInstruction((PokemonBattle)battle, (BattleMessage)message));
            registerUpdate.invoke((Object)ShowdownInterpreter.INSTANCE, "shieldremove", (battle, instruction, message, messageIterator) -> new ShieldRemoveInstruction((PokemonBattle)battle, (BattleMessage)message));
            registerUpdate.invoke((Object)ShowdownInterpreter.INSTANCE, "-raidboost", (battle, instruction, message, messageIterator) -> new RaidBoostInstruction((PokemonBattle)battle, (BattleMessage)message, true));
            registerUpdate.invoke((Object)ShowdownInterpreter.INSTANCE, "-raidunboost", (battle, instruction, message, messageIterator) -> new RaidBoostInstruction((PokemonBattle)battle, (BattleMessage)message, false));
            registerSplit.invoke((Object)ShowdownInterpreter.INSTANCE, "-raiddamage", (battle, actor, instruction, publicMessage, privateMessage, messageIterator) -> new RaidDamageInstruction((InstructionSet)instruction, (BattleActor)actor, (BattleMessage)publicMessage, (BattleMessage)privateMessage));
            registerSplit.invoke((Object)ShowdownInterpreter.INSTANCE, "-raidheal", (battle, actor, instruction, publicMessage, privateMessage, messageIterator) -> new RaidHealInstruction((BattleActor)actor, (BattleMessage)publicMessage, (BattleMessage)privateMessage));
            CobblemonRaidDens.LOGGER.info("Registered raid instructions using Cobblemon 1.7.2+ API");
            return;
        }
        catch (NoSuchMethodException registerUpdate) {
        }
        catch (Exception e) {
            CobblemonRaidDens.LOGGER.error("Failed to register instructions via API", (Throwable)e);
        }
        try {
            Field updateField = ShowdownInterpreter.class.getDeclaredField("updateInstructionParser");
            updateField.setAccessible(true);
            Map updateInstructionParser = (Map)updateField.get(ShowdownInterpreter.INSTANCE);
            Field splitField = ShowdownInterpreter.class.getDeclaredField("splitInstructionParser");
            splitField.setAccessible(true);
            Map splitInstructionParser = (Map)splitField.get(ShowdownInterpreter.INSTANCE);
            updateInstructionParser.put("cheer", (battle, instruction, message, messageIterator) -> new CheerInstruction((BattleMessage)message));
            updateInstructionParser.put("cheerboost", (battle, instruction, message, messageIterator) -> new CheerBoostInstruction((PokemonBattle)battle, (BattleMessage)message));
            updateInstructionParser.put("clearboss", (battle, instruction, message, messageIterator) -> new ResetBossInstruction((PokemonBattle)battle, (BattleMessage)message));
            updateInstructionParser.put("clearplayer", (battle, instruction, message, messageIterator) -> new ResetPlayerInstruction((PokemonBattle)battle, (BattleMessage)message));
            updateInstructionParser.put("raidenergy", (battle, instruction, message, messageIterator) -> new RaidEnergyInstruction((PokemonBattle)battle, (BattleMessage)message));
            updateInstructionParser.put("playerjoin", (battle, instruction, message, messageIterator) -> new PlayerJoinInstruction((PokemonBattle)battle, (BattleMessage)message));
            updateInstructionParser.put("shieldadd", (battle, instruction, message, messageIterator) -> new ShieldAddInstruction((PokemonBattle)battle, (BattleMessage)message));
            updateInstructionParser.put("shieldremove", (battle, instruction, message, messageIterator) -> new ShieldRemoveInstruction((PokemonBattle)battle, (BattleMessage)message));
            updateInstructionParser.put("-raidboost", (battle, instruction, message, messageIterator) -> new RaidBoostInstruction((PokemonBattle)battle, (BattleMessage)message, true));
            updateInstructionParser.put("-raidunboost", (battle, instruction, message, messageIterator) -> new RaidBoostInstruction((PokemonBattle)battle, (BattleMessage)message, false));
            splitInstructionParser.put("-raiddamage", (battle, actor, instruction, publicMessage, privateMessage, messageIterator) -> new RaidDamageInstruction((InstructionSet)instruction, (BattleActor)actor, (BattleMessage)publicMessage, (BattleMessage)privateMessage));
            splitInstructionParser.put("-raidheal", (battle, actor, instruction, publicMessage, privateMessage, messageIterator) -> new RaidHealInstruction((BattleActor)actor, (BattleMessage)publicMessage, (BattleMessage)privateMessage));
            CobblemonRaidDens.LOGGER.info("Registered raid instructions using reflection (Cobblemon 1.7.1 compatibility)");
        }
        catch (Exception e) {
            CobblemonRaidDens.LOGGER.error("Failed to register raid instructions via reflection", (Throwable)e);
        }
    }
}

