/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.reloaders;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractReloadImpl {
    protected final String path;
    protected final String idRemove;
    protected final DataType type;

    protected AbstractReloadImpl(String path, DataType suffix) {
        this(path, path + "/", suffix);
    }

    protected AbstractReloadImpl(String path, String idRemove, DataType suffix) {
        this.path = path;
        this.idRemove = idRemove;
        this.type = suffix;
    }

    public void load(@NotNull class_3300 manager) {
        this.preLoad();
        manager.method_14488(this.path, path -> path.toString().endsWith(this.suffix())).forEach((id, resource) -> {
            try (InputStream input = resource.method_14482();){
                class_2960 key = class_2960.method_60655((String)id.method_12836(), (String)id.method_12832().replace(this.idRemove, "").replace(this.suffix(), ""));
                if (this.type == DataType.JSON) {
                    this.loadJson(input, key);
                } else if (this.type == DataType.NBT) {
                    this.loadNbt(input, key);
                }
            }
            catch (Exception e) {
                this.onError((class_2960)id, e);
            }
        });
        this.postLoad();
    }

    protected String suffix() {
        return this.type.suffix();
    }

    protected void loadJson(InputStream input, class_2960 key) {
        JsonObject object = JsonParser.parseReader((Reader)new InputStreamReader(input, StandardCharsets.UTF_8)).getAsJsonObject();
        this.onLoad(key, object);
    }

    protected void loadNbt(InputStream input, class_2960 key) throws IOException {
        class_2487 nbt = class_2507.method_10629((InputStream)input, (class_2505)class_2505.method_53898());
        this.onLoad(key, nbt);
    }

    protected abstract void preLoad();

    protected void onLoad(class_2960 key, JsonObject object) {
    }

    protected void onLoad(class_2960 key, class_2487 nbt) {
    }

    protected abstract void onError(class_2960 var1, Exception var2);

    protected abstract void postLoad();

    protected static enum DataType {
        JSON(".json"),
        NBT(".nbt"),
        JAVASCRIPT(".js");

        private final String suffix;

        private DataType(String suffix) {
            this.suffix = suffix;
        }

        private String suffix() {
            return this.suffix;
        }
    }
}

