/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids.helpers;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.config.TierConfig;
import com.necro.raid.dens.common.data.dimension.RaidRegion;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.events.RaidBattleStartEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.network.packets.RaidReadySyncPacket;
import com.necro.raid.dens.common.raids.RaidBuilder;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidInventorySaveManager;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.util.ComponentUtils;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3738;
import net.minecraft.server.MinecraftServer;

public class RaidReadyManager {
    private static final Map<UUID, ReadyCheckData> ACTIVE_CHECKS = new HashMap<UUID, ReadyCheckData>();

    public static void startReadyCheck(UUID raidId, List<class_3222> participants, RaidRegion region) {
        if (participants.isEmpty()) {
            return;
        }
        MinecraftServer server = participants.get(0).method_5682();
        if (server == null) {
            return;
        }
        int timeoutSeconds = CobblemonRaidDens.CONFIG.ready_timeout_seconds;
        long currentTick = server.method_30002().method_8510();
        long timeoutTick = currentTick + (long)timeoutSeconds * 20L;
        Set<UUID> participantUuids = participants.stream().map(class_1297::method_5667).collect(Collectors.toSet());
        List<String> participantNames = participants.stream().map(p -> p.method_5477().getString()).toList();
        ACTIVE_CHECKS.put(raidId, new ReadyCheckData(raidId, participantUuids, new HashSet<UUID>(), timeoutTick, new ArrayList<class_3222>(participants), region));
        for (class_3222 participant : participants) {
            RaidDenNetworkMessages.SEND_READY.send(participant, timeoutSeconds, participantNames, raidId);
        }
    }

    public static void playerReady(class_3222 player, UUID raidId) {
        ReadyCheckData check = ACTIVE_CHECKS.get(raidId);
        if (check == null) {
            return;
        }
        if (!check.participants().contains(player.method_5667())) {
            return;
        }
        check.readyPlayers().add(player.method_5667());
        RaidReadyManager.syncReadyStatus(check);
        if (check.readyPlayers().size() >= check.participants().size()) {
            RaidReadyManager.startBattle(raidId);
        }
    }

    private static void syncReadyStatus(ReadyCheckData check) {
        HashMap<String, Boolean> readyStatus = new HashMap<String, Boolean>();
        for (class_3222 participant : check.playerList()) {
            readyStatus.put(participant.method_5477().getString(), check.readyPlayers().contains(participant.method_5667()));
        }
        RaidReadySyncPacket syncPacket = new RaidReadySyncPacket(readyStatus);
        for (class_3222 participant : check.playerList()) {
            RaidDenNetworkMessages.SEND_READY_SYNC.accept(participant, syncPacket);
        }
    }

    public static void tick(MinecraftServer server) {
        long currentTick = server.method_30002().method_8510();
        ArrayList toStart = new ArrayList();
        ACTIVE_CHECKS.entrySet().removeIf(entry -> {
            ReadyCheckData check = (ReadyCheckData)entry.getValue();
            if (check.timeoutTick() <= currentTick) {
                toStart.add(check);
                return true;
            }
            return false;
        });
        for (ReadyCheckData check : toStart) {
            RaidReadyManager.startBattleWithCheck(check);
        }
    }

    private static void startBattle(UUID raidId) {
        ReadyCheckData check = ACTIVE_CHECKS.remove(raidId);
        if (check == null) {
            return;
        }
        RaidReadyManager.startBattleWithCheck(check);
    }

    private static void startBattleWithCheck(ReadyCheckData check) {
        UUID raidId = check.raidId();
        RaidInstance raidInstance = RaidHelper.ACTIVE_RAIDS.get(raidId);
        if (raidInstance == null) {
            return;
        }
        RaidRegion region = check.region();
        if (region == null) {
            return;
        }
        MinecraftServer server = check.playerList().get(0).method_5682();
        if (server == null) {
            return;
        }
        for (class_3222 participant : check.playerList()) {
            if (participant == null || !participant.method_5805()) continue;
            RaidDenNetworkMessages.CLOSE_READY_OVERLAY.accept(participant, raidId);
            RaidInventorySaveManager.saveAndClearInventory(participant);
            RaidUtils.teleportPlayerToRaid(participant, server, region);
            if (raidInstance.getPlayers().contains(participant)) continue;
            raidInstance.addPlayer(participant);
        }
        ArrayList<class_3222> playerSnapshot = new ArrayList<class_3222>(check.playerList());
        server.method_18858((Runnable)new class_3738(server.method_3780() + 15, () -> {
            RaidInstance ri = RaidHelper.ACTIVE_RAIDS.get(raidId);
            if (ri == null) {
                return;
            }
            PokemonEntity bossEntity = ri.getBossEntity();
            if (bossEntity == null || bossEntity.method_31481()) {
                return;
            }
            RaidBoss boss = ri.getRaidBoss();
            if (boss == null) {
                return;
            }
            TierConfig tierConfig = CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier());
            for (class_3222 participant : playerSnapshot) {
                if (participant == null || !participant.method_5805()) continue;
                Pokemon leadPokemon = RaidReadyManager.findFirstValidPokemon(participant);
                if (leadPokemon == null) {
                    participant.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.no_valid_pokemon"), true);
                    continue;
                }
                UUID leadingPokemonUuid = leadPokemon.getUuid();
                RaidBuilder.build(participant, bossEntity, leadingPokemonUuid, boss, tierConfig).ifSuccessful(battle -> {
                    ri.addBattle((PokemonBattle)battle);
                    RaidEvents.RAID_BATTLE_START.emit((Object[])new RaidBattleStartEvent[]{new RaidBattleStartEvent(participant, boss, (PokemonBattle)battle)});
                    return Unit.INSTANCE;
                }).ifErrored(errors -> {
                    participant.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.battle_start_failed"), true);
                    return Unit.INSTANCE;
                });
            }
        }));
    }

    public static Pokemon findFirstValidPokemon(class_3222 player) {
        PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)player);
        for (Pokemon pokemon : party) {
            if (pokemon == null || pokemon.isFainted() || RaidUtils.isPokemonBlacklisted(pokemon) || RaidUtils.isAbilityBlacklisted(pokemon.getAbility())) continue;
            return pokemon;
        }
        return null;
    }

    public static boolean isInReadyCheck(class_3222 player) {
        for (ReadyCheckData check : ACTIVE_CHECKS.values()) {
            if (!check.participants().contains(player.method_5667())) continue;
            return true;
        }
        return false;
    }

    public static void cancelCheck(UUID raidId) {
        ReadyCheckData check = ACTIVE_CHECKS.remove(raidId);
        if (check != null) {
            for (class_3222 player : check.playerList()) {
                RaidDenNetworkMessages.CLOSE_READY_OVERLAY.accept(player, raidId);
                RaidJoinHelper.removeParticipant((class_1657)player);
            }
        }
    }

    public static void onPlayerDisconnect(class_3222 player) {
        for (ReadyCheckData check : ACTIVE_CHECKS.values()) {
            check.participants().remove(player.method_5667());
            check.readyPlayers().remove(player.method_5667());
            check.playerList().removeIf(p -> p.method_5667().equals(player.method_5667()));
        }
    }

    public static void onServerClose() {
        ACTIVE_CHECKS.clear();
    }

    public record ReadyCheckData(UUID raidId, Set<UUID> participants, Set<UUID> readyPlayers, long timeoutTick, List<class_3222> playerList, RaidRegion region) {
    }
}

