/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids.helpers;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.client.gui.menu.RaidMenuOpener;
import com.necro.raid.dens.common.config.TierConfig;
import com.necro.raid.dens.common.data.dimension.RaidRegion;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.events.RaidBattleStartEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.events.RaidJoinEvent;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidBuilder;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidInventorySaveManager;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.raids.helpers.RaidReadyManager;
import com.necro.raid.dens.common.raids.helpers.RaidRegionHelper;
import com.necro.raid.dens.common.util.ComponentUtils;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3738;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class RaidInvitationManager {
    private static final Map<UUID, InvitationData> PENDING_INVITATIONS = new HashMap<UUID, InvitationData>();
    private static final Map<UUID, RaidSession> ACTIVE_SESSIONS = new HashMap<UUID, RaidSession>();
    private static final Map<UUID, UUID> HOST_CRYSTALS = new HashMap<UUID, UUID>();
    private static final Map<UUID, CrystalLocation> CRYSTAL_LOCATIONS = new HashMap<UUID, CrystalLocation>();
    private static final int INVITATION_TIMEOUT_TICKS = 1200;

    public static void handleConfirmation(class_3222 player, UUID crystalUuid) {
        if (!CobblemonRaidDens.CONFIG.enable_invitation_system) {
            RaidInvitationManager.startRaidSolo(player, crystalUuid);
            return;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        RaidCrystalBlockEntity crystal = RaidInvitationManager.findCrystalByUuid(server, crystalUuid);
        if (crystal == null) {
            return;
        }
        RaidBoss raidBoss = crystal.getRaidBoss();
        if (raidBoss == null) {
            return;
        }
        ArrayList<String> onlinePlayers = new ArrayList<String>();
        for (class_3222 onlinePlayer : server.method_3760().method_14571()) {
            if (onlinePlayer.method_5667().equals(player.method_5667())) continue;
            onlinePlayers.add(onlinePlayer.method_5477().getString());
        }
        TierConfig tierConfig = CobblemonRaidDens.TIER_CONFIG.get((Object)raidBoss.getTier());
        int maxInvites = tierConfig.maxInvitedPlayers();
        HOST_CRYSTALS.put(player.method_5667(), crystalUuid);
        if (RaidMenuOpener.OPEN_INVITE_MENU != null) {
            RaidMenuOpener.OPEN_INVITE_MENU.open(player, onlinePlayers, maxInvites, crystalUuid);
        } else {
            RaidDenNetworkMessages.SEND_INVITE_LIST.send(player, onlinePlayers, maxInvites, crystalUuid);
        }
    }

    public static void sendInvitations(class_3222 host, List<String> invitedPlayerNames, UUID crystalUuid) {
        MinecraftServer server = host.method_5682();
        if (server == null) {
            return;
        }
        RaidCrystalBlockEntity crystal = RaidInvitationManager.findCrystalByUuid(server, crystalUuid);
        if (crystal == null) {
            return;
        }
        RaidBoss raidBoss = crystal.getRaidBoss();
        if (raidBoss == null) {
            return;
        }
        if (invitedPlayerNames.isEmpty()) {
            RaidInvitationManager.startRaidSolo(host, crystalUuid);
            return;
        }
        crystal.setRaidHost((class_1657)host);
        boolean success = RaidEvents.RAID_JOIN.postWithResult(new RaidJoinEvent(host, true, raidBoss));
        if (!success) {
            crystal.clearRaidHost();
            return;
        }
        class_2960 structure = raidBoss.getRandomDen(host.method_37908().method_8409());
        RaidRegion region = RaidRegionHelper.createRegion(crystal.getUuid(), structure);
        if (region == null) {
            crystal.clearRaidHost();
            host.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.boss_spawn_failed"), true);
            return;
        }
        if (!crystal.spawnRaidBoss()) {
            crystal.closeRaid();
            host.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.boss_spawn_failed"), true);
            return;
        }
        RaidSession session = new RaidSession(crystalUuid, host.method_5667(), region);
        ACTIVE_SESSIONS.put(crystalUuid, session);
        if (RaidJoinHelper.addParticipant((class_1657)host, crystal.getUuid(), true, true)) {
            session.acceptedPlayers.add(host);
            host.method_7353(ComponentUtils.getSystemMessage(class_2561.method_43471((String)"message.cobblemonraiddens.raid.waiting_for_players")), true);
        }
        long currentTick = server.method_30002().method_8510();
        long expirationTick = currentTick + 1200L;
        String hostName = host.method_5477().getString();
        int tier = raidBoss.getTier().ordinal() + 1;
        String bossSpecies = raidBoss.getProperties().getSpecies();
        for (String playerName : invitedPlayerNames) {
            class_3222 invitee = server.method_3760().method_14566(playerName);
            if (invitee == null) continue;
            session.pendingInvites.add(invitee.method_5667());
            PENDING_INVITATIONS.put(invitee.method_5667(), new InvitationData(host.method_5667(), crystalUuid, expirationTick, hostName, tier, bossSpecies));
            RaidDenNetworkMessages.SEND_INVITATION.send(invitee, hostName, tier, bossSpecies, host.method_5667());
            class_5250 inviteMessage = class_2561.method_43469((String)"screen.cobblemonraiddens.invitation.description", (Object[])new Object[]{hostName, tier}).method_27692(class_124.field_1065);
            class_5250 clickText = class_2561.method_43470((String)" [").method_10852((class_2561)class_2561.method_43471((String)"screen.cobblemonraiddens.request.accept")).method_27693("]").method_27694(style -> style.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/crd viewinvite")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"screen.cobblemonraiddens.invitation.title"))));
            invitee.method_43496((class_2561)inviteMessage.method_10852((class_2561)clickText));
            host.method_7353(ComponentUtils.getSystemMessage(class_2561.method_43469((String)"message.cobblemonraiddens.invitation_sent", (Object[])new Object[]{playerName})), true);
        }
        HOST_CRYSTALS.put(host.method_5667(), crystalUuid);
    }

    public static void startRaidSolo(class_3222 host, UUID crystalUuid) {
        MinecraftServer server = host.method_5682();
        if (server == null) {
            return;
        }
        RaidCrystalBlockEntity crystal = RaidInvitationManager.findCrystalByUuid(server, crystalUuid);
        if (crystal == null) {
            return;
        }
        ArrayList<class_3222> participants = new ArrayList<class_3222>();
        participants.add(host);
        RaidInvitationManager.startRaidWithParticipants(host, crystal, participants);
    }

    public static void acceptInvitation(class_3222 invitee, UUID hostUuid) {
        InvitationData invitation = PENDING_INVITATIONS.remove(invitee.method_5667());
        if (invitation == null) {
            return;
        }
        MinecraftServer server = invitee.method_5682();
        if (server == null) {
            return;
        }
        RaidSession session = ACTIVE_SESSIONS.get(invitation.crystalUUID());
        if (session == null) {
            invitee.method_7353(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.request_time_out"), true);
            return;
        }
        session.pendingInvites.remove(invitee.method_5667());
        RaidCrystalBlockEntity crystal = RaidInvitationManager.findCrystalByUuid(server, invitation.crystalUUID());
        if (crystal == null) {
            invitee.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.boss_spawn_failed"), true);
            return;
        }
        if (!RaidJoinHelper.addParticipant((class_1657)invitee, crystal.getUuid(), false, true)) {
            invitee.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.already_in_raid"), true);
            return;
        }
        session.acceptedPlayers.add(invitee);
        invitee.method_7353(ComponentUtils.getSystemMessage(class_2561.method_43471((String)"message.cobblemonraiddens.raid.waiting_for_players")), true);
        class_3222 host = server.method_3760().method_14602(hostUuid);
        if (host != null) {
            host.method_7353(ComponentUtils.getSystemMessage(class_2561.method_43469((String)"message.cobblemonraiddens.invitation_accepted", (Object[])new Object[]{invitee.method_5477().getString()})), true);
        }
        if (session.pendingInvites.isEmpty()) {
            RaidInvitationManager.startReadyCheckForSession(session);
        }
    }

    public static void declineInvitation(class_3222 invitee, UUID hostUuid) {
        class_3222 host;
        InvitationData invitation = PENDING_INVITATIONS.remove(invitee.method_5667());
        if (invitation == null) {
            return;
        }
        MinecraftServer server = invitee.method_5682();
        if (server == null) {
            return;
        }
        RaidSession session = ACTIVE_SESSIONS.get(invitation.crystalUUID());
        if (session != null) {
            session.pendingInvites.remove(invitee.method_5667());
            if (session.pendingInvites.isEmpty()) {
                RaidInvitationManager.startReadyCheckForSession(session);
            }
        }
        if ((host = server.method_3760().method_14602(hostUuid)) != null) {
            host.method_7353(ComponentUtils.getSystemMessage(class_2561.method_43469((String)"message.cobblemonraiddens.invitation_declined", (Object[])new Object[]{invitee.method_5477().getString()})), true);
        }
    }

    private static void startReadyCheckForSession(RaidSession session) {
        if (session.acceptedPlayers.isEmpty()) {
            CobblemonRaidDens.LOGGER.error("No players accepted for raid session!");
            return;
        }
        ACTIVE_SESSIONS.remove(session.crystalUuid);
        HOST_CRYSTALS.remove(session.hostUuid);
        RaidReadyManager.startReadyCheck(session.crystalUuid, session.acceptedPlayers, session.region);
    }

    public static void launchRaid(class_3222 host, UUID crystalUuid) {
        RaidSession session = ACTIVE_SESSIONS.get(crystalUuid);
        if (session != null && !session.acceptedPlayers.isEmpty()) {
            PENDING_INVITATIONS.entrySet().removeIf(entry -> ((InvitationData)entry.getValue()).crystalUUID().equals(crystalUuid));
            RaidInvitationManager.startReadyCheckForSession(session);
        } else {
            RaidInvitationManager.startRaidSolo(host, crystalUuid);
        }
    }

    private static void startRaidWithParticipants(class_3222 host, RaidCrystalBlockEntity crystal, List<class_3222> participants) {
        MinecraftServer server = host.method_5682();
        if (server == null) {
            return;
        }
        RaidBoss raidBoss = crystal.getRaidBoss();
        if (raidBoss == null) {
            return;
        }
        crystal.setRaidHost((class_1657)host);
        boolean success = RaidEvents.RAID_JOIN.postWithResult(new RaidJoinEvent(host, true, raidBoss));
        if (!success) {
            crystal.clearRaidHost();
            return;
        }
        class_2960 structure = raidBoss.getRandomDen(host.method_37908().method_8409());
        RaidRegion region = RaidRegionHelper.createRegion(crystal.getUuid(), structure);
        if (region == null) {
            crystal.clearRaidHost();
            host.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.boss_spawn_failed"), true);
            return;
        }
        if (!crystal.spawnRaidBoss()) {
            crystal.closeRaid();
            host.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.boss_spawn_failed"), true);
            return;
        }
        RaidInstance raidInstance = RaidHelper.ACTIVE_RAIDS.get(crystal.getUuid());
        ArrayList<class_3222> teleportedParticipants = new ArrayList<class_3222>();
        for (class_3222 participant : participants) {
            boolean isHost = participant.method_5667().equals(host.method_5667());
            if (!RaidJoinHelper.addParticipant((class_1657)participant, crystal.getUuid(), isHost, true)) {
                CobblemonRaidDens.LOGGER.warn("Could not add participant {} - already in a raid?", (Object)participant.method_5477().getString());
                continue;
            }
            RaidInventorySaveManager.saveAndClearInventory(participant);
            RaidUtils.teleportPlayerToRaid(participant, server, region);
            crystal.syncAspects(participant);
            teleportedParticipants.add(participant);
            if (raidInstance == null) continue;
            raidInstance.addPlayer(participant);
        }
        if (teleportedParticipants.isEmpty()) {
            CobblemonRaidDens.LOGGER.error("No participants were teleported for raid!");
            crystal.closeRaid();
            return;
        }
        UUID crystalUuid2 = crystal.getUuid();
        server.method_18858((Runnable)new class_3738(server.method_3780() + 15, () -> {
            RaidInstance ri = RaidHelper.ACTIVE_RAIDS.get(crystalUuid2);
            if (ri == null) {
                return;
            }
            PokemonEntity bossEntity = ri.getBossEntity();
            if (bossEntity == null || bossEntity.method_31481()) {
                return;
            }
            RaidBoss boss = ri.getRaidBoss();
            if (boss == null) {
                return;
            }
            TierConfig tierConfig = CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier());
            for (class_3222 participant : teleportedParticipants) {
                if (participant == null || !participant.method_5805()) continue;
                Pokemon leadPokemon = RaidReadyManager.findFirstValidPokemon(participant);
                if (leadPokemon == null) {
                    participant.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.no_valid_pokemon"), true);
                    continue;
                }
                UUID leadingPokemonUuid = leadPokemon.getUuid();
                RaidBuilder.build(participant, bossEntity, leadingPokemonUuid, boss, tierConfig).ifSuccessful(battle -> {
                    ri.addBattle((PokemonBattle)battle);
                    RaidEvents.RAID_BATTLE_START.emit((Object[])new RaidBattleStartEvent[]{new RaidBattleStartEvent(participant, boss, (PokemonBattle)battle)});
                    return Unit.INSTANCE;
                }).ifErrored(errors -> {
                    participant.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.battle_start_failed"), true);
                    return Unit.INSTANCE;
                });
            }
        }));
    }

    public static void tick(MinecraftServer server) {
        long currentTick = server.method_30002().method_8510();
        ArrayList expiredCrystals = new ArrayList();
        PENDING_INVITATIONS.entrySet().removeIf(entry -> {
            if (((InvitationData)entry.getValue()).expirationTick() <= currentTick) {
                RaidSession session;
                class_3222 player = server.method_3760().method_14602((UUID)entry.getKey());
                if (player != null) {
                    player.method_7353(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.request_time_out"), true);
                }
                if ((session = ACTIVE_SESSIONS.get(((InvitationData)entry.getValue()).crystalUUID())) != null) {
                    session.pendingInvites.remove(entry.getKey());
                    if (session.pendingInvites.isEmpty() && !expiredCrystals.contains(session.crystalUuid)) {
                        expiredCrystals.add(session.crystalUuid);
                    }
                }
                return true;
            }
            return false;
        });
        for (UUID crystalUuid : expiredCrystals) {
            RaidSession session = ACTIVE_SESSIONS.get(crystalUuid);
            if (session == null || session.acceptedPlayers.isEmpty()) continue;
            RaidInvitationManager.startReadyCheckForSession(session);
        }
    }

    public static void onPlayerDisconnect(class_3222 player) {
        PENDING_INVITATIONS.remove(player.method_5667());
        HOST_CRYSTALS.remove(player.method_5667());
        for (RaidSession session : ACTIVE_SESSIONS.values()) {
            session.pendingInvites.remove(player.method_5667());
            session.acceptedPlayers.removeIf(p -> p.method_5667().equals(player.method_5667()));
        }
        RaidJoinHelper.removeParticipant((class_1657)player);
    }

    public static void onServerClose() {
        PENDING_INVITATIONS.clear();
        ACTIVE_SESSIONS.clear();
        HOST_CRYSTALS.clear();
        CRYSTAL_LOCATIONS.clear();
    }

    public static boolean hasPendingInvitation(UUID playerUuid) {
        return PENDING_INVITATIONS.containsKey(playerUuid);
    }

    public static void registerCrystal(UUID crystalUuid, class_3218 level, class_2338 pos) {
        CRYSTAL_LOCATIONS.put(crystalUuid, new CrystalLocation(level, pos));
    }

    public static void unregisterCrystal(UUID crystalUuid) {
        CRYSTAL_LOCATIONS.remove(crystalUuid);
    }

    private static RaidCrystalBlockEntity findCrystalByUuid(MinecraftServer server, UUID crystalUuid) {
        CrystalLocation location = CRYSTAL_LOCATIONS.get(crystalUuid);
        if (location != null) {
            RaidCrystalBlockEntity crystal;
            class_2586 blockEntity = location.level().method_8321(location.pos());
            if (blockEntity instanceof RaidCrystalBlockEntity && (crystal = (RaidCrystalBlockEntity)blockEntity).getUuid().equals(crystalUuid)) {
                return crystal;
            }
            CRYSTAL_LOCATIONS.remove(crystalUuid);
        }
        return null;
    }

    public static class RaidSession {
        public final UUID crystalUuid;
        public final UUID hostUuid;
        public final RaidRegion region;
        public final List<class_3222> acceptedPlayers = new ArrayList<class_3222>();
        public final Set<UUID> pendingInvites = new HashSet<UUID>();

        public RaidSession(UUID crystalUuid, UUID hostUuid, RaidRegion region) {
            this.crystalUuid = crystalUuid;
            this.hostUuid = hostUuid;
            this.region = region;
        }
    }

    public record InvitationData(UUID hostUUID, UUID crystalUUID, long expirationTick, String hostName, int tier, String bossSpecies) {
    }

    public record CrystalLocation(class_3218 level, class_2338 pos) {
    }
}

