/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_7225;

public class RaidInventorySaveManager {
    private static final Map<UUID, SavedInventory> SAVED_INVENTORIES = new HashMap<UUID, SavedInventory>();

    public static void saveAndClearInventory(class_3222 player) {
        UUID playerUuid = player.method_5667();
        if (SAVED_INVENTORIES.containsKey(playerUuid)) {
            return;
        }
        class_1661 inventory = player.method_31548();
        class_2487 savedTag = new class_2487();
        class_2499 itemList = new class_2499();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            itemList.add((Object)stack.method_57376((class_7225.class_7874)player.method_56673(), (class_2520)itemTag));
        }
        savedTag.method_10566("Items", (class_2520)itemList);
        class_2499 armorList = new class_2499();
        for (int i = 0; i < inventory.field_7548.size(); ++i) {
            class_1799 stack = (class_1799)inventory.field_7548.get(i);
            if (stack.method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            armorList.add((Object)stack.method_57376((class_7225.class_7874)player.method_56673(), (class_2520)itemTag));
        }
        savedTag.method_10566("Armor", (class_2520)armorList);
        class_1799 offhand = (class_1799)inventory.field_7544.get(0);
        if (!offhand.method_7960()) {
            savedTag.method_10566("Offhand", offhand.method_57358((class_7225.class_7874)player.method_56673()));
        }
        SAVED_INVENTORIES.put(playerUuid, new SavedInventory(savedTag));
        inventory.method_5448();
    }

    public static void restoreInventory(class_3222 player) {
        class_1799 stack;
        int slot;
        class_2487 itemTag;
        int i;
        UUID playerUuid = player.method_5667();
        SavedInventory saved = SAVED_INVENTORIES.remove(playerUuid);
        if (saved == null) {
            return;
        }
        class_2487 savedTag = saved.inventoryTag();
        class_1661 inventory = player.method_31548();
        inventory.method_5448();
        if (savedTag.method_10545("Items")) {
            class_2499 itemList = savedTag.method_10554("Items", 10);
            for (i = 0; i < itemList.size(); ++i) {
                itemTag = itemList.method_10602(i);
                slot = itemTag.method_10550("Slot");
                stack = class_1799.method_57360((class_7225.class_7874)player.method_56673(), (class_2520)itemTag).orElse(class_1799.field_8037);
                if (slot < 0 || slot >= inventory.method_5439()) continue;
                inventory.method_5447(slot, stack);
            }
        }
        if (savedTag.method_10545("Armor")) {
            class_2499 armorList = savedTag.method_10554("Armor", 10);
            for (i = 0; i < armorList.size(); ++i) {
                itemTag = armorList.method_10602(i);
                slot = itemTag.method_10550("Slot");
                stack = class_1799.method_57360((class_7225.class_7874)player.method_56673(), (class_2520)itemTag).orElse(class_1799.field_8037);
                if (slot < 0 || slot >= inventory.field_7548.size()) continue;
                inventory.field_7548.set(slot, (Object)stack);
            }
        }
        if (savedTag.method_10545("Offhand")) {
            class_1799 offhand = class_1799.method_57360((class_7225.class_7874)player.method_56673(), (class_2520)savedTag.method_10562("Offhand")).orElse(class_1799.field_8037);
            inventory.field_7544.set(0, (Object)offhand);
        }
    }

    public static boolean hasSavedInventory(class_3222 player) {
        return SAVED_INVENTORIES.containsKey(player.method_5667());
    }

    public static void onPlayerDisconnect(class_3222 player) {
    }

    public static void onPlayerJoin(class_3222 player) {
        if (SAVED_INVENTORIES.containsKey(player.method_5667())) {
            RaidInventorySaveManager.restoreInventory(player);
        }
    }

    public static void restoreInventories(Collection<? extends class_3222> players) {
        for (class_3222 class_32222 : players) {
            RaidInventorySaveManager.restoreInventory(class_32222);
        }
    }

    public static void onServerClose() {
        SAVED_INVENTORIES.clear();
    }

    public record SavedInventory(class_2487 inventoryTag) {
    }
}

