/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids.helpers;

import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.RaidState;
import com.necro.raid.dens.common.raids.RequestHandler;
import com.necro.raid.dens.common.raids.RewardHandler;
import com.necro.raid.dens.common.raids.helpers.RaidRegionHelper;
import com.necro.raid.dens.common.util.IRaidTeleporter;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class RaidHelper
extends class_18 {
    public static RaidHelper INSTANCE;
    public static final Map<UUID, RaidInstance> ACTIVE_RAIDS;
    public static final Map<UUID, RequestHandler> REQUEST_QUEUE;
    public static final Map<UUID, RewardHandler> REWARD_QUEUE;
    private final Map<UUID, Set<UUID>> CLEARED_RAIDS = new HashMap<UUID, Set<UUID>>();
    private final Map<UUID, RaidState> RAID_CLOSE_QUEUE = new HashMap<UUID, RaidState>();

    public static void initRequest(class_3222 host, RaidCrystalBlockEntity blockEntity) {
        if (REQUEST_QUEUE.containsKey(host.method_5667())) {
            return;
        }
        REQUEST_QUEUE.put(host.method_5667(), new RequestHandler(blockEntity));
    }

    public static void addRequest(class_3222 host, class_1657 player) {
        UUID uuid = host.method_5667();
        if (!REQUEST_QUEUE.containsKey(uuid)) {
            return;
        }
        REQUEST_QUEUE.get(uuid).addPlayer(player);
    }

    public static RequestHandler getRequest(class_3222 host) {
        if (!REQUEST_QUEUE.containsKey(host.method_5667())) {
            return null;
        }
        return REQUEST_QUEUE.get(host.method_5667());
    }

    public static void removeRequests(UUID host) {
        REQUEST_QUEUE.remove(host);
    }

    public static boolean hasClearedRaid(UUID raid, class_1657 player) {
        Set cleared = RaidHelper.INSTANCE.CLEARED_RAIDS.getOrDefault(raid, new HashSet());
        return cleared.contains(player.method_5667());
    }

    public static void closeRaid(UUID raid, RaidState raidState, class_3218 level) {
        RaidInstance instance = ACTIVE_RAIDS.remove(raid);
        if (instance == null) {
            return;
        }
        if (raidState == RaidState.CANCELLED) {
            RaidRegionHelper.clearRegion(raid, level);
        } else {
            RaidHelper.INSTANCE.RAID_CLOSE_QUEUE.put(raid, raidState);
        }
    }

    public static void clearRaid(UUID raid, Collection<? extends class_1657> players) {
        if (!RaidHelper.INSTANCE.CLEARED_RAIDS.containsKey(raid)) {
            RaidHelper.INSTANCE.CLEARED_RAIDS.put(raid, new HashSet());
        }
        for (class_1657 class_16572 : players) {
            RaidHelper.INSTANCE.CLEARED_RAIDS.get(raid).add(class_16572.method_5667());
        }
        INSTANCE.method_80();
    }

    public static void resetClearedRaids(UUID raid) {
        if (INSTANCE == null) {
            return;
        }
        RaidHelper.INSTANCE.CLEARED_RAIDS.remove(raid);
        INSTANCE.method_80();
    }

    public static void resetPlayerClearedRaid(UUID raid, UUID player) {
        if (!RaidHelper.INSTANCE.CLEARED_RAIDS.containsKey(raid)) {
            return;
        }
        RaidHelper.INSTANCE.CLEARED_RAIDS.get(raid).remove(player);
        INSTANCE.method_80();
    }

    public static void resetPlayerAllClearedRaids(UUID player) {
        RaidHelper.INSTANCE.CLEARED_RAIDS.values().forEach(playerSet -> playerSet.remove(player));
        INSTANCE.method_80();
    }

    public static boolean hasRaidState(UUID raid) {
        return RaidHelper.INSTANCE.RAID_CLOSE_QUEUE.containsKey(raid);
    }

    public static RaidState getRaidState(UUID raid) {
        RaidState state = RaidHelper.INSTANCE.RAID_CLOSE_QUEUE.remove(raid);
        INSTANCE.method_80();
        return state;
    }

    public static void teleportFromRaid(class_3222 player) {
        if (RaidUtils.isRaidDimension(player.method_37908())) {
            ((IRaidTeleporter)player).crd_returnHome();
        }
    }

    public static void onServerClose(MinecraftServer server) {
        server.execute(RaidHelper::closeAllRaids);
    }

    private static void closeAllRaids() {
        REQUEST_QUEUE.forEach((uuid, handler) -> handler.getBlockEntity().closeRaid());
    }

    public static void commonTick() {
        ArrayList<RaidInstance> raids = new ArrayList<RaidInstance>(ACTIVE_RAIDS.values());
        raids.forEach(RaidInstance::tick);
    }

    public static RaidHelper create() {
        return new RaidHelper();
    }

    public static void initHelper(MinecraftServer server) {
        INSTANCE = (RaidHelper)server.method_30002().method_17983().method_17924(RaidHelper.type(), "cobblemonraiddens");
        INSTANCE.method_80();
    }

    public static RaidHelper load(class_2487 compoundTag, class_7225.class_7874 provider) {
        RaidHelper data = RaidHelper.create();
        class_2499 clearedRaids = compoundTag.method_10554("cleared_raids", 10);
        for (Object t : clearedRaids) {
            class_2487 entry = (class_2487)t;
            String uuid = entry.method_10558("uuid");
            if (uuid.isEmpty()) continue;
            HashSet<UUID> players = new HashSet<UUID>();
            class_2499 uuidList = entry.method_10554("players", 11);
            for (class_2520 uuidTag : uuidList) {
                players.add(class_2512.method_25930((class_2520)uuidTag));
            }
            data.CLEARED_RAIDS.put(UUID.fromString(uuid), players);
        }
        class_2499 raidCloseQueue = compoundTag.method_10554("raid_close_queue", 10);
        for (class_2520 t : raidCloseQueue) {
            class_2487 entry = (class_2487)t;
            String uuid = entry.method_10558("uuid");
            if (uuid.isEmpty()) continue;
            RaidState state = RaidState.fromString(entry.method_10558("state"));
            data.RAID_CLOSE_QUEUE.put(UUID.fromString(uuid), state);
        }
        REWARD_QUEUE.clear();
        class_2499 rewardQueue = compoundTag.method_10554("reward_queue", 10);
        for (class_2520 t : rewardQueue) {
            class_2487 entry = (class_2487)t;
            try {
                RewardHandler handler = RewardHandler.deserialize(entry, provider);
                UUID playerUUID = entry.method_25926("player");
                REWARD_QUEUE.put(playerUUID, handler);
            }
            catch (Exception e) {
                CobblemonRaidDens.LOGGER.error("Failed to load reward handler", (Throwable)e);
            }
        }
        return data;
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 provider) {
        class_2499 clearedRaidsTag = new class_2499();
        for (Map.Entry<UUID, Set<UUID>> entry : this.CLEARED_RAIDS.entrySet()) {
            class_2487 class_24872 = new class_2487();
            class_24872.method_10582("uuid", entry.getKey().toString());
            class_2499 uuidList = new class_2499();
            for (UUID uuid : entry.getValue()) {
                uuidList.add((Object)class_2512.method_25929((UUID)uuid));
            }
            class_24872.method_10566("players", (class_2520)uuidList);
            clearedRaidsTag.add((Object)class_24872);
        }
        compoundTag.method_10566("cleared_raids", (class_2520)clearedRaidsTag);
        class_2499 raidCloseQueue = new class_2499();
        for (Map.Entry<UUID, RaidState> entry : this.RAID_CLOSE_QUEUE.entrySet()) {
            class_2487 e = new class_2487();
            e.method_10582("uuid", entry.getKey().toString());
            e.method_10582("state", entry.getValue().method_15434());
            raidCloseQueue.add((Object)e);
        }
        compoundTag.method_10566("raid_close_queue", (class_2520)raidCloseQueue);
        class_2499 class_24992 = new class_2499();
        for (RewardHandler handler : REWARD_QUEUE.values()) {
            class_24992.add((Object)handler.serialize(provider));
        }
        compoundTag.method_10566("reward_queue", (class_2520)class_24992);
        return compoundTag;
    }

    public static class_18.class_8645<RaidHelper> type() {
        return new class_18.class_8645(RaidHelper::create, RaidHelper::load, null);
    }

    static {
        ACTIVE_RAIDS = new HashMap<UUID, RaidInstance>();
        REQUEST_QUEUE = new HashMap<UUID, RequestHandler>();
        REWARD_QUEUE = new HashMap<UUID, RewardHandler>();
    }
}

