/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids.helpers;

import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.ModBlocks;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.data.raid.RaidCycleMode;
import com.necro.raid.dens.common.data.raid.RaidTier;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.network.packets.RaidCrystalSpawnPacket;
import com.necro.raid.dens.common.registry.RaidRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class RaidAutoSpawner {
    private static long nextSpawnTick = 0L;
    private static final Random RANDOM = new Random();
    private static final Set<class_2338> AUTO_SPAWNED_CRYSTALS = new HashSet<class_2338>();

    public static void tick(MinecraftServer server) {
        if (!CobblemonRaidDens.CONFIG.enable_auto_spawn) {
            return;
        }
        long currentTick = server.method_30002().method_8510();
        if (nextSpawnTick == 0L) {
            RaidAutoSpawner.scheduleNextSpawn(currentTick);
            return;
        }
        if (currentTick >= nextSpawnTick) {
            RaidAutoSpawner.spawnCrystalNearRandomPlayer(server);
            RaidAutoSpawner.scheduleNextSpawn(currentTick);
        }
    }

    private static void scheduleNextSpawn(long currentTick) {
        int maxTicks = CobblemonRaidDens.CONFIG.auto_spawn_max_minutes * 60 * 20;
        int minTicks = CobblemonRaidDens.CONFIG.auto_spawn_min_minutes * 60 * 20;
        int range = maxTicks - minTicks;
        if (range <= 0) {
            range = 1;
        }
        nextSpawnTick = currentTick + (long)minTicks + (long)RANDOM.nextInt(range);
    }

    private static void spawnCrystalNearRandomPlayer(MinecraftServer server) {
        ArrayList players = new ArrayList(server.method_3760().method_14571());
        if (players.isEmpty()) {
            return;
        }
        class_3222 target = (class_3222)players.get(RANDOM.nextInt(players.size()));
        class_3218 level = target.method_51469();
        int tierIndex = RaidAutoSpawner.getWeightedRandomTier();
        RaidTier raidTier = RaidTier.values()[Math.min(tierIndex - 1, RaidTier.values().length - 1)];
        class_2960 bossLocation = RaidRegistry.getRandomRaidBoss(level.method_8409(), (class_1937)level, raidTier, null, null);
        if (bossLocation == null) {
            CobblemonRaidDens.LOGGER.warn("No raid boss found for tier {}", (Object)tierIndex);
            return;
        }
        RaidBoss raidBoss = RaidRegistry.getRaidBoss(bossLocation);
        if (raidBoss == null) {
            CobblemonRaidDens.LOGGER.warn("Failed to load raid boss {}", (Object)bossLocation);
            return;
        }
        class_2338 spawnPos = RaidAutoSpawner.findSurfaceSpawnPos(level, target.method_24515());
        if (spawnPos == null) {
            CobblemonRaidDens.LOGGER.debug("No valid surface spawn position found near {}", (Object)target.method_5477().getString());
            return;
        }
        class_2680 crystalState = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)ModBlocks.INSTANCE.getRaidCrystalBlock().method_9564().method_11657((class_2769)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)RaidCrystalBlock.CAN_RESET, (Comparable)Boolean.valueOf(true))).method_11657(RaidCrystalBlock.CYCLE_MODE, (Comparable)((Object)RaidCycleMode.CONFIG))).method_11657(RaidCrystalBlock.RAID_TYPE, (Comparable)((Object)raidBoss.getType()))).method_11657(RaidCrystalBlock.RAID_TIER, (Comparable)((Object)raidBoss.getTier()));
        level.method_8652(spawnPos, crystalState, 3);
        class_2586 class_25862 = level.method_8321(spawnPos);
        if (!(class_25862 instanceof RaidCrystalBlockEntity)) {
            CobblemonRaidDens.LOGGER.warn("Failed to get crystal block entity at {}", (Object)spawnPos);
            level.method_8650(spawnPos, false);
            return;
        }
        RaidCrystalBlockEntity crystal = (RaidCrystalBlockEntity)class_25862;
        crystal.setAutoSpawned(true);
        crystal.setRaidBoss(bossLocation, level.method_8510());
        AUTO_SPAWNED_CRYSTALS.add(spawnPos);
        int actualTier = raidBoss.getTier().ordinal() + 1;
        String bossName = raidBoss.getProperties().getSpecies();
        CobblemonRaidDens.LOGGER.info("Auto-spawned crystal with {} (tier {}) near {} at {}", new Object[]{bossName, actualTier, target.method_5477().getString(), spawnPos});
        String playerName = target.method_5477().getString();
        RaidCrystalSpawnPacket packet = new RaidCrystalSpawnPacket(playerName, actualTier, spawnPos);
        for (class_3222 player : server.method_3760().method_14571()) {
            RaidDenNetworkMessages.SEND_CRYSTAL_SPAWN.accept(player, packet);
        }
    }

    private static int getWeightedRandomTier() {
        double[] weights = CobblemonRaidDens.CONFIG.auto_spawn_tier_weights;
        if (weights == null || weights.length == 0) {
            return 1;
        }
        double totalWeight = 0.0;
        for (double weight : weights) {
            totalWeight += weight;
        }
        double random = RANDOM.nextDouble() * totalWeight;
        double cumulative = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            if (!(random <= (cumulative += weights[i]))) continue;
            return i + 1;
        }
        return 1;
    }

    private static class_2338 findSurfaceSpawnPos(class_3218 level, class_2338 playerPos) {
        int minDistance = 20;
        int maxDistance = 40;
        int requiredAirAbove = 100;
        block0: for (int attempt = 0; attempt < 50; ++attempt) {
            int dx = RANDOM.nextInt(maxDistance - minDistance + 1) + minDistance;
            int dz = RANDOM.nextInt(maxDistance - minDistance + 1) + minDistance;
            if (RANDOM.nextBoolean()) {
                dx = -dx;
            }
            if (RANDOM.nextBoolean()) {
                dz = -dz;
            }
            int x = playerPos.method_10263() + dx;
            int z = playerPos.method_10260() + dz;
            class_2338.class_2339 mutablePos = new class_2338.class_2339(x, level.method_31600() - 1, z);
            while (mutablePos.method_10264() > level.method_31607()) {
                class_2680 state = level.method_8320((class_2338)mutablePos);
                if (state.method_51367()) {
                    class_2680 aboveState;
                    class_2338 spawnPos = mutablePos.method_10084();
                    if (!level.method_8320(spawnPos).method_26215()) continue block0;
                    int airCount = 0;
                    for (int y = spawnPos.method_10264(); y < level.method_31600() && airCount < requiredAirAbove && (aboveState = level.method_8320(new class_2338(x, y, z))).method_26215(); ++airCount, ++y) {
                    }
                    if (airCount < requiredAirAbove) continue block0;
                    return spawnPos;
                }
                mutablePos.method_10100(0, -1, 0);
            }
        }
        return null;
    }

    public static boolean isAutoSpawned(class_2338 pos) {
        return AUTO_SPAWNED_CRYSTALS.contains(pos);
    }

    public static void onCrystalRemoved(class_2338 pos) {
        AUTO_SPAWNED_CRYSTALS.remove(pos);
    }

    public static void onServerClose() {
        AUTO_SPAWNED_CRYSTALS.clear();
        nextSpawnTick = 0L;
    }
}

