/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.dispatch.DispatchResultKt;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.net.messages.client.battle.BattleApplyPassResponsePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.config.TierConfig;
import com.necro.raid.dens.common.data.dimension.RaidRegion;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.events.RaidEndEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidState;
import com.necro.raid.dens.common.raids.RewardDistribution;
import com.necro.raid.dens.common.raids.RewardHandler;
import com.necro.raid.dens.common.raids.battle.RaidBattleState;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidInventorySaveManager;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.raids.helpers.RaidRegionHelper;
import com.necro.raid.dens.common.raids.helpers.RaidScriptHelper;
import com.necro.raid.dens.common.showdown.bagitems.CheerBagItem;
import com.necro.raid.dens.common.showdown.events.BroadcastingShowdownEvent;
import com.necro.raid.dens.common.showdown.events.CheerAttackShowdownEvent;
import com.necro.raid.dens.common.showdown.events.CheerDefenseShowdownEvent;
import com.necro.raid.dens.common.showdown.events.CheerHealShowdownEvent;
import com.necro.raid.dens.common.showdown.events.PlayerJoinShowdownEvent;
import com.necro.raid.dens.common.showdown.events.ShowdownEvent;
import com.necro.raid.dens.common.showdown.events.StartRaidShowdownEvent;
import com.necro.raid.dens.common.util.ComponentUtils;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IRaidBattle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RaidInstance {
    private final PokemonEntity bossEntity;
    private final UUID host;
    private final UUID raid;
    private final RaidBoss raidBoss;
    private final class_3213 bossEvent;
    private final List<PokemonBattle> battles;
    private final Map<UUID, Float> damageTracker;
    private final List<class_3222> activePlayers;
    private final Set<UUID> failedPlayers;
    private float currentHealth;
    private float maxHealth;
    private final float initMaxHealth;
    private final Map<Integer, List<ShowdownEvent>> scriptByTurn;
    private final NavigableMap<Double, List<ShowdownEvent>> scriptByHp;
    private final Map<UUID, Integer> cheersLeft;
    private final List<DelayedRunnable> runQueue;
    private RaidState raidState;
    private final RaidBattleState battleState;

    public RaidInstance(PokemonEntity entity, UUID host) {
        this.bossEntity = entity;
        this.host = host;
        this.raid = ((IRaidAccessor)entity).crd_getRaidId();
        this.raidBoss = ((IRaidAccessor)entity).crd_getRaidBoss();
        this.bossEvent = new class_3213((class_2561)((class_5250)entity.method_5477()).method_27692(class_124.field_1067).method_27692(class_124.field_1068), class_1259.class_1260.field_5786, class_1259.class_1261.field_5791);
        this.battles = new ArrayList<PokemonBattle>();
        this.damageTracker = new HashMap<UUID, Float>();
        this.activePlayers = new ArrayList<class_3222>();
        this.failedPlayers = new HashSet<UUID>();
        this.currentHealth = this.maxHealth = (float)(this.raidBoss.getHealthMulti() * this.bossEntity.getPokemon().getMaxHealth());
        this.initMaxHealth = this.maxHealth;
        this.cheersLeft = new HashMap<UUID, Integer>();
        this.runQueue = new ArrayList<DelayedRunnable>();
        this.runQueue.add(new DelayedRunnable(() -> {
            if (this.bossEntity.method_29504()) {
                return;
            }
            ArrayList<PokemonBattle> battleCache = new ArrayList<PokemonBattle>(this.battles);
            for (PokemonBattle battle : battleCache) {
                if (battle.getEnded()) continue;
                battle.checkFlee();
            }
        }, 20, true));
        this.raidState = RaidState.NOT_STARTED;
        this.battleState = new RaidBattleState();
        this.scriptByTurn = new HashMap<Integer, List<ShowdownEvent>>();
        this.scriptByHp = new TreeMap<Double, List<ShowdownEvent>>();
        this.raidBoss.getScript().forEach((key, scripts) -> {
            List<ShowdownEvent> functions = scripts.functions().stream().map(this::getInstructions).filter(Objects::nonNull).toList();
            if (functions.isEmpty()) {
                return;
            }
            try {
                if (key.startsWith("turn:")) {
                    this.scriptByTurn.put(Integer.parseInt(key.split(":")[1]), functions);
                } else if (key.startsWith("hp:")) {
                    double threshold = Double.parseDouble(key.split(":")[1]);
                    if ((double)(this.currentHealth / this.maxHealth) < threshold) {
                        return;
                    }
                    this.scriptByHp.put(threshold, functions);
                } else if (key.startsWith("after:") || key.startsWith("repeat:")) {
                    int time = Integer.parseInt(key.split(":")[1]) * 20;
                    this.runQueue.add(new DelayedRunnable(() -> functions.forEach(event -> this.sendEvent((ShowdownEvent)event, null)), time, key.startsWith("repeat:")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void addPlayerAndBattle(class_3222 player, PokemonBattle battle) {
        this.addPlayer(player);
        this.addBattle(battle);
    }

    public void addPlayer(class_3222 player) {
        TierConfig tierConfig = CobblemonRaidDens.TIER_CONFIG.get((Object)this.raidBoss.getTier());
        this.addToBossEvent(player);
        this.damageTracker.put(player.method_5667(), Float.valueOf(0.0f));
        if (!this.activePlayers.isEmpty() && tierConfig.multiplayerHealthMultiplier() > 1.0f) {
            this.applyHealthMulti();
        }
        this.cheersLeft.put(player.method_5667(), tierConfig.maxCheers());
        this.activePlayers.add(player);
        RaidDenNetworkMessages.SYNC_HEALTH.accept(player, Float.valueOf(this.currentHealth / this.maxHealth));
    }

    public void addBattle(PokemonBattle battle) {
        TierConfig tierConfig = CobblemonRaidDens.TIER_CONFIG.get((Object)this.raidBoss.getTier());
        ((IRaidBattle)battle).crd_setRaidBattle(this);
        if (!this.battles.isEmpty() && tierConfig.multiplayerHealthMultiplier() > 1.0f) {
            this.playerJoin(((class_3222)battle.getPlayers().getFirst()).method_5477().getString());
        }
        this.battles.add(battle);
        new StartRaidShowdownEvent(this.battleState).send(battle);
        this.runScriptByTurn(0, battle);
        if (this.raidState == RaidState.NOT_STARTED) {
            this.raidState = RaidState.IN_PROGRESS;
        }
    }

    private void applyHealthMulti() {
        float bonusHealth = this.initMaxHealth * (CobblemonRaidDens.TIER_CONFIG.get((Object)this.raidBoss.getTier()).multiplayerHealthMultiplier() - 1.0f) * (float)this.activePlayers.size();
        float currentRatio = this.currentHealth / this.maxHealth;
        this.maxHealth = this.initMaxHealth + bonusHealth;
        this.currentHealth = this.maxHealth * currentRatio;
    }

    private void playerJoin(String newPlayer) {
        this.sendEvent(new PlayerJoinShowdownEvent(newPlayer), null);
    }

    public void removePlayer(class_3222 player, @Nullable PokemonBattle battle) {
        this.removeFromBossEvent(player);
        if (this.raidState != RaidState.NOT_STARTED) {
            this.failedPlayers.add(player.method_5667());
        }
        if (this.failedPlayers.size() >= this.activePlayers.size()) {
            this.stopRaid(false);
        }
        if (battle == null) {
            return;
        }
        this.battles.remove(battle);
        ((IRaidBattle)battle).crd_setRaidBattle(null);
    }

    public void removePlayer(PokemonBattle battle) {
        List players = battle.getPlayers();
        if (players.isEmpty()) {
            return;
        }
        this.removePlayer((class_3222)players.getFirst(), battle);
    }

    public void removePlayer(class_3222 player) {
        this.removePlayer(player, null);
    }

    public void syncHealth(class_3222 player, PokemonBattle battle, float damage) {
        if (!this.activePlayers.contains(player) && ((IRaidBattle)battle).crd_isRaidBattle()) {
            this.addPlayerAndBattle(player, battle);
        }
        this.damageTracker.computeIfPresent(player.method_5667(), (uuid, totalDamage) -> Float.valueOf(totalDamage.floatValue() + damage));
        this.currentHealth = Math.clamp(this.currentHealth - damage, 0.0f, this.maxHealth);
        this.activePlayers.forEach(p -> RaidDenNetworkMessages.SYNC_HEALTH.accept((class_3222)p, Float.valueOf(this.currentHealth / this.maxHealth)));
        if (this.currentHealth == 0.0f) {
            this.bossEvent.method_5408(this.currentHealth / this.maxHealth);
            this.queueStopRaid();
        } else {
            this.runQueue.add(new DelayedRunnable(() -> {
                this.bossEvent.method_5408(this.currentHealth / this.maxHealth);
                this.runScriptByHp((double)this.currentHealth / (double)this.maxHealth);
            }, 20));
        }
    }

    public List<class_3222> getPlayers() {
        return this.activePlayers;
    }

    public List<PokemonBattle> getBattles() {
        return this.battles;
    }

    public float getRemainingHealth() {
        return this.currentHealth;
    }

    public boolean hasFailed(class_3222 player) {
        return this.failedPlayers.contains(player.method_5667());
    }

    public void tick() {
        if (this.isFinished()) {
            return;
        }
        try {
            this.runQueue.removeIf(DelayedRunnable::tick);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void queueStopRaid() {
        this.queueStopRaid(true);
    }

    public void queueStopRaid(boolean raidSuccess) {
        this.runQueue.add(new DelayedRunnable(() -> this.stopRaid(raidSuccess), 60));
    }

    public void stopRaid(boolean raidSuccess) {
        this.bossEvent.method_14091(false);
        this.bossEvent.method_14094();
        if (raidSuccess) {
            this.bossEntity.method_6033(0.0f);
        }
        if (this.raidBoss == null) {
            return;
        }
        if (raidSuccess) {
            this.handleSuccess();
        } else {
            this.handleFailed();
        }
        this.closeRaid(this.bossEntity.method_5682());
    }

    private void handleSuccess() {
        Pokemon cachedReward;
        List<Object> failed;
        List<Object> success;
        this.raidState = RaidState.SUCCESS;
        ((IRaidAccessor)this.bossEntity).crd_setRaidState(RaidState.SUCCESS);
        int catches = this.raidBoss.getMaxCatches();
        if (catches == 0) {
            success = List.of();
            failed = this.activePlayers;
        } else if (CobblemonRaidDens.CONFIG.reward_distribution == RewardDistribution.SURVIVOR) {
            ArrayList<class_3222> survivors = new ArrayList<class_3222>();
            failed = new ArrayList<class_3222>();
            for (class_3222 player2 : this.activePlayers) {
                if (this.failedPlayers.contains(player2.method_5667())) {
                    failed.add(player2);
                    continue;
                }
                survivors.add(player2);
            }
            if (catches > 0 && survivors.size() > catches) {
                Collections.shuffle(survivors);
                success = survivors.subList(0, catches);
                failed.addAll(survivors.subList(catches, survivors.size()));
            } else {
                success = survivors;
            }
        } else if (catches < 0 || this.activePlayers.size() < catches) {
            success = this.activePlayers;
            failed = List.of();
        } else {
            this.sortPlayers();
            success = this.activePlayers.subList(0, catches);
            failed = this.activePlayers.subList(catches, this.activePlayers.size());
        }
        if (CobblemonRaidDens.CONFIG.sync_rewards) {
            cachedReward = this.raidBoss.getRewardPokemon(null);
            cachedReward.setShiny(this.bossEntity.getPokemon().getShiny());
            cachedReward.setGender(this.bossEntity.getPokemon().getGender());
            cachedReward.setNature(this.bossEntity.getPokemon().getNature());
        } else {
            cachedReward = null;
        }
        success.forEach(player -> {
            new RewardHandler(this.raidBoss, (class_3222)player, true, cachedReward).sendRewardMessage((class_3222)player);
            RaidEvents.RAID_END.emit((Object[])new RaidEndEvent[]{new RaidEndEvent((class_3222)player, this.raidBoss, this.bossEntity.getPokemon(), true)});
        });
        failed.forEach(player -> {
            new RewardHandler(this.raidBoss, (class_3222)player, false).sendRewardMessage((class_3222)player);
            RaidEvents.RAID_END.emit((Object[])new RaidEndEvent[]{new RaidEndEvent((class_3222)player, this.raidBoss, this.bossEntity.getPokemon(), true)});
        });
    }

    private void sortPlayers() {
        if (CobblemonRaidDens.CONFIG.reward_distribution == RewardDistribution.DAMAGE) {
            this.activePlayers.sort((a, b) -> Float.compare(this.damageTracker.getOrDefault(b.method_5667(), Float.valueOf(0.0f)).floatValue(), this.damageTracker.getOrDefault(a.method_5667(), Float.valueOf(0.0f)).floatValue()));
        } else {
            Collections.shuffle(this.activePlayers);
        }
    }

    private void handleFailed() {
        this.raidState = RaidState.FAILED;
        ((IRaidAccessor)this.bossEntity).crd_setRaidState(RaidState.FAILED);
        class_2561 component = ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.raid_fail");
        this.activePlayers.forEach(player -> {
            player.method_7353(component, true);
            RaidEvents.RAID_END.emit((Object[])new RaidEndEvent[]{new RaidEndEvent((class_3222)player, this.raidBoss, this.bossEntity.getPokemon(), false)});
        });
    }

    public PokemonEntity getBossEntity() {
        return this.bossEntity;
    }

    public RaidBoss getRaidBoss() {
        return this.raidBoss;
    }

    public void addToBossEvent(class_3222 player) {
        this.runQueue.add(new DelayedRunnable(() -> this.bossEvent.method_14088(player), 2));
    }

    public void removeFromBossEvent(class_3222 player) {
        this.bossEvent.method_14089(player);
    }

    public RaidState getRaidState() {
        return this.raidState;
    }

    public boolean isFinished() {
        return this.raidState == RaidState.SUCCESS || this.raidState == RaidState.FAILED || this.raidState == RaidState.CANCELLED;
    }

    private ShowdownEvent getInstructions(@NotNull String function) {
        return RaidScriptHelper.decode(function);
    }

    public void runScriptByTurn(int turn, PokemonBattle battle) {
        List<ShowdownEvent> functions = this.scriptByTurn.remove(turn);
        if (functions == null) {
            return;
        }
        functions.forEach(event -> this.sendEvent((ShowdownEvent)event, battle));
    }

    public void runScriptByHp(double hpRatio) {
        this.scriptByHp.tailMap(hpRatio, true).values().forEach(events -> events.forEach(event -> this.sendEvent((ShowdownEvent)event, null)));
        this.scriptByHp.keySet().removeIf(hp -> hp >= hpRatio);
    }

    public boolean runCheer(class_3222 player, PokemonBattle oBattle, CheerBagItem bagItem, String origin) {
        int cheersLeft = this.cheersLeft.getOrDefault(player.method_5667(), 0);
        if (cheersLeft <= 0) {
            return false;
        }
        this.cheersLeft.put(player.method_5667(), --cheersLeft);
        this.cheer(oBattle, bagItem, origin, false);
        Consumer<PokemonBattle> cheer = switch (bagItem.cheerType()) {
            default -> throw new MatchException(null, null);
            case CheerBagItem.CheerType.ATTACK -> battle -> new CheerAttackShowdownEvent(origin).send((PokemonBattle)battle);
            case CheerBagItem.CheerType.DEFENSE -> battle -> new CheerDefenseShowdownEvent(origin).send((PokemonBattle)battle);
            case CheerBagItem.CheerType.HEAL -> battle -> new CheerHealShowdownEvent(origin).send((PokemonBattle)battle);
        };
        for (PokemonBattle b : this.battles) {
            if (b == oBattle) continue;
            cheer.accept(b);
        }
        return true;
    }

    public void cheer(PokemonBattle battle, BagItem bagItem, String origin, boolean skipEnemyAction) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side1.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null || target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        if (bagItem instanceof CheerBagItem) {
            CheerBagItem.CheerType cheerType;
            CheerBagItem.CheerType cheerType2;
            CheerBagItem cheerBagItem = (CheerBagItem)bagItem;
            try {
                cheerType = cheerType2 = cheerBagItem.cheerType();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (cheerType == CheerBagItem.CheerType.HEAL && (cheerType2 = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon().getEntity()) instanceof PokemonEntity) {
                CheerBagItem.CheerType entity = cheerType2;
                entity.method_5783(CobblemonSounds.MEDICINE_HERB_USE, 1.0f, 1.0f);
            }
        }
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse(bagItem, ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon(), origin), skipEnemyAction);
    }

    private void sendAction(BattleActor side1, BattleActor side2, ShowdownActionResponse response, boolean skipEnemyAction) {
        side1.getResponses().add(response);
        side1.setMustChoose(false);
        if (skipEnemyAction) {
            side2.getResponses().addFirst(PassActionResponse.INSTANCE);
            side2.setMustChoose(false);
        }
        side1.getBattle().checkForInputDispatch();
        side1.sendUpdate((NetworkPacket)new BattleApplyPassResponsePacket());
    }

    public void sendEvent(ShowdownEvent event, @Nullable PokemonBattle battle) {
        if (event instanceof BroadcastingShowdownEvent) {
            BroadcastingShowdownEvent broadcast = (BroadcastingShowdownEvent)event;
            broadcast.broadcast(this.battles);
        } else {
            event.send(battle == null ? this.battles.getFirst() : battle);
        }
    }

    public boolean canSync() {
        return CobblemonRaidDens.CONFIG.max_players_for_support >= this.activePlayers.size();
    }

    public void broadcastToOthers(ShowdownEvent event, @Nullable PokemonBattle battle) {
        if (!this.canSync()) {
            return;
        }
        for (PokemonBattle b : this.battles) {
            if (battle != null && b == battle) continue;
            event.send(b);
        }
    }

    public void updateBattleState(PokemonBattle battle, Function<RaidBattleState, Optional<ShowdownEvent>> function) {
        if (!this.canSync()) {
            return;
        }
        Optional<ShowdownEvent> optional = function.apply(this.battleState);
        optional.ifPresent(event -> {
            for (PokemonBattle b : this.battles) {
                if (b == battle) continue;
                event.send(b);
            }
        });
    }

    public void updateBattleContext(PokemonBattle battle, Consumer<PokemonBattle> consumer) {
        if (!this.canSync()) {
            return;
        }
        for (PokemonBattle b : this.battles) {
            if (b == battle) continue;
            b.dispatch(() -> {
                consumer.accept(b);
                return DispatchResultKt.getGO();
            });
        }
    }

    public void closeRaid(MinecraftServer server) {
        this.closeRaid(server, false);
    }

    public void closeRaid(MinecraftServer server, boolean wasCancelled) {
        if (this.raidState == RaidState.SUCCESS) {
            RaidHelper.clearRaid(this.raid, this.activePlayers);
        } else if (!this.bossEntity.method_31481()) {
            this.bossEntity.method_31472();
        }
        RaidRegion region = RaidRegionHelper.getRegion(this.raid);
        if (region != null) {
            region.removeRegionTicket(ModDimensions.getRaidDimension(server));
        }
        RaidInventorySaveManager.restoreInventories(this.activePlayers);
        for (class_3222 player : this.activePlayers) {
            if (player == null || !player.method_5805()) continue;
            RaidHelper.teleportFromRaid(player);
            RaidDenNetworkMessages.JOIN_RAID.accept(player, false);
        }
        RaidHelper.closeRaid(this.raid, wasCancelled ? RaidState.CANCELLED : this.raidState, ModDimensions.getRaidDimension(server));
        RaidHelper.removeRequests(this.host);
        RaidJoinHelper.removeParticipants(this.activePlayers);
    }

    private static class DelayedRunnable {
        private final Runnable runnable;
        private final int delay;
        private int tick;
        private final boolean repeat;

        public DelayedRunnable(Runnable runnable, int delay, boolean repeat) {
            this.runnable = runnable;
            this.delay = delay;
            this.tick = 0;
            this.repeat = repeat;
        }

        public DelayedRunnable(Runnable runnable, int delay) {
            this(runnable, delay, false);
        }

        public boolean tick() {
            if (++this.tick < this.delay) {
                return false;
            }
            this.runnable.run();
            if (this.repeat) {
                this.tick = 0;
            }
            return !this.repeat;
        }
    }
}

