/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.network.packets;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSeenEvent;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.actor.PokemonBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.config.TierConfig;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.events.RaidBattleStartEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.network.ServerPacket;
import com.necro.raid.dens.common.raids.RaidBuilder;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.RaidState;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.util.ComponentUtils;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.ITransformer;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.Optional;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record RaidChallengePacket(int targetedEntityId, UUID selectedPokemonId, BattleFormat battleFormat) implements class_8710,
ServerPacket
{
    public static final class_2960 ID = class_2960.method_60655((String)"cobblemonraiddens", (String)"raid_challenge");
    public static final class_8710.class_9154<RaidChallengePacket> PACKET_TYPE = new class_8710.class_9154(ID);
    public static final class_9139<class_2540, RaidChallengePacket> CODEC = class_9139.method_56438(RaidChallengePacket::write, RaidChallengePacket::read);

    public void write(class_2540 buf) {
        buf.method_53002(this.targetedEntityId);
        buf.method_10797(this.selectedPokemonId);
        this.battleFormat.saveToBuffer((class_9129)buf);
    }

    public static RaidChallengePacket read(class_2540 buf) {
        return new RaidChallengePacket(buf.readInt(), buf.method_10790(), BattleFormat.Companion.loadFromBuffer((class_9129)buf));
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_TYPE;
    }

    @Override
    public void handleServer(class_3222 player) {
        RaidInstance raid;
        PokemonEntity pokemonEntity;
        class_1297 entity = player.method_37908().method_8469(this.targetedEntityId);
        if (!(entity instanceof PokemonEntity) || (pokemonEntity = (PokemonEntity)entity).method_35057() != null) {
            return;
        }
        if (!((IRaidAccessor)pokemonEntity).crd_isRaidBoss()) {
            return;
        }
        if (((IRaidAccessor)pokemonEntity).crd_getRaidState() == RaidState.FAILED) {
            player.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.has_fainted"), true);
            return;
        }
        if (!RaidJoinHelper.isParticipating((class_1657)player, false) && RaidUtils.isRaidDimension(player.method_37908())) {
            player.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.not_participating"), true);
            return;
        }
        RaidBoss boss = ((IRaidAccessor)entity).crd_getRaidBoss();
        TierConfig tierConfig = CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier());
        UUID raidId = ((IRaidAccessor)pokemonEntity).crd_getRaidId();
        RaidInstance raidTemp = RaidHelper.ACTIVE_RAIDS.getOrDefault(raidId, null);
        if (raidTemp == null && !RaidUtils.isRaidDimension(player.method_37908())) {
            raidTemp = new RaidInstance(pokemonEntity, player.method_5667());
            raidTemp.addPlayer(player);
            RaidHelper.ACTIVE_RAIDS.put(raidId, raidTemp);
        }
        if ((raid = raidTemp) == null) {
            return;
        }
        if (raid.hasFailed(player)) {
            player.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.has_fainted"), true);
            return;
        }
        if (tierConfig.maxPlayers() != -1 && raid.getBattles().size() >= tierConfig.maxPlayers()) {
            player.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.lobby_is_full"), true);
            return;
        }
        Pokemon pokemon = PlayerExtensionsKt.party((class_3222)player).get(this.selectedPokemonId);
        if (pokemon == null) {
            return;
        }
        if (RaidUtils.isPokemonBlacklisted(pokemon)) {
            player.method_7353(ComponentUtils.getErrorMessage(class_2561.method_43469((String)"message.cobblemonraiddens.raid.forbidden_pokemon", (Object[])new Object[]{pokemon.getSpecies().getTranslatedName()})), true);
            return;
        }
        if (RaidUtils.isAbilityBlacklisted(pokemon.getAbility())) {
            player.method_7353(ComponentUtils.getErrorMessage(class_2561.method_43469((String)"message.cobblemonraiddens.raid.forbidden_ability", (Object[])new Object[]{class_2561.method_43471((String)pokemon.getAbility().getDisplayName())})), true);
            return;
        }
        if (pokemon.isFainted()) {
            player.method_7353(ComponentUtils.getErrorMessage(class_2561.method_43469((String)"message.cobblemonraiddens.raid.fainted_lead", (Object[])new Object[]{pokemon.getSpecies().getTranslatedName()})), true);
            return;
        }
        UUID leadingPokemon = pokemon.getUuid();
        if (PlayerExtensionsKt.canInteractWith((class_3222)player, (class_1309)pokemonEntity, (float)(Cobblemon.config.getBattleWildMaxDistance() * 4.0f)) && pokemonEntity.canBattle((class_1657)player)) {
            RaidBuilder.build(player, pokemonEntity, leadingPokemon, boss, tierConfig).ifSuccessful(battle -> {
                this.flagAsSeen((PokemonBattle)battle, pokemonEntity);
                raid.addBattle((PokemonBattle)battle);
                RaidEvents.RAID_BATTLE_START.emit((Object[])new RaidBattleStartEvent[]{new RaidBattleStartEvent(player, boss, (PokemonBattle)battle)});
                if (pokemonEntity.getPokemon().getAbility().getName().equalsIgnoreCase("imposter")) {
                    this.setTransformTarget(pokemonEntity, pokemon, battle.getSide2().getActors()[0]);
                }
                return Unit.INSTANCE;
            }).ifErrored(errors -> {
                errors.sendTo((class_1297)player, component -> component.method_27692(class_124.field_1061));
                return Unit.INSTANCE;
            });
        }
    }

    private void setTransformTarget(PokemonEntity pokemonEntity, Pokemon pokemon, BattleActor actor) {
        if (((ITransformer)pokemonEntity).crd_getTransformTarget() == null) {
            ((ITransformer)pokemonEntity).crd_setTransformTarget(pokemon);
        }
    }

    private void flagAsSeen(PokemonBattle battle, PokemonEntity entity) {
        PokemonBattleActor actor = (PokemonBattleActor)battle.getActor(entity.getPokemon().getUuid());
        if (actor == null) {
            return;
        }
        Optional<BattlePokemon> battlePokemon = actor.getPokemonList().stream().filter(bp -> bp.getUuid() == entity.getPokemon().getUuid()).findFirst();
        if (battlePokemon.isEmpty()) {
            return;
        }
        battle.getPlayerUUIDs().forEach(uuid -> CobblemonEvents.POKEMON_SEEN.post((Object[])new PokemonSeenEvent[]{new PokemonSeenEvent(uuid, ((BattlePokemon)battlePokemon.get()).getEffectedPokemon())}, T -> Unit.INSTANCE));
    }
}

