/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins.battlesync;

import com.cobblemon.mod.common.api.battles.interpreter.BasicContext;
import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.interpreter.Effect;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.dispatch.DispatchResultKt;
import com.cobblemon.mod.common.battles.interpreter.instructions.WeatherInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.battle.RaidBattleState;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IRaidBattle;
import java.util.Collection;
import kotlin.Unit;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WeatherInstruction.class})
public abstract class WeatherInstructionMixin {
    @Shadow(remap=false)
    public abstract BattleMessage getMessage();

    @Inject(method={"invoke(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void invokeInject(PokemonBattle battle, CallbackInfo ci) {
        if (!((IRaidBattle)battle).crd_isRaidBattle()) {
            return;
        }
        RaidInstance raid = ((IRaidBattle)battle).crd_getRaidBattle();
        BattlePokemon battlePokemon = ((ActiveBattlePokemon)battle.getSide2().getActivePokemon().getFirst()).getBattlePokemon();
        if (battlePokemon == null || battlePokemon.getEntity() == null) {
            return;
        }
        if (!((IRaidAccessor)battlePokemon.getEntity()).crd_isRaidBoss()) {
            return;
        }
        if (this.getMessage().hasOptionalArgument("upkeep")) {
            return;
        }
        Effect effect = this.getMessage().effectAt(0);
        if (effect == null) {
            return;
        }
        String weather = effect.getId();
        BattlePokemon source = this.getMessage().battlePokemonFromOptional(battle, "of");
        if (source != null) {
            ShowdownInterpreter.INSTANCE.broadcastOptionalAbility(battle, this.getMessage().effect("from"), source);
        }
        battle.dispatch(() -> {
            if (!weather.equalsIgnoreCase("none")) {
                raid.updateBattleState(battle, battleState -> battleState.addWeather(weather));
                raid.updateBattleContext(battle, b -> {
                    b.getContextManager().add(new BattleContext[]{new BasicContext(weather, b.getTurn(), BattleContext.Type.WEATHER, null)});
                    b.broadcastChatMessage((class_2561)LocalizationUtilsKt.battleLang((String)String.format("weather.%s.start", weather), (Object[])new Object[0]));
                });
            } else {
                raid.updateBattleState(battle, RaidBattleState::removeWeather);
                raid.updateBattleContext(battle, b -> {
                    Collection context = b.getContextManager().get(BattleContext.Type.WEATHER);
                    if (context == null || context.isEmpty()) {
                        return;
                    }
                    String oldWeather = ((BattleContext)context.stream().findFirst().get()).getId();
                    b.getContextManager().clear(new BattleContext.Type[]{BattleContext.Type.WEATHER});
                    b.broadcastChatMessage((class_2561)LocalizationUtilsKt.battleLang((String)String.format("weather.%s.end", oldWeather), (Object[])new Object[0]));
                });
            }
            return DispatchResultKt.getGO();
        });
        battle.dispatchWaiting(1.5f, () -> {
            class_5250 lang;
            if (this.getMessage().hasOptionalArgument("upkeep")) {
                lang = LocalizationUtilsKt.battleLang((String)String.format("weather.%s.upkeep", weather), (Object[])new Object[0]);
            } else if (!weather.equals("none")) {
                battle.getContextManager().add(new BattleContext[]{ShowdownInterpreter.INSTANCE.getContextFromAction(this.getMessage(), BattleContext.Type.WEATHER, battle)});
                lang = LocalizationUtilsKt.battleLang((String)String.format("weather.%s.start", weather), (Object[])new Object[0]);
            } else {
                Collection context = battle.getContextManager().get(BattleContext.Type.WEATHER);
                if (context == null || context.isEmpty()) {
                    return Unit.INSTANCE;
                }
                String oldWeather = ((BattleContext)context.stream().findFirst().get()).getId();
                battle.getContextManager().clear(new BattleContext.Type[]{BattleContext.Type.WEATHER});
                lang = LocalizationUtilsKt.battleLang((String)String.format("weather.%s.end", oldWeather), (Object[])new Object[0]);
            }
            battle.broadcastChatMessage((class_2561)lang);
            return Unit.INSTANCE;
        });
        ci.cancel();
    }
}

