/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.config;

import com.necro.raid.dens.common.raids.RewardDistribution;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="cobblemonraiddens/common")
public class RaidConfig
implements ConfigData {
    @Comment(value="Enable natural spawning of raid dens. Default: true")
    public boolean enable_spawning = true;
    @Comment(value="Weighted probability of each raid tier from Tier 1 to Tier 7 per dimension. Leave empty to use overworld/default. Default: {\"minecraft:overworld\": [9.0, 15.0, 25.0, 25.0, 20.0, 5.0, 1.0]}")
    public Map<String, double[]> dimension_tier_weights = new HashMap<String, double[]>(Map.of("minecraft:overworld", new double[]{9.0, 15.0, 25.0, 25.0, 20.0, 5.0, 1.0}));
    @Comment(value="How long in seconds until raid dens reset (Set to -1 for no resets). Default: 7200")
    public int reset_time = 7200;
    @Comment(value="Whether the raid boss and raid tier changes between resets (Options: NONE, LOCK_BOTH, LOCK_TIER, LOCK_TYPE, ALL). Default: ALL")
    public String cycle_mode = "ALL";
    @Comment(value="Whether failed raids count towards the max clears. Default: false")
    public boolean max_clears_include_fails = false;
    @Comment(value="Whether the reward Pokemon attributes (IVs/Shiny/etc.) are synced between all players or rolled individually. Default: false")
    public boolean sync_rewards = false;
    @Comment(value="Whether raid crystals can be broken. Default: true")
    public boolean can_break = true;
    @Comment(value="The reward distribution algorithm (RANDOM/DAMAGE/SURVIVOR). Default: RANDOM")
    public RewardDistribution reward_distribution = RewardDistribution.RANDOM;
    @Comment(value="The maximum number of players in a raid before shared supporting moves are disabled. Default: 4")
    public int max_players_for_support = 4;
    @Comment(value="Distance in blocks before forced flee from raid battle. Default: 32")
    public int flee_distance = 32;
    @Comment(value="Enable CobbleDollars currency rewards. Default: false")
    public boolean enable_currency_rewards = false;
    @Comment(value="Enable automatic crystal spawning near players. Default: true")
    public boolean enable_auto_spawn = true;
    @Comment(value="Minimum time in minutes between auto spawns. Default: 30")
    public int auto_spawn_min_minutes = 30;
    @Comment(value="Maximum time in minutes between auto spawns. Default: 60")
    public int auto_spawn_max_minutes = 60;
    @Comment(value="Tier weights for auto spawn [tier1, tier2, tier3, tier4, tier5]. Default: [30.0, 25.0, 20.0, 15.0, 10.0]")
    public double[] auto_spawn_tier_weights = new double[]{30.0, 25.0, 20.0, 15.0, 10.0};
    @Comment(value="Commands to execute after raid completion. Supports placeholders: {player}, {tier}, {boss}, {success}. Default: []")
    public String[] completion_commands = new String[0];
    @Comment(value="Time in seconds for ready check timeout after teleportation. Default: 60")
    public int ready_timeout_seconds = 60;
    @Comment(value="Enable confirmation GUI before entering raid. Default: true")
    public boolean enable_confirmation_gui = true;
    @Comment(value="Enable invitation system for multiplayer raids. Default: true")
    public boolean enable_invitation_system = true;
    @Comment(value="Auto-spawned crystals despawn after raid completion. Default: true")
    public boolean despawn_auto_crystals = true;
}

