/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.compat.jade;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.item.PokemonItem;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.ResourceLocationExtensionsKt;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.compat.ModCompat;
import com.necro.raid.dens.common.compat.jade.ElementalTypeElement;
import com.necro.raid.dens.common.compat.jade.TeraTypeElement;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.data.raid.RaidFeature;
import com.necro.raid.dens.common.data.raid.RaidTier;
import com.necro.raid.dens.common.data.raid.RaidType;
import com.necro.raid.dens.common.registry.RaidRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum RaidCrystalComponents implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    private IElement getIconClient(BlockAccessor accessor, IElement currentIcon) {
        RaidBoss raidBoss;
        class_2586 blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof RaidCrystalBlockEntity)) {
            return currentIcon;
        }
        RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
        if (RaidRegistry.REGISTRY == null) {
            RaidRegistry.REGISTRY = blockEntity.method_10997().method_30349().method_30530(RaidRegistry.RAID_BOSS_KEY);
        }
        if ((raidBoss = (RaidBoss)RaidRegistry.REGISTRY.method_10223(raidCrystal.getRaidBossLocation())) == null) {
            return currentIcon;
        }
        if (raidBoss.getDisplayAspects() == null) {
            raidBoss.createDisplayAspects();
        }
        class_1799 stack = PokemonItem.from((Species)raidBoss.getDisplaySpecies(), raidBoss.getDisplayAspects(), (int)1, null);
        return IElementHelper.get().item(stack, 1.5f);
    }

    @Nullable
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        if (!accessor.isServerConnected()) {
            return this.getIconClient(accessor, currentIcon);
        }
        class_2487 serverData = accessor.getServerData();
        if (!serverData.method_10545("boss_aspects") || !serverData.method_10545("boss_species")) {
            return currentIcon;
        }
        IElementHelper elements = IElementHelper.get();
        Species species = PokemonSpecies.getByIdentifier((class_2960)ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace((String)serverData.method_10558("boss_species"), (String)"cobblemon"));
        if (species == null) {
            return currentIcon;
        }
        HashSet<String> aspects = new HashSet<String>();
        class_2499 listTag = serverData.method_10554("boss_aspects", 8);
        for (class_2520 t : listTag) {
            class_2519 tag = (class_2519)t;
            aspects.add(tag.method_10714());
        }
        class_1799 stack = PokemonItem.from((Species)species, aspects, (int)1, null);
        return elements.item(stack, 1.5f);
    }

    private IElement getTeraTypeIcon(RaidType type) {
        String string = String.format("mega_showdown:textures/gui/summary/tera_types/%s.png", type.method_15434());
        return new TeraTypeElement(class_2960.method_60654((String)string), 32, 32);
    }

    private IElement getElementalTypeIcon(RaidType type) {
        String string = "cobblemon:textures/gui/types_small.png";
        return new ElementalTypeElement(class_2960.method_60654((String)string), 324, 18, type);
    }

    private void appendTooltipClient(ITooltip tooltip, BlockAccessor accessor) {
        RaidBoss raidBoss;
        class_2586 blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof RaidCrystalBlockEntity)) {
            return;
        }
        RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
        class_2680 blockState = accessor.getBlockState();
        if (RaidRegistry.REGISTRY == null) {
            RaidRegistry.REGISTRY = raidCrystal.method_10997().method_30349().method_30530(RaidRegistry.RAID_BOSS_KEY);
        }
        if ((raidBoss = (RaidBoss)RaidRegistry.REGISTRY.method_10223(raidCrystal.getRaidBossLocation())) == null) {
            return;
        }
        RaidTier tier = (RaidTier)((Object)blockState.method_11654(RaidCrystalBlock.RAID_TIER));
        RaidType type = (RaidType)((Object)blockState.method_11654(RaidCrystalBlock.RAID_TYPE));
        RaidFeature feature = raidBoss.getFeature();
        if (raidBoss.getDisplayAspects() == null) {
            raidBoss.createDisplayAspects();
        }
        class_5250 component = raidBoss.getDisplaySpecies().getTranslatedName();
        component.method_27693(" | ").method_10852((class_2561)class_2561.method_43471((String)feature.getTranslatable()));
        component.method_27693(" | ").method_27693(tier.getStars());
        tooltip.add((class_2561)component, this.getUid());
        IElementHelper helper = IElementHelper.get();
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(helper.text((class_2561)class_2561.method_43470((String)" ")));
        if (type != RaidType.STELLAR) {
            elements.add(this.getElementalTypeIcon(type));
            tooltip.append(0, elements);
        } else if (ModCompat.MEGA_SHOWDOWN.isLoaded()) {
            elements.add(this.getTeraTypeIcon(type));
            tooltip.append(0, elements);
        }
        int catches = raidBoss.getMaxCatches();
        if (catches == 0) {
            tooltip.add((IElement)helper.text((class_2561)class_2561.method_43471((String)"jade.cobblemonraiddens.not_catchable").method_27692(class_124.field_1056).method_27692(class_124.field_1080)).scale(0.5f));
        } else if (catches > 0) {
            tooltip.add((IElement)helper.text((class_2561)class_2561.method_43469((String)"jade.cobblemonraiddens.max_catches", (Object[])new Object[]{catches}).method_27692(class_124.field_1056).method_27692(class_124.field_1080)).scale(0.5f));
        }
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!accessor.isServerConnected()) {
            this.appendTooltipClient(tooltip, accessor);
            return;
        }
        class_2487 serverData = accessor.getServerData();
        if (!serverData.method_10545("raid_boss")) {
            return;
        }
        class_5250 component = class_2561.method_43471((String)serverData.method_10558("raid_boss"));
        if (serverData.method_10545("raid_feature")) {
            component.method_27693(" | ").method_10852((class_2561)class_2561.method_43471((String)serverData.method_10558("raid_feature")));
        }
        class_2680 blockState = accessor.getBlockState();
        RaidTier tier = (RaidTier)((Object)blockState.method_11654(RaidCrystalBlock.RAID_TIER));
        component.method_27693(" | ").method_27693(tier.getStars());
        tooltip.add((class_2561)component, this.getUid());
        RaidType type = (RaidType)((Object)blockState.method_11654(RaidCrystalBlock.RAID_TYPE));
        IElementHelper helper = IElementHelper.get();
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(helper.text((class_2561)class_2561.method_43470((String)" ")));
        if (type != RaidType.STELLAR) {
            elements.add(this.getElementalTypeIcon(type));
            tooltip.append(0, elements);
        } else if (ModCompat.MEGA_SHOWDOWN.isLoaded()) {
            elements.add(this.getTeraTypeIcon(type));
            tooltip.append(0, elements);
        }
        class_5250 component1 = class_2561.method_43473();
        if (serverData.method_10545("player_count")) {
            component1.method_10852((class_2561)class_2561.method_43469((String)"jade.cobblemonraiddens.player_count", (Object[])new Object[]{serverData.method_10550("player_count")}));
            component1.method_27693(" | ");
        }
        if (serverData.method_10545("next_reset")) {
            component1.method_27693(serverData.method_10558("next_reset"));
        }
        if (!component1.equals((Object)class_2561.method_43473())) {
            tooltip.add((class_2561)component1);
        }
        if (serverData.method_10545("max_catches")) {
            int catches = serverData.method_10550("max_catches");
            if (catches == 0) {
                tooltip.add((IElement)helper.text((class_2561)class_2561.method_43471((String)"jade.cobblemonraiddens.not_catchable").method_27692(class_124.field_1056).method_27692(class_124.field_1080)).scale(0.5f));
            } else {
                tooltip.add((IElement)helper.text((class_2561)class_2561.method_43469((String)"jade.cobblemonraiddens.max_catches", (Object[])new Object[]{catches}).method_27692(class_124.field_1056).method_27692(class_124.field_1080)).scale(0.5f));
            }
        }
    }

    public void appendServerData(class_2487 compoundTag, BlockAccessor accessor) {
        class_2586 blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof RaidCrystalBlockEntity)) {
            return;
        }
        RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
        RaidBoss raidBoss = raidCrystal.getRaidBoss();
        if (raidBoss == null) {
            return;
        }
        if (raidBoss.getDisplaySpecies() == null) {
            raidBoss.createDisplayAspects();
        }
        Species species = raidBoss.getDisplaySpecies();
        String translatable = String.format("%s.species.%s.name", species.getResourceIdentifier().method_12836(), species.showdownId());
        compoundTag.method_10582("raid_boss", translatable);
        compoundTag.method_10582("raid_feature", raidBoss.getFeature().getTranslatable());
        compoundTag.method_10582("boss_species", species.getResourceIdentifier().toString());
        class_2499 bossAspects = new class_2499();
        for (String aspect : raidBoss.getDisplayAspects()) {
            if (aspect == null) continue;
            bossAspects.add((Object)class_2519.method_23256((String)aspect));
        }
        for (SpeciesFeature form : raidBoss.getRaidForm()) {
            String aspect;
            if (form instanceof StringSpeciesFeature) {
                aspect = ((StringSpeciesFeature)form).getValue();
            } else {
                if (!(form instanceof FlagSpeciesFeature)) continue;
                aspect = form.getName();
            }
            bossAspects.add((Object)class_2519.method_23256((String)aspect));
        }
        compoundTag.method_10566("boss_aspects", (class_2520)bossAspects);
        if (raidCrystal.getPlayerCount() > 0) {
            compoundTag.method_10569("player_count", raidCrystal.getPlayerCount());
        }
        if (raidCrystal.getTicksUntilNextReset() > 0L) {
            compoundTag.method_10582("next_reset", this.formatTicks(raidCrystal.getTicksUntilNextReset()));
        }
        if (raidBoss.getMaxCatches() >= 0) {
            compoundTag.method_10569("max_catches", raidBoss.getMaxCatches().intValue());
        }
    }

    private String formatTicks(long ticks) {
        int totalSeconds = (int)ticks / 20;
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public class_2960 getUid() {
        return class_2960.method_60655((String)"cobblemonraiddens", (String)"raid_crystal");
    }
}

