/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.commands;

import com.cobblemon.mod.common.api.permission.Permission;
import com.cobblemon.mod.common.api.permission.PermissionLevel;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.necro.raid.dens.common.blocks.ModBlocks;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.commands.permission.RaidDenPermission;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.data.raid.RaidCycleMode;
import com.necro.raid.dens.common.data.raid.RaidTier;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.registry.RaidRegistry;
import com.necro.raid.dens.common.util.ComponentUtils;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class RaidAdminCommands {
    private static final Permission RESET_CLEARS = new RaidDenPermission("command.resetclears", PermissionLevel.CHEAT_COMMANDS_AND_COMMAND_BLOCKS);
    private static final Permission REFRESH = new RaidDenPermission("command.refreshother", PermissionLevel.CHEAT_COMMANDS_AND_COMMAND_BLOCKS);
    private static final Permission TEST = new RaidDenPermission("command.test", PermissionLevel.CHEAT_COMMANDS_AND_COMMAND_BLOCKS);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"crd").then(PermissionUtilsKt.permission((ArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"resetclears").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(context -> RaidAdminCommands.resetClearsForAll((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"pos"), class_2181.method_9289((CommandContext)context, (String)"dimension")))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(RaidAdminCommands::resetClearsForPlayerAndPos)))).requires(class_2168::method_43737)).executes(context -> RaidAdminCommands.resetClearsForAll((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"pos"))))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(RaidAdminCommands::resetClearsForPlayer)), (Permission)RESET_CLEARS, (boolean)true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"refresh").then(PermissionUtilsKt.permission((ArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> source.method_9259(2))).executes(context -> RaidAdminCommands.refreshPlayer((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player"))), (Permission)REFRESH, (boolean)true))).requires(class_2168::method_43737)).executes(RaidAdminCommands::refreshPlayer))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"test").requires(source -> source.method_9259(2))).requires(class_2168::method_43737)).executes(context -> RaidAdminCommands.spawnTestCrystal((CommandContext<class_2168>)context, 1))).then(class_2170.method_9244((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(context -> RaidAdminCommands.spawnTestCrystal((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"))))));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        RaidAdminCommands.register(dispatcher);
    }

    private static int refreshPlayer(CommandContext<class_2168> context, class_3222 player) {
        if (RaidUtils.isRaidDimension((class_1937)player.method_51469())) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"error.cobblemonraiddens.player_in_raid"));
            return 0;
        }
        RaidJoinHelper.removeParticipant((class_1657)player);
        RaidJoinHelper.removeFromQueue((class_1657)player, true);
        ((class_2168)context.getSource()).method_45068(ComponentUtils.getSystemMessage(class_2561.method_43469((String)"message.cobblemonraiddens.command.refresh_player", (Object[])new Object[]{player.method_5477()})));
        return 1;
    }

    private static int refreshPlayer(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        return RaidAdminCommands.refreshPlayer(context, player);
    }

    private static int resetClearsForPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        RaidHelper.resetPlayerAllClearedRaids(player.method_5667());
        ((class_2168)context.getSource()).method_45068(ComponentUtils.getSystemMessage("message.cobblemonraiddens.command.reset_clears"));
        return 1;
    }

    private static int resetClearsForPlayerAndPos(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        class_2338 blockPos = class_2262.method_48299(context, (String)"pos");
        class_3218 dimension = class_2181.method_9289(context, (String)"dimension");
        class_2586 class_25862 = dimension.method_8321(blockPos);
        if (class_25862 instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)class_25862;
            RaidHelper.resetPlayerClearedRaid(raidCrystal.getUuid(), player.method_5667());
            ((class_2168)context.getSource()).method_45068(ComponentUtils.getSystemMessage("message.cobblemonraiddens.command.reset_clears"));
            raidCrystal.resetClears();
            return 1;
        }
        return 0;
    }

    private static int resetClearsForAll(CommandContext<class_2168> context, class_2338 blockPos) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        class_3218 dimension = player.method_51469();
        return RaidAdminCommands.resetClearsForAll(context, blockPos, dimension);
    }

    private static int resetClearsForAll(CommandContext<class_2168> context, class_2338 blockPos, class_3218 dimension) {
        class_2586 class_25862 = dimension.method_8321(blockPos);
        if (class_25862 instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)class_25862;
            RaidHelper.resetClearedRaids(raidCrystal.getUuid());
            ((class_2168)context.getSource()).method_45068(ComponentUtils.getSystemMessage("message.cobblemonraiddens.command.reset_clears"));
            raidCrystal.resetClears();
            class_2680 blockState = raidCrystal.method_11010();
            dimension.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
            return 1;
        }
        return 0;
    }

    private static int spawnTestCrystal(CommandContext<class_2168> context, int tier) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        class_3218 level = player.method_51469();
        double yaw = Math.toRadians(player.method_36454());
        int dx = (int)Math.round(-Math.sin(yaw) * 5.0);
        int dz = (int)Math.round(Math.cos(yaw) * 5.0);
        class_2338 spawnPos = player.method_24515().method_10069(dx, 0, dz);
        class_2338.class_2339 mutablePos = spawnPos.method_25503();
        while (mutablePos.method_10264() > level.method_31607() && !level.method_8320(mutablePos.method_10074()).method_51367()) {
            mutablePos.method_10100(0, -1, 0);
        }
        while (mutablePos.method_10264() < level.method_31600() && level.method_8320((class_2338)mutablePos).method_51367()) {
            mutablePos.method_10100(0, 1, 0);
        }
        spawnPos = mutablePos.method_10062();
        RaidTier raidTier = RaidTier.values()[Math.min(tier - 1, RaidTier.values().length - 1)];
        class_2960 bossLocation = RaidRegistry.getRandomRaidBoss(level.method_8409(), (class_1937)level, raidTier, null, null);
        if (bossLocation == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Aucun boss trouv\u00e9 pour le tier " + tier)));
            return 0;
        }
        RaidBoss raidBoss = RaidRegistry.getRaidBoss(bossLocation);
        if (raidBoss == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Erreur lors du chargement du boss"));
            return 0;
        }
        class_2680 crystalState = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)ModBlocks.INSTANCE.getRaidCrystalBlock().method_9564().method_11657((class_2769)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)RaidCrystalBlock.CAN_RESET, (Comparable)Boolean.valueOf(true))).method_11657(RaidCrystalBlock.CYCLE_MODE, (Comparable)((Object)RaidCycleMode.CONFIG))).method_11657(RaidCrystalBlock.RAID_TYPE, (Comparable)((Object)raidBoss.getType()))).method_11657(RaidCrystalBlock.RAID_TIER, (Comparable)((Object)raidBoss.getTier()));
        level.method_8652(spawnPos, crystalState, 3);
        class_2586 class_25862 = level.method_8321(spawnPos);
        if (class_25862 instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity crystal = (RaidCrystalBlockEntity)class_25862;
            crystal.setAutoSpawned(true);
            crystal.setRaidBoss(bossLocation, level.method_8510());
            String bossName = raidBoss.getProperties().getSpecies();
            ((class_2168)context.getSource()).method_45068(ComponentUtils.getSystemMessage(class_2561.method_43469((String)"message.cobblemonraiddens.command.test_spawned", (Object[])new Object[]{tier, spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260()}).method_27693(" - " + bossName)));
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00c9chec du spawn du crystal"));
        return 0;
    }
}

