/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.client.gui.screens;

import com.necro.raid.dens.common.CobblemonRaidDensClient;
import com.necro.raid.dens.common.client.gui.RaidScreenComponents;
import com.necro.raid.dens.common.client.gui.buttons.AbstractRaidButton;
import com.necro.raid.dens.common.client.gui.screens.AbstractOverlay;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class RaidReadyOverlay
extends AbstractOverlay {
    private static final class_2960 OVERLAY = class_2960.method_60655((String)"cobblemonraiddens", (String)"textures/gui/popup/overlay.png");
    private static final int WIDTH = 120;
    private static final int HEIGHT = 90;
    private static Map<String, Boolean> currentReadyStatus = new HashMap<String, Boolean>();
    private final int timeoutSeconds;
    private final List<String> participantNames;
    private final UUID raidId;
    private long startTime;
    private boolean isReady = false;

    public RaidReadyOverlay(int timeoutSeconds, List<String> participantNames, UUID raidId) {
        this.timeoutSeconds = timeoutSeconds;
        this.participantNames = participantNames;
        this.raidId = raidId;
        this.startTime = System.currentTimeMillis();
        currentReadyStatus.clear();
        for (String name : participantNames) {
            currentReadyStatus.put(name, false);
        }
    }

    public static void updateReadyStatus(Map<String, Boolean> status) {
        currentReadyStatus.putAll(status);
    }

    @Override
    public void render(class_332 guiGraphics, int maxX, int maxY, float partialTick) {
        class_327 font = class_310.method_1551().field_1772;
        int x = (int)((double)((maxX - 120) * CobblemonRaidDensClient.CLIENT_CONFIG.raid_popup_x) / 100.0);
        int y = (int)((double)((maxY - 90) * CobblemonRaidDensClient.CLIENT_CONFIG.raid_popup_y) / 100.0);
        long elapsed = (System.currentTimeMillis() - this.startTime) / 1000L;
        int remaining = Math.max(0, this.timeoutSeconds - (int)elapsed);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)x, (float)y, 4000.0f);
        guiGraphics.method_25294(0, 0, 120, 90, -872415232);
        guiGraphics.method_25294(1, 1, 119, 89, -869059789);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(0.85f, 0.85f, 1.0f);
        guiGraphics.method_27534(font, (class_2561)class_2561.method_43471((String)"screen.cobblemonraiddens.ready.title").method_27692(class_124.field_1065), 70, 8, 0xFFFFFF);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(0.5f, 0.5f, 1.0f);
        int listY = 40;
        for (int i = 0; i < Math.min(this.participantNames.size(), 4); ++i) {
            String playerName = this.participantNames.get(i);
            boolean ready = currentReadyStatus.getOrDefault(playerName, false);
            int color = ready ? 65280 : 0xFFFFFF;
            String status = ready ? "[READY]" : "[...]";
            guiGraphics.method_51433(font, playerName + " " + status, 20, listY + i * 12, color, false);
        }
        class_124 countdownColor = remaining <= 10 ? class_124.field_1061 : class_124.field_1054;
        guiGraphics.method_27534(font, (class_2561)class_2561.method_43469((String)"screen.cobblemonraiddens.ready.timeout", (Object[])new Object[]{remaining}).method_27692(countdownColor), 120, 130, 0xFFFFFF);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22909();
        if (!this.isReady) {
            RaidScreenComponents.ACCEPT_READY_BUTTON.setPos(x + 37, y + 90 - 25);
            RaidScreenComponents.ACCEPT_READY_BUTTON.renderStatic(guiGraphics);
        }
    }

    @Override
    public List<AbstractRaidButton> getButtons() {
        if (!this.isReady) {
            return List.of(RaidScreenComponents.ACCEPT_READY_BUTTON);
        }
        return List.of();
    }

    public void setReady() {
        this.isReady = true;
        String myName = class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.method_5477().getString() : "";
        currentReadyStatus.put(myName, true);
    }

    public boolean isReady() {
        return this.isReady;
    }

    public UUID getRaidId() {
        return this.raidId;
    }

    public List<String> getParticipantNames() {
        return this.participantNames;
    }
}

