/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.client.gui.screens;

import com.necro.raid.dens.common.CobblemonRaidDensClient;
import com.necro.raid.dens.common.client.gui.RaidScreenComponents;
import com.necro.raid.dens.common.client.gui.buttons.AbstractRaidButton;
import com.necro.raid.dens.common.client.gui.screens.AbstractOverlay;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class RaidInviteOverlay
extends AbstractOverlay {
    private static final class_2960 OVERLAY = class_2960.method_60655((String)"cobblemonraiddens", (String)"textures/gui/popup/overlay.png");
    private static final int WIDTH = 120;
    private static final int HEIGHT = 100;
    private final List<String> playerNames;
    private final int maxInvites;
    private final UUID crystalUuid;
    private final Set<String> selectedPlayers = new HashSet<String>();

    public RaidInviteOverlay(List<String> playerNames, int maxInvites, UUID crystalUuid) {
        this.playerNames = playerNames;
        this.maxInvites = maxInvites;
        this.crystalUuid = crystalUuid;
    }

    @Override
    public void render(class_332 guiGraphics, int maxX, int maxY, float partialTick) {
        class_327 font = class_310.method_1551().field_1772;
        int x = (int)((double)((maxX - 120) * CobblemonRaidDensClient.CLIENT_CONFIG.raid_popup_x) / 100.0);
        int y = (int)((double)((maxY - 100) * CobblemonRaidDensClient.CLIENT_CONFIG.raid_popup_y) / 100.0);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)x, (float)y, 4000.0f);
        guiGraphics.method_25294(0, 0, 120, 100, -872415232);
        guiGraphics.method_25294(1, 1, 119, 99, -869059789);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(0.85f, 0.85f, 1.0f);
        guiGraphics.method_27534(font, (class_2561)class_2561.method_43471((String)"screen.cobblemonraiddens.invite.title").method_27692(class_124.field_1065), 70, 8, 0xFFFFFF);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(0.5f, 0.5f, 1.0f);
        int listY = 40;
        for (int i = 0; i < Math.min(this.playerNames.size(), 6); ++i) {
            String playerName = this.playerNames.get(i);
            boolean selected = this.selectedPlayers.contains(playerName);
            int color = selected ? 65280 : 0xFFFFFF;
            String prefix = selected ? "[X] " : "[ ] ";
            guiGraphics.method_51433(font, prefix + playerName, 20, listY + i * 12, color, false);
        }
        guiGraphics.method_27534(font, (class_2561)class_2561.method_43470((String)(this.selectedPlayers.size() + "/" + this.maxInvites + " selected")), 120, 170, 0xAAAAAA);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22909();
        RaidScreenComponents.SEND_INVITES_BUTTON.setPos(x + 4, y + 100 - 25);
        RaidScreenComponents.SEND_INVITES_BUTTON.renderStatic(guiGraphics);
        RaidScreenComponents.START_SOLO_BUTTON.setPos(x + 120 - 49, y + 100 - 25);
        RaidScreenComponents.START_SOLO_BUTTON.renderStatic(guiGraphics);
    }

    @Override
    public List<AbstractRaidButton> getButtons() {
        return List.of(RaidScreenComponents.START_SOLO_BUTTON, RaidScreenComponents.SEND_INVITES_BUTTON);
    }

    public void togglePlayer(String playerName) {
        if (this.selectedPlayers.contains(playerName)) {
            this.selectedPlayers.remove(playerName);
        } else if (this.selectedPlayers.size() < this.maxInvites) {
            this.selectedPlayers.add(playerName);
        }
    }

    public List<String> getPlayerNames() {
        return this.playerNames;
    }

    public Set<String> getSelectedPlayers() {
        return this.selectedPlayers;
    }

    public UUID getCrystalUuid() {
        return this.crystalUuid;
    }
}

