/*
 * Decompiled with CFR 0.152.
 */
package com.cobblehunts.utils;

import com.cobblehunts.CobbleHunts;
import com.cobblehunts.HuntInstance;
import com.cobblehunts.PlayerHuntData;
import com.cobblehunts.utils.HuntsConfig;
import com.cobblehunts.utils.SpeciesMatcher;
import com.cobblehunts.utils.TrackingBrushSettings;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.everlastingutils.scheduling.SchedulerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001GB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ-\u0010%\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b'\u0010\bJ%\u0010)\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0015\u00a2\u0006\u0004\b)\u0010*J9\u00100\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u00152\u0006\u0010-\u001a\u00020,2\u0006\u0010/\u001a\u00020.2\u0006\u0010\u0010\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b0\u00101J9\u00105\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b5\u00106J\u001f\u00107\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b7\u00108J'\u0010;\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b;\u0010<R\u0014\u0010=\u001a\u00020#8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020\u001b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u0014\u0010A\u001a\u00020\u001b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bA\u0010@R\u0014\u0010B\u001a\u00020\u001b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bB\u0010@R \u0010E\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020D0C8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010F\u00a8\u0006H"}, d2={"Lcom/cobblehunts/utils/TrailManager;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "init", "(Lnet/minecraft/server/MinecraftServer;)V", "shutdown", "Ljava/util/UUID;", "uuid", "", "hasActiveTrail", "(Ljava/util/UUID;)Z", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_1799;", "stack", "Lnet/minecraft/class_3218;", "world", "Lnet/minecraft/class_2338;", "pos", "handleBrushCompletion", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1799;Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)V", "applyCooldown", "(Lnet/minecraft/class_1799;)V", "", "amount", "applyDurability", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1799;I)V", "Lnet/minecraft/class_1657;", "startPos", "Lnet/minecraft/class_1297;", "target", "", "pokemonName", "startTrail", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_2338;Lnet/minecraft/class_1297;Ljava/lang/String;)Z", "tickParticles", "hitPos", "attemptAdvance", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)I", "start", "Lnet/minecraft/class_243;", "targetVec", "", "maxDist", "tracePath", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Lnet/minecraft/class_243;DLnet/minecraft/class_1657;)Lnet/minecraft/class_2338;", "x", "z", "refY", "findConnectedGround", "(Lnet/minecraft/class_3218;IIILnet/minecraft/class_1657;)Lnet/minecraft/class_2338;", "spawnPacketParticles", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2338;)V", "from", "to", "spawnDirectionalBlast", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2338;Lnet/minecraft/class_2338;)V", "SCHEDULER_ID", "Ljava/lang/String;", "RESULT_NONE", "I", "RESULT_STEP", "RESULT_FINISH", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/cobblehunts/utils/TrailManager$TrailContext;", "playerTrails", "Ljava/util/concurrent/ConcurrentHashMap;", "TrailContext", "cobblehunts"})
public final class TrailManager {
    @NotNull
    public static final TrailManager INSTANCE = new TrailManager();
    @NotNull
    private static final String SCHEDULER_ID = "cobblehunts-trail-particles";
    public static final int RESULT_NONE = 0;
    public static final int RESULT_STEP = 1;
    public static final int RESULT_FINISH = 2;
    @NotNull
    private static final ConcurrentHashMap<UUID, TrailContext> playerTrails = new ConcurrentHashMap();

    private TrailManager() {
    }

    public final void init(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        SchedulerManager.scheduleAtFixedRate((String)SCHEDULER_ID, (MinecraftServer)server, (long)0L, (long)250L, (TimeUnit)TimeUnit.MILLISECONDS, (boolean)false, () -> TrailManager.init$lambda$0(server));
    }

    public final void shutdown() {
        SchedulerManager.shutdown((String)SCHEDULER_ID);
        playerTrails.clear();
    }

    public final boolean hasActiveTrail(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return playerTrails.containsKey(uuid);
    }

    public final void handleBrushCompletion(@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull class_3218 world, @NotNull class_2338 pos) {
        long cooldownMillis;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        TrackingBrushSettings brushConfig = HuntsConfig.INSTANCE.getSettings().getTrackingBrush();
        int result = this.attemptAdvance((class_1657)player, world, pos);
        switch (result) {
            case 1: {
                this.applyDurability(player, stack, brushConfig.getDamageOnStep());
                return;
            }
            case 2: {
                this.applyDurability(player, stack, brushConfig.getDamageOnFinish());
                this.applyCooldown(stack);
                return;
            }
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        if (this.hasActiveTrail(uUID)) {
            player.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<gray>There doesn't seem to be anything here.", null, 2, null), true);
            player.method_5783(class_3417.field_15102, 0.5f, 1.0f);
            return;
        }
        class_9279 data = (class_9279)stack.method_57824(class_9334.field_49628);
        class_9279 class_92792 = data;
        if (class_92792 == null || (class_92792 = class_92792.method_57461()) == null) {
            class_92792 = new class_2487();
        }
        class_9279 nbt = class_92792;
        long lastUsed = nbt.method_10537("cobblehunts:last_used");
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastUsed < (cooldownMillis = (long)brushConfig.getScanCooldownSeconds() * 1000L)) {
            long remaining = (cooldownMillis - (currentTime - lastUsed)) / 1000L + 1L;
            player.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<red>The brush is still dirty... (" + remaining + "s)", null, 2, null), true);
            player.method_5783(class_3417.field_15102, 0.5f, 1.0f);
            return;
        }
        this.applyCooldown(stack);
        this.applyDurability(player, stack, brushConfig.getDamageOnScan());
        ArrayList<HuntInstance> activeHunts = new ArrayList<HuntInstance>();
        PlayerHuntData playerData = CobbleHunts.INSTANCE.getPlayerData(player);
        activeHunts.addAll(playerData.getActivePokemon().values());
        List<HuntInstance> globalHunts = CobbleHunts.INSTANCE.getGlobalHuntStates();
        int n = ((Collection)globalHunts).size();
        for (int i = 0; i < n; ++i) {
            if (playerData.getCompletedGlobalHunts().contains(i)) continue;
            activeHunts.add(globalHunts.get(i));
        }
        if (activeHunts.isEmpty()) {
            player.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<yellow>You aren't hunting anything right now.", null, 2, null), true);
            return;
        }
        double scanRadius = brushConfig.getScanRadius();
        class_238 box = new class_238(player.method_24515()).method_1014(scanRadius);
        List entities = world.method_8390(PokemonEntity.class, box, arg_0 -> TrailManager.handleBrushCompletion$lambda$2(TrailManager::handleBrushCompletion$lambda$1, arg_0));
        PokemonEntity foundEntity = null;
        double closestDist = Double.MAX_VALUE;
        Iterator iterator = activeHunts.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            HuntInstance hunt = (HuntInstance)e;
            for (PokemonEntity entity : entities) {
                double d;
                if (!SpeciesMatcher.INSTANCE.matches(entity.getPokemon(), hunt.getEntry().getSpecies()) || !((d = player.method_5858((class_1297)entity)) < closestDist)) continue;
                closestDist = d;
                foundEntity = entity;
            }
        }
        if (foundEntity != null) {
            String name = foundEntity.getPokemon().getSpecies().getName();
            boolean started = this.startTrail((class_1657)player, pos, (class_1297)foundEntity, name);
            if (started) {
                world.method_8396(null, pos, class_3417.field_26980, class_3419.field_15248, 1.0f, 1.0f);
            } else {
                player.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<red>You can't find a path forward.", null, 2, null), true);
                this.applyDurability(player, stack, brushConfig.getDamageOnFailedScan());
            }
        } else {
            player.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<gray>There hasn't been anything here recently.", null, 2, null), true);
            world.method_8396(null, pos, class_3417.field_19199, class_3419.field_15248, 0.5f, 1.0f);
            this.applyDurability(player, stack, brushConfig.getDamageOnFailedScan());
        }
    }

    private final void applyCooldown(class_1799 stack) {
        class_9279 data = (class_9279)stack.method_57824(class_9334.field_49628);
        class_9279 class_92792 = data;
        if (class_92792 == null || (class_92792 = class_92792.method_57461()) == null) {
            class_92792 = new class_2487();
        }
        class_9279 nbt = class_92792;
        nbt.method_10544("cobblehunts:last_used", System.currentTimeMillis());
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
    }

    private final void applyDurability(class_3222 player, class_1799 stack, int amount) {
        if (player.method_7337() || amount <= 0) {
            return;
        }
        stack.method_7970(amount, (class_1309)player, class_1304.field_6173);
    }

    public final boolean startTrail(@NotNull class_1657 player, @NotNull class_2338 startPos, @NotNull class_1297 target, @NotNull String pokemonName) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)pokemonName, (String)"pokemonName");
        class_1937 class_19372 = player.method_37908();
        class_3218 class_32182 = class_19372 instanceof class_3218 ? (class_3218)class_19372 : null;
        if (class_32182 == null) {
            return false;
        }
        class_3218 world = class_32182;
        TrackingBrushSettings brushConfig = HuntsConfig.INSTANCE.getSettings().getTrackingBrush();
        long timeoutMs = (long)brushConfig.getTrailTimeoutSeconds() * 1000L;
        double stepDist = brushConfig.getTrailStartDistance();
        class_243 class_2432 = target.method_19538();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getPos(...)");
        class_2338 nextPos = this.tracePath(world, startPos, class_2432, stepDist, player);
        if (nextPos == null || Intrinsics.areEqual((Object)nextPos, (Object)startPos)) {
            return false;
        }
        long expiry = System.currentTimeMillis() + timeoutMs;
        Map map = playerTrails;
        UUID uUID = player.method_5667();
        UUID uUID2 = target.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUuid(...)");
        class_5321 class_53212 = world.method_27983();
        Intrinsics.checkNotNullExpressionValue((Object)class_53212, (String)"getRegistryKey(...)");
        TrailContext trailContext = new TrailContext(uUID2, nextPos, expiry, (class_5321<class_1937>)class_53212);
        map.put(uUID, trailContext);
        player.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<gold>You spot fresh tracks for <yellow>" + pokemonName + "<gold>!", null, 2, null), false);
        player.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<gray>Follow them quickly!", null, 2, null), true);
        if (player instanceof class_3222) {
            this.spawnDirectionalBlast((class_3222)player, startPos, nextPos);
        }
        return true;
    }

    private final void tickParticles(MinecraftServer server) {
        if (playerTrails.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Iterator iterator = ((Map)playerTrails).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            UUID playerUuid = (UUID)entry.getKey();
            TrailContext context = (TrailContext)entry.getValue();
            class_3222 player = server.method_3760().method_14602(playerUuid);
            if (currentTime > context.getExpirationTime()) {
                class_3222 class_32222 = player;
                if (class_32222 != null) {
                    class_32222.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<red>The tracks have faded away.", null, 2, null), true);
                }
                class_3222 class_32223 = player;
                if (class_32223 != null) {
                    class_32223.method_5783(class_3417.field_15102, 0.5f, 1.0f);
                }
                iterator.remove();
                continue;
            }
            if (player == null || !Intrinsics.areEqual((Object)player.method_37908().method_27983(), context.getDimension())) continue;
            this.spawnPacketParticles(player, context.getCurrentTargetPos());
        }
    }

    public final int attemptAdvance(@NotNull class_1657 player, @NotNull class_3218 world, @NotNull class_2338 hitPos) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)hitPos, (String)"hitPos");
        TrailContext trailContext = playerTrails.get(player.method_5667());
        if (trailContext == null) {
            return 0;
        }
        TrailContext context = trailContext;
        if (!Intrinsics.areEqual((Object)world.method_27983(), context.getDimension())) {
            player.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<red>The trail is in a different dimension.", null, 2, null), true);
            return 0;
        }
        class_2338 particlePos = context.getCurrentTargetPos().method_10084();
        for (int i = 0; i < 6 && !world.method_8320(particlePos).method_26215(); ++i) {
            particlePos = particlePos.method_10084();
        }
        if (Intrinsics.areEqual((Object)hitPos, (Object)particlePos) || Intrinsics.areEqual((Object)hitPos, (Object)particlePos.method_10074()) || Intrinsics.areEqual((Object)hitPos, (Object)particlePos.method_10084())) {
            class_243 targetVec;
            class_243 currentVec;
            double dist;
            class_1297 target = world.method_14190(context.getTargetEntityUuid());
            if (target == null) {
                player.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<red>The trail leads to nowhere.", null, 2, null), true);
                playerTrails.remove(player.method_5667());
                return 0;
            }
            if (player instanceof class_3222) {
                class_2675 packet = new class_2675((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10253.method_9564()), true, (double)hitPos.method_10263() + 0.5, (double)hitPos.method_10264() + 1.2, (double)hitPos.method_10260() + 0.5, 0.2f, 0.2f, 0.2f, 0.1f, 20);
                ((class_3222)player).field_13987.method_14364((class_2596)packet);
            }
            if ((dist = (currentVec = hitPos.method_46558()).method_1022(targetVec = target.method_19538())) < 10.0) {
                player.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<green>You found it!", null, 2, null), true);
                if (player instanceof class_3222) {
                    class_2675 p = new class_2675((class_2394)class_2398.field_11211, true, target.method_23317(), target.method_23318() + 0.5, target.method_23321(), 0.5f, 0.5f, 0.5f, 0.0f, 20);
                    ((class_3222)player).field_13987.method_14364((class_2596)p);
                    class_2675 f = new class_2675((class_2394)class_2398.field_17909, true, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 0.0f, 0.0f, 0.0f, 0.0f, 1);
                    ((class_3222)player).field_13987.method_14364((class_2596)f);
                }
                playerTrails.remove(player.method_5667());
                return 2;
            }
            TrackingBrushSettings brushConfig = HuntsConfig.INSTANCE.getSettings().getTrackingBrush();
            double stepDist = brushConfig.getTrailStepDistance();
            class_243 class_2432 = target.method_19538();
            Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getPos(...)");
            class_2338 nextPos = this.tracePath(world, hitPos, class_2432, stepDist, player);
            if (nextPos == null || Intrinsics.areEqual((Object)nextPos, (Object)hitPos)) {
                player.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<red>The tracks just stop here.", null, 2, null), true);
                return 0;
            }
            if (player instanceof class_3222) {
                this.spawnDirectionalBlast((class_3222)player, hitPos, nextPos);
            }
            long timeoutMs = (long)brushConfig.getTrailTimeoutSeconds() * 1000L;
            long newExpiry = System.currentTimeMillis() + timeoutMs;
            ((Map)playerTrails).put(player.method_5667(), TrailContext.copy$default(context, null, nextPos, newExpiry, null, 9, null));
            player.method_7353(HuntsConfig.formatText$default(HuntsConfig.INSTANCE, "<green>You found more tracks!", null, 2, null), true);
            return 1;
        }
        return 0;
    }

    private final class_2338 tracePath(class_3218 world, class_2338 start, class_243 targetVec, double maxDist, class_1657 player) {
        class_2338 currentPos = start;
        class_243 startVec = start.method_46558();
        double minRequiredDist = maxDist * 0.5;
        int maxIterations = (int)(maxDist * 1.5) + 5;
        for (int i = 0; i < maxIterations; ++i) {
            double distFromStart = Math.sqrt(currentPos.method_10262((class_2382)start));
            if (distFromStart >= maxDist) {
                return currentPos;
            }
            class_243 currentCenter = currentPos.method_46558();
            double dx = targetVec.field_1352 - currentCenter.field_1352;
            double dz = targetVec.field_1350 - currentCenter.field_1350;
            double angle = Math.atan2(dz, dx);
            int proposedX = class_3532.method_15357((double)(currentCenter.field_1352 + Math.cos(angle)));
            int proposedZ = class_3532.method_15357((double)(currentCenter.field_1350 + Math.sin(angle)));
            if (proposedX == currentPos.method_10263() && proposedZ == currentPos.method_10260()) continue;
            class_2338 groundPos = this.findConnectedGround(world, proposedX, proposedZ, currentPos.method_10264(), player);
            if (groundPos == null) {
                if (distFromStart < minRequiredDist) {
                    return null;
                }
                return currentPos;
            }
            currentPos = groundPos;
        }
        if (Math.sqrt(currentPos.method_10262((class_2382)start)) < minRequiredDist) {
            return null;
        }
        return currentPos;
    }

    private final class_2338 findConnectedGround(class_3218 world, int x, int z, int refY, class_1657 player) {
        class_2338[] class_2338Array = new class_2338[]{new class_2338(x, refY + 1, z), new class_2338(x, refY, z), new class_2338(x, refY - 1, z), new class_2338(x, refY - 2, z)};
        List candidates = CollectionsKt.listOf((Object[])class_2338Array);
        for (class_2338 pos : candidates) {
            class_2680 state = world.method_8320(pos);
            if (!state.method_26168((class_1922)world, pos, (class_1297)player) || !world.method_8320(pos.method_10084()).method_26215() || !world.method_8320(pos.method_10086(2)).method_26215()) continue;
            return pos;
        }
        return null;
    }

    private final void spawnPacketParticles(class_3222 player, class_2338 pos) {
        class_1937 world = player.method_37908();
        class_2338 particlePos = pos.method_10084();
        for (int i = 0; i < 6 && !world.method_8320(particlePos).method_26215(); ++i) {
            particlePos = particlePos.method_10084();
        }
        double x = (double)particlePos.method_10263() + 0.5;
        double y = (double)particlePos.method_10264() + 0.05;
        double z = (double)particlePos.method_10260() + 0.5;
        class_2675 packet = new class_2675((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10253.method_9564()), true, x, y, z, 0.2f, 0.0f, 0.2f, 0.0f, 3);
        player.field_13987.method_14364((class_2596)packet);
        class_2675 smokePacket = new class_2675((class_2394)class_2398.field_17430, true, x, y + 0.2, z, 0.1f, 0.1f, 0.1f, 0.01f, 1);
        player.field_13987.method_14364((class_2596)smokePacket);
    }

    private final void spawnDirectionalBlast(class_3222 player, class_2338 from, class_2338 to) {
        int i;
        class_243 fromVec = from.method_46558().method_1031(0.0, 0.8, 0.0);
        class_243 toVec = to.method_46558().method_1031(0.0, 0.8, 0.0);
        class_243 dir = toVec.method_1020(fromVec).method_1029();
        for (i = 0; i < 16; ++i) {
            double spreadX = (Math.random() - 0.5) * 0.1;
            double spreadY = (Math.random() - 0.5) * 0.1;
            double spreadZ = (Math.random() - 0.5) * 0.1;
            class_2675 dirtPacket = new class_2675((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10253.method_9564()), true, fromVec.field_1352, fromVec.field_1351, fromVec.field_1350, (float)(dir.field_1352 + spreadX), (float)(dir.field_1351 + spreadY + 0.2), (float)(dir.field_1350 + spreadZ), 0.6f, 0);
            player.field_13987.method_14364((class_2596)dirtPacket);
        }
        for (i = 0; i < 6; ++i) {
            class_2675 cloudPacket = new class_2675((class_2394)class_2398.field_11204, true, fromVec.field_1352, fromVec.field_1351, fromVec.field_1350, (float)dir.field_1352, (float)(dir.field_1351 + 0.1), (float)dir.field_1350, 0.3f, 0);
            player.field_13987.method_14364((class_2596)cloudPacket);
        }
    }

    private static final Unit init$lambda$0(MinecraftServer $server) {
        INSTANCE.tickParticles($server);
        return Unit.INSTANCE;
    }

    private static final boolean handleBrushCompletion$lambda$1(PokemonEntity it) {
        return true;
    }

    private static final boolean handleBrushCompletion$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J>\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u000eR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010\u0010R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010\u0012R\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010'\u001a\u0004\b(\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/cobblehunts/utils/TrailManager$TrailContext;", "", "Ljava/util/UUID;", "targetEntityUuid", "Lnet/minecraft/class_2338;", "currentTargetPos", "", "expirationTime", "Lnet/minecraft/class_5321;", "Lnet/minecraft/class_1937;", "dimension", "<init>", "(Ljava/util/UUID;Lnet/minecraft/class_2338;JLnet/minecraft/class_5321;)V", "component1", "()Ljava/util/UUID;", "component2", "()Lnet/minecraft/class_2338;", "component3", "()J", "component4", "()Lnet/minecraft/class_5321;", "copy", "(Ljava/util/UUID;Lnet/minecraft/class_2338;JLnet/minecraft/class_5321;)Lcom/cobblehunts/utils/TrailManager$TrailContext;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/UUID;", "getTargetEntityUuid", "Lnet/minecraft/class_2338;", "getCurrentTargetPos", "J", "getExpirationTime", "Lnet/minecraft/class_5321;", "getDimension", "cobblehunts"})
    private static final class TrailContext {
        @NotNull
        private final UUID targetEntityUuid;
        @NotNull
        private final class_2338 currentTargetPos;
        private final long expirationTime;
        @NotNull
        private final class_5321<class_1937> dimension;

        public TrailContext(@NotNull UUID targetEntityUuid, @NotNull class_2338 currentTargetPos, long expirationTime, @NotNull class_5321<class_1937> dimension) {
            Intrinsics.checkNotNullParameter((Object)targetEntityUuid, (String)"targetEntityUuid");
            Intrinsics.checkNotNullParameter((Object)currentTargetPos, (String)"currentTargetPos");
            Intrinsics.checkNotNullParameter(dimension, (String)"dimension");
            this.targetEntityUuid = targetEntityUuid;
            this.currentTargetPos = currentTargetPos;
            this.expirationTime = expirationTime;
            this.dimension = dimension;
        }

        @NotNull
        public final UUID getTargetEntityUuid() {
            return this.targetEntityUuid;
        }

        @NotNull
        public final class_2338 getCurrentTargetPos() {
            return this.currentTargetPos;
        }

        public final long getExpirationTime() {
            return this.expirationTime;
        }

        @NotNull
        public final class_5321<class_1937> getDimension() {
            return this.dimension;
        }

        @NotNull
        public final UUID component1() {
            return this.targetEntityUuid;
        }

        @NotNull
        public final class_2338 component2() {
            return this.currentTargetPos;
        }

        public final long component3() {
            return this.expirationTime;
        }

        @NotNull
        public final class_5321<class_1937> component4() {
            return this.dimension;
        }

        @NotNull
        public final TrailContext copy(@NotNull UUID targetEntityUuid, @NotNull class_2338 currentTargetPos, long expirationTime, @NotNull class_5321<class_1937> dimension) {
            Intrinsics.checkNotNullParameter((Object)targetEntityUuid, (String)"targetEntityUuid");
            Intrinsics.checkNotNullParameter((Object)currentTargetPos, (String)"currentTargetPos");
            Intrinsics.checkNotNullParameter(dimension, (String)"dimension");
            return new TrailContext(targetEntityUuid, currentTargetPos, expirationTime, dimension);
        }

        public static /* synthetic */ TrailContext copy$default(TrailContext trailContext, UUID uUID, class_2338 class_23382, long l, class_5321 class_53212, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = trailContext.targetEntityUuid;
            }
            if ((n & 2) != 0) {
                class_23382 = trailContext.currentTargetPos;
            }
            if ((n & 4) != 0) {
                l = trailContext.expirationTime;
            }
            if ((n & 8) != 0) {
                class_53212 = trailContext.dimension;
            }
            return trailContext.copy(uUID, class_23382, l, class_53212);
        }

        @NotNull
        public String toString() {
            return "TrailContext(targetEntityUuid=" + this.targetEntityUuid + ", currentTargetPos=" + this.currentTargetPos + ", expirationTime=" + this.expirationTime + ", dimension=" + this.dimension + ")";
        }

        public int hashCode() {
            int result = this.targetEntityUuid.hashCode();
            result = result * 31 + this.currentTargetPos.hashCode();
            result = result * 31 + Long.hashCode(this.expirationTime);
            result = result * 31 + this.dimension.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrailContext)) {
                return false;
            }
            TrailContext trailContext = (TrailContext)other;
            if (!Intrinsics.areEqual((Object)this.targetEntityUuid, (Object)trailContext.targetEntityUuid)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.currentTargetPos, (Object)trailContext.currentTargetPos)) {
                return false;
            }
            if (this.expirationTime != trailContext.expirationTime) {
                return false;
            }
            return Intrinsics.areEqual(this.dimension, trailContext.dimension);
        }
    }
}

