/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis;

import com.cobblemon.mod.common.api.scheduling.ScheduledTask;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import io.github.stainlessstasis.alert.DespawnReason;
import io.github.stainlessstasis.core.CobblemonSpawnAlerts;
import io.github.stainlessstasis.core.CommandRegistry;
import io.github.stainlessstasis.network.AlertDataPacket;
import io.github.stainlessstasis.network.DespawnDataPacket;
import io.github.stainlessstasis.network.ModLoadedPacket;
import io.github.stainlessstasis.network.PokemonDataPacket;
import io.github.stainlessstasis.platform.Services;
import kotlin.Unit;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3244;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class CSAFabric
implements ModInitializer {
    public void onInitialize() {
        CobblemonSpawnAlerts.initServer();
        CommandRegistrationCallback.EVENT.register(CommandRegistry::registerServerCommands);
        ServerPlayConnectionEvents.JOIN.register(this::onPlayerJoin);
        ServerEntityEvents.ENTITY_UNLOAD.register(this::onEntityUnload);
        PayloadTypeRegistry.playS2C().register(PokemonDataPacket.ID, PokemonDataPacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(AlertDataPacket.ID, AlertDataPacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(DespawnDataPacket.ID, DespawnDataPacket.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(ModLoadedPacket.ID, ModLoadedPacket.STREAM_CODEC);
    }

    private void onEntityUnload(class_1297 entity, class_3218 serverLevel) {
        PokemonEntity pokemonEntity;
        if (entity instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)entity).method_6139() == null && CobblemonSpawnAlerts.globallyAlerted.contains(pokemonEntity.getPokemon().getUuid())) {
            new ScheduledTask.Builder().delay(5.0f).execute(task -> {
                if (CobblemonSpawnAlerts.despawned.contains(pokemonEntity.getPokemon().getUuid())) {
                    CobblemonSpawnAlerts.despawned.remove(pokemonEntity.getPokemon().getUuid());
                    return Unit.INSTANCE;
                }
                Services.PLATFORM.onPokemonDespawned((class_1937)serverLevel, pokemonEntity.getPokemon(), "N/A", DespawnReason.DESPAWNED);
                return Unit.INSTANCE;
            }).build();
        }
    }

    private void onPlayerJoin(class_3244 serverGamePacketListener, PacketSender packetSender, MinecraftServer minecraftServer) {
        packetSender.sendPacket((class_8710)new ModLoadedPacket(true));
    }
}

