/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemonbattle.gui;

import com.cobblemonbattle.CobblemonBattle;
import com.cobblemonbattle.arena.Arena;
import com.cobblemonbattle.duel.BestOf;
import com.cobblemonbattle.duel.DuelInvitation;
import com.cobblemonbattle.duel.DuelManager;
import com.cobblemonbattle.duel.DuelType;
import com.cobblemonbattle.gui.DuelGuiManager;
import com.cobblemonbattle.gui.DuelGuiState;
import com.cobblemonbattle.gui.GuiHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class DuelScreenHandler
extends class_1707 {
    private final class_3222 player;
    private final DuelGuiState state;
    private final class_1277 inventory;
    private final Map<Integer, Runnable> clickHandlers;
    private List<class_3222> cachedOnlinePlayers;
    private List<Arena> cachedArenas;

    public DuelScreenHandler(int syncId, class_1661 playerInventory, class_3222 player) {
        super(class_3917.field_17326, syncId, playerInventory, (class_1263)new class_1277(27), 3);
        this.player = player;
        this.state = DuelGuiManager.getOrCreateState(player.method_5667());
        this.inventory = (class_1277)this.method_7629();
        this.clickHandlers = new HashMap<Integer, Runnable>();
        this.cachedOnlinePlayers = new ArrayList<class_3222>();
        this.cachedArenas = new ArrayList<Arena>();
        this.loadCurrentGui();
    }

    private void loadCurrentGui() {
        this.clearInventory();
        this.clickHandlers.clear();
        switch (this.state.getCurrentGui()) {
            case MAIN_MENU: {
                this.loadMainMenu();
                break;
            }
            case PARTNER_SELECT: {
                this.loadPartnerSelect();
                break;
            }
            case OPPONENT_SELECT: {
                this.loadOpponentSelect();
                break;
            }
            case BEST_OF_SELECT: {
                this.loadBestOfSelect();
                break;
            }
            case ARENA_SELECT: {
                this.loadArenaSelect();
            }
        }
    }

    private void clearInventory() {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            this.inventory.method_5447(i, class_1799.field_8037);
        }
    }

    private void loadMainMenu() {
        for (int i = 0; i < 27; ++i) {
            this.inventory.method_5447(i, GuiHelper.createFillerPane());
        }
        this.inventory.method_5447(11, GuiHelper.create1v1Button());
        this.clickHandlers.put(11, () -> {
            this.state.setDuelType(DuelType.ONE_V_ONE);
            this.state.setCurrentGui(DuelGuiState.GuiType.OPPONENT_SELECT);
            this.loadCurrentGui();
        });
        this.inventory.method_5447(15, GuiHelper.create2v2Button());
        this.clickHandlers.put(15, () -> {
            this.state.setDuelType(DuelType.TWO_V_TWO);
            this.state.setCurrentGui(DuelGuiState.GuiType.PARTNER_SELECT);
            this.loadCurrentGui();
        });
        this.inventory.method_5447(22, GuiHelper.createCancelButton());
        this.clickHandlers.put(22, this::closeAndReset);
    }

    private void loadPartnerSelect() {
        this.clearInventory();
        this.cacheOnlinePlayers();
        int slot = 0;
        for (class_3222 online : this.cachedOnlinePlayers) {
            if (slot >= 26) break;
            if (online.method_5667().equals(this.player.method_5667())) continue;
            UUID partnerId = online.method_5667();
            this.inventory.method_5447(slot, GuiHelper.createPlayerHead(online, List.of(class_2561.method_43470((String)"Click to select as partner").method_27694(s -> s.method_36139(0xAAAAAA)))));
            this.clickHandlers.put(slot, () -> {
                this.state.setPartnerId(partnerId);
                this.state.setCurrentGui(DuelGuiState.GuiType.OPPONENT_SELECT);
                this.loadCurrentGui();
            });
            ++slot;
        }
        this.inventory.method_5447(26, GuiHelper.createCancelButton());
        this.clickHandlers.put(26, this::closeAndReset);
    }

    private void loadOpponentSelect() {
        this.clearInventory();
        this.cacheOnlinePlayers();
        int requiredOpponents = this.state.getRequiredOpponents();
        int selectedCount = this.state.getOpponentIds().size();
        int slot = 0;
        for (class_3222 online : this.cachedOnlinePlayers) {
            if (slot >= 25) break;
            if (online.method_5667().equals(this.player.method_5667()) || this.state.getDuelType() == DuelType.TWO_V_TWO && online.method_5667().equals(this.state.getPartnerId())) continue;
            UUID opponentId = online.method_5667();
            boolean isSelected = this.state.getOpponentIds().contains(opponentId);
            ArrayList<class_2561> lore = new ArrayList<class_2561>();
            if (isSelected) {
                lore.add((class_2561)class_2561.method_43470((String)"SELECTED").method_27694(s -> s.method_36139(65280)));
                lore.add((class_2561)class_2561.method_43470((String)"Click to deselect").method_27694(s -> s.method_36139(0xAAAAAA)));
            } else {
                lore.add((class_2561)class_2561.method_43470((String)"Click to select").method_27694(s -> s.method_36139(0xAAAAAA)));
            }
            class_1799 head = GuiHelper.createPlayerHead(online, lore);
            if (isSelected) {
                head.method_7939(1);
            }
            this.inventory.method_5447(slot, head);
            this.clickHandlers.put(slot, () -> {
                if (this.state.getOpponentIds().contains(opponentId)) {
                    this.state.removeOpponent(opponentId);
                } else if (this.state.getOpponentIds().size() < requiredOpponents) {
                    this.state.addOpponent(opponentId);
                }
                if (this.state.hasEnoughOpponents()) {
                    this.state.setCurrentGui(DuelGuiState.GuiType.BEST_OF_SELECT);
                }
                this.loadCurrentGui();
            });
            ++slot;
        }
        this.inventory.method_5447(25, GuiHelper.createItem(new class_1799((class_1935)class_1802.field_8407), "Selected: " + selectedCount + "/" + requiredOpponents, class_124.field_1054));
        this.inventory.method_5447(26, GuiHelper.createCancelButton());
        this.clickHandlers.put(26, this::closeAndReset);
    }

    private void loadBestOfSelect() {
        this.clearInventory();
        for (int i = 0; i < 27; ++i) {
            this.inventory.method_5447(i, GuiHelper.createFillerPane());
        }
        this.inventory.method_5447(11, GuiHelper.createBO1Button());
        this.clickHandlers.put(11, () -> {
            this.state.setBestOf(BestOf.BO1);
            this.state.setCurrentGui(DuelGuiState.GuiType.ARENA_SELECT);
            this.loadCurrentGui();
        });
        this.inventory.method_5447(13, GuiHelper.createBO3Button());
        this.clickHandlers.put(13, () -> {
            this.state.setBestOf(BestOf.BO3);
            this.state.setCurrentGui(DuelGuiState.GuiType.ARENA_SELECT);
            this.loadCurrentGui();
        });
        this.inventory.method_5447(15, GuiHelper.createBO5Button());
        this.clickHandlers.put(15, () -> {
            this.state.setBestOf(BestOf.BO5);
            this.state.setCurrentGui(DuelGuiState.GuiType.ARENA_SELECT);
            this.loadCurrentGui();
        });
        this.inventory.method_5447(22, GuiHelper.createCancelButton());
        this.clickHandlers.put(22, this::closeAndReset);
    }

    private void loadArenaSelect() {
        this.clearInventory();
        this.cacheArenas();
        int slot = 0;
        for (Arena arena : this.cachedArenas) {
            if (slot >= 26) break;
            boolean isReady = this.state.getDuelType() == DuelType.ONE_V_ONE ? arena.is1v1Ready() : arena.is2v2Ready();
            boolean isAvailable = arena.isAvailable();
            this.inventory.method_5447(slot, GuiHelper.createArenaItem(arena.getName(), isAvailable, isReady));
            if (isReady && isAvailable) {
                Arena selectedArena = arena;
                this.clickHandlers.put(slot, () -> {
                    this.state.setSelectedArena(selectedArena);
                    this.sendInvitation();
                });
            }
            ++slot;
        }
        if (this.cachedArenas.isEmpty()) {
            this.inventory.method_5447(13, GuiHelper.createItem(new class_1799((class_1935)class_1802.field_8077), "No arenas available", class_124.field_1061, List.of(class_2561.method_43470((String)"Ask an admin to create arenas").method_27694(s -> s.method_36139(0xAAAAAA)))));
        }
        this.inventory.method_5447(26, GuiHelper.createCancelButton());
        this.clickHandlers.put(26, this::closeAndReset);
    }

    private void cacheOnlinePlayers() {
        this.cachedOnlinePlayers = new ArrayList<class_3222>(this.player.method_5682().method_3760().method_14571());
        this.cachedOnlinePlayers.removeIf(p -> p.method_5667().equals(this.player.method_5667()));
    }

    private void cacheArenas() {
        this.cachedArenas = this.state.getDuelType() == DuelType.ONE_V_ONE ? new ArrayList<Arena>(CobblemonBattle.getInstance().getArenaManager().get1v1Arenas()) : new ArrayList<Arena>(CobblemonBattle.getInstance().getArenaManager().get2v2Arenas());
    }

    private void sendInvitation() {
        DuelManager duelManager = CobblemonBattle.getInstance().getDuelManager();
        duelManager.setServer(this.player.method_5682());
        ArrayList<UUID> teamRocket = new ArrayList<UUID>();
        ArrayList<UUID> teamPlasma = new ArrayList<UUID>(this.state.getOpponentIds());
        teamRocket.add(this.player.method_5667());
        if (this.state.getDuelType() == DuelType.TWO_V_TWO && this.state.getPartnerId() != null) {
            teamRocket.add(this.state.getPartnerId());
        }
        DuelInvitation invitation = duelManager.createInvitation(this.state.getDuelType(), this.state.getBestOf(), this.state.getSelectedArena(), this.player, teamRocket, teamPlasma);
        duelManager.sendInvitations(invitation);
        this.closeAndReset();
    }

    private void closeAndReset() {
        this.state.reset();
        this.player.method_7346();
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 playerEntity) {
        Runnable handler;
        if (slotIndex >= 0 && slotIndex < this.inventory.method_5439() && (handler = this.clickHandlers.get(slotIndex)) != null) {
            handler.run();
            return;
        }
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }
}

