/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemonbattle.gui;

import com.cobblemonbattle.arena.Arena;
import com.cobblemonbattle.duel.BestOf;
import com.cobblemonbattle.duel.DuelType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class DuelGuiState {
    private DuelType duelType;
    private UUID partnerId;
    private List<UUID> opponentIds = new ArrayList<UUID>();
    private BestOf bestOf;
    private Arena selectedArena;
    private GuiType currentGui = GuiType.MAIN_MENU;

    public void reset() {
        this.duelType = null;
        this.partnerId = null;
        this.opponentIds.clear();
        this.bestOf = null;
        this.selectedArena = null;
        this.currentGui = GuiType.MAIN_MENU;
    }

    public DuelType getDuelType() {
        return this.duelType;
    }

    public void setDuelType(DuelType duelType) {
        this.duelType = duelType;
    }

    public UUID getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(UUID partnerId) {
        this.partnerId = partnerId;
    }

    public List<UUID> getOpponentIds() {
        return this.opponentIds;
    }

    public void addOpponent(UUID opponentId) {
        if (!this.opponentIds.contains(opponentId)) {
            this.opponentIds.add(opponentId);
        }
    }

    public void removeOpponent(UUID opponentId) {
        this.opponentIds.remove(opponentId);
    }

    public BestOf getBestOf() {
        return this.bestOf;
    }

    public void setBestOf(BestOf bestOf) {
        this.bestOf = bestOf;
    }

    public Arena getSelectedArena() {
        return this.selectedArena;
    }

    public void setSelectedArena(Arena selectedArena) {
        this.selectedArena = selectedArena;
    }

    public GuiType getCurrentGui() {
        return this.currentGui;
    }

    public void setCurrentGui(GuiType currentGui) {
        this.currentGui = currentGui;
    }

    public int getRequiredOpponents() {
        return this.duelType == DuelType.TWO_V_TWO ? 2 : 1;
    }

    public boolean hasEnoughOpponents() {
        return this.opponentIds.size() >= this.getRequiredOpponents();
    }

    public static enum GuiType {
        MAIN_MENU,
        PARTNER_SELECT,
        OPPONENT_SELECT,
        BEST_OF_SELECT,
        ARENA_SELECT,
        READY_CHECK;

    }
}

