/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemonbattle.duel;

import com.cobblemonbattle.CobblemonBattle;
import com.cobblemonbattle.arena.Arena;
import com.cobblemonbattle.arena.ArenaStatus;
import com.cobblemonbattle.duel.BestOf;
import com.cobblemonbattle.duel.CobblemonBattleIntegration;
import com.cobblemonbattle.duel.DuelInvitation;
import com.cobblemonbattle.duel.DuelResult;
import com.cobblemonbattle.duel.DuelType;
import com.cobblemonbattle.team.TeamType;
import com.cobblemonbattle.util.MessageUtil;
import com.cobblemonbattle.util.PlayerState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class DuelSession {
    private final String id;
    private final DuelType type;
    private final BestOf bestOf;
    private final Arena arena;
    private final List<UUID> teamRocket;
    private final List<UUID> teamPlasma;
    private final Map<UUID, PlayerState> savedStates;
    private final List<DuelResult> results;
    private int teamRocketWins;
    private int teamPlasmaWins;
    private int currentRound;
    private boolean active;
    private UUID currentBattleId;

    public DuelSession(DuelInvitation invitation) {
        this.id = invitation.getId();
        this.type = invitation.getType();
        this.bestOf = invitation.getBestOf();
        this.arena = invitation.getArena();
        this.teamRocket = new ArrayList<UUID>(invitation.getTeamRocket());
        this.teamPlasma = new ArrayList<UUID>(invitation.getTeamPlasma());
        this.savedStates = new HashMap<UUID, PlayerState>();
        this.results = new ArrayList<DuelResult>();
        this.teamRocketWins = 0;
        this.teamPlasmaWins = 0;
        this.currentRound = 1;
        this.active = false;
        this.currentBattleId = null;
    }

    public String getId() {
        return this.id;
    }

    public DuelType getType() {
        return this.type;
    }

    public BestOf getBestOf() {
        return this.bestOf;
    }

    public Arena getArena() {
        return this.arena;
    }

    public List<UUID> getTeamRocket() {
        return Collections.unmodifiableList(this.teamRocket);
    }

    public List<UUID> getTeamPlasma() {
        return Collections.unmodifiableList(this.teamPlasma);
    }

    public Set<UUID> getAllPlayerUUIDs() {
        HashSet<UUID> all = new HashSet<UUID>();
        all.addAll(this.teamRocket);
        all.addAll(this.teamPlasma);
        return all;
    }

    public boolean isPlayerInSession(UUID playerId) {
        return this.getAllPlayerUUIDs().contains(playerId);
    }

    public TeamType getPlayerTeam(UUID playerId) {
        if (this.teamRocket.contains(playerId)) {
            return TeamType.TEAM_ROCKET;
        }
        if (this.teamPlasma.contains(playerId)) {
            return TeamType.TEAM_PLASMA;
        }
        return null;
    }

    public void start(MinecraftServer server) {
        this.active = true;
        this.arena.setStatus(ArenaStatus.IN_USE);
        for (UUID playerId : this.getAllPlayerUUIDs()) {
            class_3222 player = server.method_3760().method_14602(playerId);
            if (player == null) continue;
            this.savedStates.put(playerId, new PlayerState(player));
            this.teleportToSpawn(player);
            MessageUtil.sendInfo(player, "Duel starting! Round " + this.currentRound + "/" + this.bestOf.getTotalRounds());
        }
        this.startCobblemonBattle(server);
    }

    private void teleportToSpawn(class_3222 player) {
        UUID playerId = player.method_5667();
        TeamType team = this.getPlayerTeam(playerId);
        if (team == null) {
            return;
        }
        if (this.type == DuelType.ONE_V_ONE) {
            if (team == TeamType.TEAM_ROCKET) {
                this.arena.getSpawn1v1_1().teleport(player);
            } else {
                this.arena.getSpawn1v1_2().teleport(player);
            }
        } else {
            int teamIndex = team == TeamType.TEAM_ROCKET ? this.teamRocket.indexOf(playerId) : this.teamPlasma.indexOf(playerId);
            String spawnId = team.getSpawnPrefix() + (teamIndex + 1);
            this.arena.getSpawn2v2(spawnId).teleport(player);
        }
    }

    private void startCobblemonBattle(MinecraftServer server) {
        class_3222 player;
        ArrayList<class_3222> rocketPlayers = new ArrayList<class_3222>();
        ArrayList<class_3222> plasmaPlayers = new ArrayList<class_3222>();
        for (UUID id : this.teamRocket) {
            player = server.method_3760().method_14602(id);
            if (player == null) continue;
            rocketPlayers.add(player);
        }
        for (UUID id : this.teamPlasma) {
            player = server.method_3760().method_14602(id);
            if (player == null) continue;
            plasmaPlayers.add(player);
        }
        CobblemonBattleIntegration.startBattle(this, rocketPlayers, plasmaPlayers, this.type);
    }

    public void onRoundEnd(TeamType winner) {
        this.results.add(new DuelResult(this.currentRound, winner));
        if (winner == TeamType.TEAM_ROCKET) {
            ++this.teamRocketWins;
        } else {
            ++this.teamPlasmaWins;
        }
        this.broadcastMessage((class_2561)class_2561.method_43470((String)(winner.getDisplayName() + " wins round " + this.currentRound + "!")).method_27692(winner.getColor()));
        if (this.teamRocketWins >= this.bestOf.getWinsRequired()) {
            this.endMatch(TeamType.TEAM_ROCKET);
        } else if (this.teamPlasmaWins >= this.bestOf.getWinsRequired()) {
            this.endMatch(TeamType.TEAM_PLASMA);
        } else {
            ++this.currentRound;
            this.broadcastMessage((class_2561)class_2561.method_43470((String)("Starting round " + this.currentRound + "...")).method_27692(class_124.field_1054));
            this.startCobblemonBattle(CobblemonBattle.getInstance().getDuelManager().getServer());
        }
    }

    private void endMatch(TeamType winner) {
        this.active = false;
        this.arena.setStatus(ArenaStatus.AVAILABLE);
        String score = winner == TeamType.TEAM_ROCKET ? this.teamRocketWins + "-" + this.teamPlasmaWins : this.teamPlasmaWins + "-" + this.teamRocketWins;
        this.broadcastMessage((class_2561)class_2561.method_43470((String)(winner.getDisplayName() + " wins the match " + score + "!")).method_27695(new class_124[]{winner.getColor(), class_124.field_1067}));
        MinecraftServer server = CobblemonBattle.getInstance().getDuelManager().getServer();
        for (Map.Entry<UUID, PlayerState> entry : this.savedStates.entrySet()) {
            class_3222 player = server.method_3760().method_14602(entry.getKey());
            if (player == null) continue;
            entry.getValue().restore(player);
            MessageUtil.sendInfo(player, "Returning to your original position...");
        }
        CobblemonBattle.getInstance().getDuelManager().endSession(this);
    }

    public void cancel() {
        this.active = false;
        this.arena.setStatus(ArenaStatus.AVAILABLE);
        MinecraftServer server = CobblemonBattle.getInstance().getDuelManager().getServer();
        for (Map.Entry<UUID, PlayerState> entry : this.savedStates.entrySet()) {
            class_3222 player = server.method_3760().method_14602(entry.getKey());
            if (player == null) continue;
            entry.getValue().restore(player);
            MessageUtil.sendError(player, "Duel cancelled. Returning to your original position.");
        }
    }

    private void broadcastMessage(class_2561 message) {
        MinecraftServer server = CobblemonBattle.getInstance().getDuelManager().getServer();
        for (UUID playerId : this.getAllPlayerUUIDs()) {
            class_3222 player = server.method_3760().method_14602(playerId);
            if (player == null) continue;
            player.method_7353(message, false);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public int getCurrentRound() {
        return this.currentRound;
    }

    public int getTeamRocketWins() {
        return this.teamRocketWins;
    }

    public int getTeamPlasmaWins() {
        return this.teamPlasmaWins;
    }

    public UUID getCurrentBattleId() {
        return this.currentBattleId;
    }

    public void setCurrentBattleId(UUID battleId) {
        this.currentBattleId = battleId;
    }
}

