/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemonbattle.duel;

import com.cobblemonbattle.arena.Arena;
import com.cobblemonbattle.duel.BestOf;
import com.cobblemonbattle.duel.DuelInvitation;
import com.cobblemonbattle.duel.DuelSession;
import com.cobblemonbattle.duel.DuelType;
import com.cobblemonbattle.util.MessageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class DuelManager {
    private final Map<String, DuelInvitation> pendingInvitations = new ConcurrentHashMap<String, DuelInvitation>();
    private final Map<String, DuelSession> activeSessions = new ConcurrentHashMap<String, DuelSession>();
    private final Map<UUID, String> playerInvitations = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, String> playerSessions = new ConcurrentHashMap<UUID, String>();
    private MinecraftServer server;

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public String generateInvitationId() {
        return UUID.randomUUID().toString().substring(0, 8);
    }

    public DuelInvitation createInvitation(DuelType type, BestOf bestOf, Arena arena, class_3222 initiator, List<UUID> teamRocket, List<UUID> teamPlasma) {
        String id = this.generateInvitationId();
        DuelInvitation invitation = new DuelInvitation(id, type, bestOf, arena, initiator, teamRocket, teamPlasma);
        this.pendingInvitations.put(id, invitation);
        for (UUID playerId : invitation.getAllPlayerUUIDs()) {
            this.playerInvitations.put(playerId, id);
        }
        return invitation;
    }

    public Optional<DuelInvitation> getInvitation(String id) {
        return Optional.ofNullable(this.pendingInvitations.get(id));
    }

    public Optional<DuelInvitation> getPlayerInvitation(UUID playerId) {
        String invitationId = this.playerInvitations.get(playerId);
        if (invitationId != null) {
            return Optional.ofNullable(this.pendingInvitations.get(invitationId));
        }
        return Optional.empty();
    }

    public boolean acceptInvitation(class_3222 player, String invitationId) {
        DuelInvitation invitation = this.pendingInvitations.get(invitationId);
        if (invitation == null) {
            MessageUtil.sendError(player, "Invitation not found or expired.");
            return false;
        }
        if (invitation.isExpired()) {
            this.cancelInvitation(invitationId);
            MessageUtil.sendError(player, "This invitation has expired.");
            return false;
        }
        if (!invitation.isPlayerInvolved(player.method_5667())) {
            MessageUtil.sendError(player, "This invitation is not for you.");
            return false;
        }
        if (invitation.hasAccepted(player.method_5667())) {
            MessageUtil.sendInfo(player, "You have already accepted this invitation.");
            return false;
        }
        invitation.accept(player.method_5667());
        MessageUtil.sendSuccess(player, "You accepted the duel invitation!");
        this.broadcastToInvitation(invitation, player.method_5477().getString() + " is ready! (" + invitation.getAcceptedCount() + "/" + invitation.getTotalPlayers() + ")");
        if (invitation.allAccepted()) {
            this.startDuel(invitation);
        }
        return true;
    }

    public boolean denyInvitation(class_3222 player, String invitationId) {
        DuelInvitation invitation = this.pendingInvitations.get(invitationId);
        if (invitation == null) {
            MessageUtil.sendError(player, "Invitation not found.");
            return false;
        }
        if (!invitation.isPlayerInvolved(player.method_5667())) {
            MessageUtil.sendError(player, "This invitation is not for you.");
            return false;
        }
        this.cancelInvitation(invitationId);
        this.broadcastToInvitation(invitation, player.method_5477().getString() + " declined the duel.");
        return true;
    }

    private void startDuel(DuelInvitation invitation) {
        this.pendingInvitations.remove(invitation.getId());
        for (UUID playerId : invitation.getAllPlayerUUIDs()) {
            this.playerInvitations.remove(playerId);
        }
        DuelSession session = new DuelSession(invitation);
        this.activeSessions.put(session.getId(), session);
        for (UUID playerId : session.getAllPlayerUUIDs()) {
            this.playerSessions.put(playerId, session.getId());
        }
        if (this.server == null) {
            this.server = invitation.getInitiator().method_5682();
        }
        session.start(this.server);
    }

    public void cancelInvitation(String invitationId) {
        DuelInvitation invitation = this.pendingInvitations.remove(invitationId);
        if (invitation != null) {
            for (UUID playerId : invitation.getAllPlayerUUIDs()) {
                this.playerInvitations.remove(playerId);
            }
        }
    }

    public void endSession(DuelSession session) {
        this.activeSessions.remove(session.getId());
        for (UUID playerId : session.getAllPlayerUUIDs()) {
            this.playerSessions.remove(playerId);
        }
    }

    public boolean isPlayerBusy(UUID playerId) {
        return this.playerInvitations.containsKey(playerId) || this.playerSessions.containsKey(playerId);
    }

    public Optional<DuelSession> getPlayerSession(UUID playerId) {
        String sessionId = this.playerSessions.get(playerId);
        if (sessionId != null) {
            return Optional.ofNullable(this.activeSessions.get(sessionId));
        }
        return Optional.empty();
    }

    public void cancelAllDuels() {
        for (DuelInvitation invitation : new ArrayList<DuelInvitation>(this.pendingInvitations.values())) {
            this.cancelInvitation(invitation.getId());
        }
        for (DuelSession session : new ArrayList<DuelSession>(this.activeSessions.values())) {
            session.cancel();
            this.endSession(session);
        }
    }

    public void cleanupExpiredInvitations() {
        for (Map.Entry<String, DuelInvitation> entry : new HashMap<String, DuelInvitation>(this.pendingInvitations).entrySet()) {
            if (!entry.getValue().isExpired()) continue;
            this.broadcastToInvitation(entry.getValue(), "Duel invitation expired.");
            this.cancelInvitation(entry.getKey());
        }
    }

    private void broadcastToInvitation(DuelInvitation invitation, String message) {
        if (this.server == null) {
            return;
        }
        for (UUID playerId : invitation.getAllPlayerUUIDs()) {
            class_3222 player = this.server.method_3760().method_14602(playerId);
            if (player == null) continue;
            MessageUtil.sendInfo(player, message);
        }
    }

    public void sendInvitations(DuelInvitation invitation) {
        class_3222 initiator = invitation.getInitiator();
        if (invitation.getType() == DuelType.ONE_V_ONE) {
            UUID opponentId = invitation.getTeamPlasma().get(0);
            class_3222 opponent = this.server.method_3760().method_14602(opponentId);
            if (opponent != null) {
                MessageUtil.sendDuelInvitation(opponent, initiator, invitation.getType().getDisplayName(), invitation.getId());
            }
        } else {
            for (UUID playerId : invitation.getAllPlayerUUIDs()) {
                class_3222 player;
                if (playerId.equals(initiator.method_5667()) || (player = this.server.method_3760().method_14602(playerId)) == null) continue;
                List<String> rocketNames = invitation.getTeamRocket().stream().map(id -> this.server.method_3760().method_14602(id)).filter(Objects::nonNull).map(p -> p.method_5477().getString()).toList();
                List<String> plasmaNames = invitation.getTeamPlasma().stream().map(id -> this.server.method_3760().method_14602(id)).filter(Objects::nonNull).map(p -> p.method_5477().getString()).toList();
                MessageUtil.sendTeamDuelInvitation(player, initiator, rocketNames.size() > 1 ? rocketNames.get(1) : "", plasmaNames.size() > 0 ? plasmaNames.get(0) : "", plasmaNames.size() > 1 ? plasmaNames.get(1) : "", invitation.getId());
            }
        }
        MessageUtil.sendSuccess(initiator, "Duel invitation sent! Waiting for players...");
    }

    public Collection<DuelSession> getActiveSessions() {
        return Collections.unmodifiableCollection(this.activeSessions.values());
    }
}

