/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemonbattle.duel;

import com.cobblemonbattle.arena.Arena;
import com.cobblemonbattle.duel.BestOf;
import com.cobblemonbattle.duel.DuelType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_3222;

public class DuelInvitation {
    private final String id;
    private final DuelType type;
    private final BestOf bestOf;
    private final Arena arena;
    private final class_3222 initiator;
    private final List<UUID> teamRocket;
    private final List<UUID> teamPlasma;
    private final Set<UUID> acceptedPlayers;
    private final long createdAt;
    private static final long EXPIRY_TIME_MS = 60000L;

    public DuelInvitation(String id, DuelType type, BestOf bestOf, Arena arena, class_3222 initiator, List<UUID> teamRocket, List<UUID> teamPlasma) {
        this.id = id;
        this.type = type;
        this.bestOf = bestOf;
        this.arena = arena;
        this.initiator = initiator;
        this.teamRocket = new ArrayList<UUID>(teamRocket);
        this.teamPlasma = new ArrayList<UUID>(teamPlasma);
        this.acceptedPlayers = new HashSet<UUID>();
        this.createdAt = System.currentTimeMillis();
        this.acceptedPlayers.add(initiator.method_5667());
    }

    public String getId() {
        return this.id;
    }

    public DuelType getType() {
        return this.type;
    }

    public BestOf getBestOf() {
        return this.bestOf;
    }

    public Arena getArena() {
        return this.arena;
    }

    public class_3222 getInitiator() {
        return this.initiator;
    }

    public List<UUID> getTeamRocket() {
        return Collections.unmodifiableList(this.teamRocket);
    }

    public List<UUID> getTeamPlasma() {
        return Collections.unmodifiableList(this.teamPlasma);
    }

    public Set<UUID> getAllPlayerUUIDs() {
        HashSet<UUID> all = new HashSet<UUID>();
        all.addAll(this.teamRocket);
        all.addAll(this.teamPlasma);
        return all;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.createdAt > 60000L;
    }

    public boolean accept(UUID playerId) {
        if (this.getAllPlayerUUIDs().contains(playerId)) {
            this.acceptedPlayers.add(playerId);
            return true;
        }
        return false;
    }

    public boolean hasAccepted(UUID playerId) {
        return this.acceptedPlayers.contains(playerId);
    }

    public boolean allAccepted() {
        return this.acceptedPlayers.containsAll(this.getAllPlayerUUIDs());
    }

    public int getAcceptedCount() {
        return this.acceptedPlayers.size();
    }

    public int getTotalPlayers() {
        return this.getAllPlayerUUIDs().size();
    }

    public boolean isPlayerInvolved(UUID playerId) {
        return this.getAllPlayerUUIDs().contains(playerId);
    }

    public long getTimeRemaining() {
        long elapsed = System.currentTimeMillis() - this.createdAt;
        return Math.max(0L, 60000L - elapsed);
    }
}

