/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemonbattle.duel;

import com.cobblemonbattle.CobblemonBattle;
import com.cobblemonbattle.duel.DuelSession;
import com.cobblemonbattle.duel.DuelType;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_3222;

public class CobblemonBattleIntegration {
    public static void startBattle(DuelSession session, List<class_3222> teamRocket, List<class_3222> teamPlasma, DuelType type) {
        try {
            if (type == DuelType.ONE_V_ONE) {
                CobblemonBattleIntegration.start1v1Battle(session, teamRocket.get(0), teamPlasma.get(0));
            } else {
                CobblemonBattleIntegration.start2v2Battle(session, teamRocket, teamPlasma);
            }
        }
        catch (Exception e) {
            CobblemonBattle.LOGGER.error("Failed to start Cobblemon battle", (Throwable)e);
            session.cancel();
        }
    }

    private static void start1v1Battle(DuelSession session, class_3222 player1, class_3222 player2) {
        CobblemonBattleIntegration.executeChallenge(player1, player2);
        CobblemonBattle.LOGGER.info("Started 1v1 battle: {} vs {}", (Object)player1.method_5477().getString(), (Object)player2.method_5477().getString());
    }

    private static void start2v2Battle(DuelSession session, List<class_3222> teamRocket, List<class_3222> teamPlasma) {
        if (!teamRocket.isEmpty() && !teamPlasma.isEmpty()) {
            CobblemonBattleIntegration.executeChallenge(teamRocket.get(0), teamPlasma.get(0));
        }
        CobblemonBattle.LOGGER.info("Started 2v2 battle: Team Rocket vs Team Plasma");
    }

    private static void executeChallenge(class_3222 challenger, class_3222 target) {
        try {
            Class<?> clazz = Class.forName("com.cobblemon.mod.common.api.challenges.ChallengeManager");
        }
        catch (ClassNotFoundException e) {
            String command = String.format("pokemonchallenge %s", target.method_5477().getString());
            challenger.method_5682().method_3734().method_44252(challenger.method_5671(), command);
        }
    }

    public static void registerBattleEndListener(DuelSession session) {
    }

    public static boolean isInBattle(class_3222 player) {
        try {
            Class<?> registryClass = Class.forName("com.cobblemon.mod.common.battles.BattleRegistry");
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void forceEndBattle(UUID battleId) {
        if (battleId == null) {
            return;
        }
        try {
            CobblemonBattle.LOGGER.info("Force ending battle: {}", (Object)battleId);
        }
        catch (Exception e) {
            CobblemonBattle.LOGGER.error("Failed to force end battle", (Throwable)e);
        }
    }
}

