/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemonbattle.command;

import com.cobblemonbattle.CobblemonBattle;
import com.cobblemonbattle.duel.DuelInvitation;
import com.cobblemonbattle.duel.DuelManager;
import com.cobblemonbattle.duel.DuelSession;
import com.cobblemonbattle.gui.DuelGuiManager;
import com.cobblemonbattle.util.MessageUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class DuelCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"duel").executes(DuelCommand::openMenu)).then(class_2170.method_9247((String)"accept").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).executes(DuelCommand::acceptInvitation)))).then(class_2170.method_9247((String)"deny").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).executes(DuelCommand::denyInvitation)))).then(class_2170.method_9247((String)"cancel").executes(DuelCommand::cancelDuel))).then(class_2170.method_9247((String)"status").executes(DuelCommand::showStatus)));
    }

    private static int openMenu(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player"));
            return 0;
        }
        DuelManager duelManager = CobblemonBattle.getInstance().getDuelManager();
        if (duelManager.isPlayerBusy(player.method_5667())) {
            MessageUtil.sendError(player, "You are already in a duel or have a pending invitation!");
            MessageUtil.sendInfo(player, "Use /duel cancel to cancel, or /duel status to check status.");
            return 0;
        }
        DuelGuiManager.openDuelMenu(player);
        return 1;
    }

    private static int acceptInvitation(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player"));
            return 0;
        }
        String invitationId = StringArgumentType.getString(context, (String)"id");
        DuelManager duelManager = CobblemonBattle.getInstance().getDuelManager();
        if (duelManager.acceptInvitation(player, invitationId)) {
            return 1;
        }
        return 0;
    }

    private static int denyInvitation(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player"));
            return 0;
        }
        String invitationId = StringArgumentType.getString(context, (String)"id");
        DuelManager duelManager = CobblemonBattle.getInstance().getDuelManager();
        if (duelManager.denyInvitation(player, invitationId)) {
            return 1;
        }
        return 0;
    }

    private static int cancelDuel(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player"));
            return 0;
        }
        DuelManager duelManager = CobblemonBattle.getInstance().getDuelManager();
        Optional<DuelInvitation> invitation = duelManager.getPlayerInvitation(player.method_5667());
        if (invitation.isPresent()) {
            duelManager.cancelInvitation(invitation.get().getId());
            MessageUtil.sendSuccess(player, "Duel invitation cancelled.");
            return 1;
        }
        Optional<DuelSession> session = duelManager.getPlayerSession(player.method_5667());
        if (session.isPresent()) {
            session.get().cancel();
            duelManager.endSession(session.get());
            MessageUtil.sendSuccess(player, "Duel cancelled.");
            return 1;
        }
        MessageUtil.sendError(player, "You don't have any active duel or invitation to cancel.");
        return 0;
    }

    private static int showStatus(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player"));
            return 0;
        }
        DuelManager duelManager = CobblemonBattle.getInstance().getDuelManager();
        Optional<DuelInvitation> invitation = duelManager.getPlayerInvitation(player.method_5667());
        if (invitation.isPresent()) {
            DuelInvitation inv = invitation.get();
            MessageUtil.sendInfo(player, "=== Pending Duel Invitation ===");
            MessageUtil.sendInfo(player, "Type: " + inv.getType().getDisplayName());
            MessageUtil.sendInfo(player, "Format: " + inv.getBestOf().getDisplayName());
            MessageUtil.sendInfo(player, "Arena: " + inv.getArena().getName());
            MessageUtil.sendInfo(player, "Players ready: " + inv.getAcceptedCount() + "/" + inv.getTotalPlayers());
            MessageUtil.sendInfo(player, "Time remaining: " + inv.getTimeRemaining() / 1000L + "s");
            return 1;
        }
        Optional<DuelSession> session = duelManager.getPlayerSession(player.method_5667());
        if (session.isPresent()) {
            DuelSession s = session.get();
            MessageUtil.sendInfo(player, "=== Active Duel ===");
            MessageUtil.sendInfo(player, "Type: " + s.getType().getDisplayName());
            MessageUtil.sendInfo(player, "Format: " + s.getBestOf().getDisplayName());
            MessageUtil.sendInfo(player, "Arena: " + s.getArena().getName());
            MessageUtil.sendInfo(player, "Round: " + s.getCurrentRound() + "/" + s.getBestOf().getTotalRounds());
            MessageUtil.sendInfo(player, "Score: Team Rocket " + s.getTeamRocketWins() + " - " + s.getTeamPlasmaWins() + " Team Plasma");
            return 1;
        }
        MessageUtil.sendInfo(player, "You are not in any duel. Use /duel to start one!");
        return 1;
    }
}

