/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemonbattle.command;

import com.cobblemonbattle.CobblemonBattle;
import com.cobblemonbattle.arena.Arena;
import com.cobblemonbattle.arena.ArenaManager;
import com.cobblemonbattle.arena.ArenaSpawn;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class ArenaCommand {
    private static final List<String> SPAWN_TYPES_1V1 = Arrays.asList("spawn1", "spawn2");
    private static final List<String> SPAWN_TYPES_2V2 = Arrays.asList("rocket1", "rocket2", "plasma1", "plasma2");
    private static final SuggestionProvider<class_2168> ARENA_SUGGESTIONS = (context, builder) -> {
        ArenaManager manager = CobblemonBattle.getInstance().getArenaManager();
        for (Arena arena : manager.getArenas()) {
            builder.suggest(arena.getName());
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<class_2168> MODE_SUGGESTIONS = (context, builder) -> {
        builder.suggest("1v1");
        builder.suggest("2v2");
        return builder.buildFuture();
    };
    private static final SuggestionProvider<class_2168> SPAWN_SUGGESTIONS = (context, builder) -> {
        String mode = StringArgumentType.getString((CommandContext)context, (String)"mode");
        List<String> spawns = mode.equals("1v1") ? SPAWN_TYPES_1V1 : SPAWN_TYPES_2V2;
        for (String spawn : spawns) {
            builder.suggest(spawn);
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"arena").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ArenaCommand::createArena)))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(ARENA_SUGGESTIONS).executes(ArenaCommand::deleteArena)))).then(class_2170.method_9247((String)"setspawn").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(ARENA_SUGGESTIONS).then(class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests(MODE_SUGGESTIONS).then(class_2170.method_9244((String)"spawnId", (ArgumentType)StringArgumentType.word()).suggests(SPAWN_SUGGESTIONS).executes(ArenaCommand::setSpawn)))))).then(class_2170.method_9247((String)"list").executes(ArenaCommand::listArenas))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(ARENA_SUGGESTIONS).executes(ArenaCommand::arenaInfo))));
    }

    private static int createArena(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        ArenaManager manager = CobblemonBattle.getInstance().getArenaManager();
        if (manager.createArena(name)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"cobblemonbattle.arena.created", (Object[])new Object[]{name}).method_27692(class_124.field_1060), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"cobblemonbattle.arena.already_exists", (Object[])new Object[]{name}));
        return 0;
    }

    private static int deleteArena(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        ArenaManager manager = CobblemonBattle.getInstance().getArenaManager();
        if (manager.deleteArena(name)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"cobblemonbattle.arena.deleted", (Object[])new Object[]{name}).method_27692(class_124.field_1054), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"cobblemonbattle.arena.not_found", (Object[])new Object[]{name}));
        return 0;
    }

    private static int setSpawn(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player"));
            return 0;
        }
        String arenaName = StringArgumentType.getString(context, (String)"name");
        String mode = StringArgumentType.getString(context, (String)"mode");
        String spawnId = StringArgumentType.getString(context, (String)"spawnId");
        ArenaManager manager = CobblemonBattle.getInstance().getArenaManager();
        Arena arena = manager.getArena(arenaName).orElse(null);
        if (arena == null) {
            source.method_9213((class_2561)class_2561.method_43469((String)"cobblemonbattle.arena.not_found", (Object[])new Object[]{arenaName}));
            return 0;
        }
        ArenaSpawn spawn = ArenaSpawn.fromPlayer(player);
        if (mode.equals("1v1")) {
            if (!SPAWN_TYPES_1V1.contains(spawnId)) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Invalid 1v1 spawn ID. Use: spawn1 or spawn2"));
                return 0;
            }
            arena.setSpawn1v1(spawnId, spawn);
        } else if (mode.equals("2v2")) {
            if (!SPAWN_TYPES_2V2.contains(spawnId)) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Invalid 2v2 spawn ID. Use: rocket1, rocket2, plasma1, or plasma2"));
                return 0;
            }
            arena.setSpawn2v2(spawnId, spawn);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid mode. Use: 1v1 or 2v2"));
            return 0;
        }
        manager.save();
        source.method_9226(() -> class_2561.method_43469((String)"cobblemonbattle.arena.spawn_set", (Object[])new Object[]{spawnId, arenaName}).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int listArenas(CommandContext<class_2168> context) {
        ArenaManager manager = CobblemonBattle.getInstance().getArenaManager();
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43471((String)"cobblemonbattle.arena.list_header").method_27692(class_124.field_1065), false);
        if (manager.getArenas().isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"  No arenas created yet.").method_27692(class_124.field_1080), false);
        } else {
            for (Arena arena : manager.getArenas()) {
                String status1v1 = arena.get1v1Status();
                String status2v2 = arena.get2v2Status();
                class_124 color1v1 = arena.is1v1Ready() ? class_124.field_1060 : class_124.field_1061;
                class_124 color2v2 = arena.is2v2Ready() ? class_124.field_1060 : class_124.field_1061;
                source.method_9226(() -> class_2561.method_43470((String)("  - " + arena.getName() + " ")).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)("[1v1: " + status1v1 + "]")).method_27692(color1v1)).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)("[2v2: " + status2v2 + "]")).method_27692(color2v2)), false);
            }
        }
        return 1;
    }

    private static int arenaInfo(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        ArenaManager manager = CobblemonBattle.getInstance().getArenaManager();
        Arena arena = manager.getArena(name).orElse(null);
        if (arena == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"cobblemonbattle.arena.not_found", (Object[])new Object[]{name}));
            return 0;
        }
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)("=== Arena: " + arena.getName() + " ===")).method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)("Status: " + arena.getStatus().name())).method_27692(class_124.field_1068), false);
        source.method_9226(() -> class_2561.method_43470((String)"1v1 Spawns:").method_27692(class_124.field_1075), false);
        source.method_9226(() -> ArenaCommand.formatSpawnInfo("  spawn1", arena.getSpawn1v1("spawn1")), false);
        source.method_9226(() -> ArenaCommand.formatSpawnInfo("  spawn2", arena.getSpawn1v1("spawn2")), false);
        source.method_9226(() -> class_2561.method_43470((String)"2v2 Spawns (Team Rocket):").method_27692(class_124.field_1061), false);
        source.method_9226(() -> ArenaCommand.formatSpawnInfo("  rocket1", arena.getSpawn2v2("rocket1")), false);
        source.method_9226(() -> ArenaCommand.formatSpawnInfo("  rocket2", arena.getSpawn2v2("rocket2")), false);
        source.method_9226(() -> class_2561.method_43470((String)"2v2 Spawns (Team Plasma):").method_27692(class_124.field_1078), false);
        source.method_9226(() -> ArenaCommand.formatSpawnInfo("  plasma1", arena.getSpawn2v2("plasma1")), false);
        source.method_9226(() -> ArenaCommand.formatSpawnInfo("  plasma2", arena.getSpawn2v2("plasma2")), false);
        return 1;
    }

    private static class_2561 formatSpawnInfo(String label, ArenaSpawn spawn) {
        if (spawn == null) {
            return class_2561.method_43470((String)(label + ": ")).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)"Not set").method_27692(class_124.field_1061));
        }
        return class_2561.method_43470((String)(label + ": ")).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)String.format("%.1f, %.1f, %.1f", spawn.getX(), spawn.getY(), spawn.getZ())).method_27692(class_124.field_1060));
    }
}

