/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemonbattle.arena;

import com.cobblemonbattle.CobblemonBattle;
import com.cobblemonbattle.arena.Arena;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;

public class ArenaManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<String, Arena> arenas = new HashMap<String, Arena>();
    private Path configPath;

    public void load(MinecraftServer server) {
        this.configPath = server.method_3831().resolve("config").resolve("cobblemonbattle").resolve("arenas.json");
        try {
            String content;
            JsonObject json;
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            if (Files.exists(this.configPath, new LinkOption[0]) && (json = (JsonObject)GSON.fromJson(content = Files.readString(this.configPath), JsonObject.class)).has("arenas")) {
                JsonArray arenasArray = json.getAsJsonArray("arenas");
                for (JsonElement element : arenasArray) {
                    Arena arena = Arena.fromJson(element.getAsJsonObject());
                    this.arenas.put(arena.getName().toLowerCase(), arena);
                }
            }
        }
        catch (IOException e) {
            CobblemonBattle.LOGGER.error("Failed to load arenas", (Throwable)e);
        }
    }

    public void save() {
        if (this.configPath == null) {
            return;
        }
        try {
            JsonObject json = new JsonObject();
            JsonArray arenasArray = new JsonArray();
            for (Arena arena : this.arenas.values()) {
                arenasArray.add((JsonElement)arena.toJson());
            }
            json.add("arenas", (JsonElement)arenasArray);
            Files.writeString(this.configPath, (CharSequence)GSON.toJson((JsonElement)json), new OpenOption[0]);
        }
        catch (IOException e) {
            CobblemonBattle.LOGGER.error("Failed to save arenas", (Throwable)e);
        }
    }

    public boolean createArena(String name) {
        String key = name.toLowerCase();
        if (this.arenas.containsKey(key)) {
            return false;
        }
        this.arenas.put(key, new Arena(name));
        this.save();
        return true;
    }

    public boolean deleteArena(String name) {
        String key = name.toLowerCase();
        if (!this.arenas.containsKey(key)) {
            return false;
        }
        this.arenas.remove(key);
        this.save();
        return true;
    }

    public Optional<Arena> getArena(String name) {
        return Optional.ofNullable(this.arenas.get(name.toLowerCase()));
    }

    public Collection<Arena> getArenas() {
        return this.arenas.values();
    }

    public Collection<Arena> getAvailable1v1Arenas() {
        return this.arenas.values().stream().filter(Arena::is1v1Ready).filter(Arena::isAvailable).toList();
    }

    public Collection<Arena> getAvailable2v2Arenas() {
        return this.arenas.values().stream().filter(Arena::is2v2Ready).filter(Arena::isAvailable).toList();
    }

    public Collection<Arena> get1v1Arenas() {
        return this.arenas.values().stream().filter(Arena::is1v1Ready).toList();
    }

    public Collection<Arena> get2v2Arenas() {
        return this.arenas.values().stream().filter(Arena::is2v2Ready).toList();
    }
}

