/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemonbattle.arena;

import com.cobblemonbattle.arena.ArenaSpawn;
import com.cobblemonbattle.arena.ArenaStatus;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class Arena {
    private final String name;
    private final Map<String, ArenaSpawn> spawns1v1;
    private final Map<String, ArenaSpawn> spawns2v2;
    private ArenaStatus status;

    public Arena(String name) {
        this.name = name;
        this.spawns1v1 = new HashMap<String, ArenaSpawn>();
        this.spawns2v2 = new HashMap<String, ArenaSpawn>();
        this.status = ArenaStatus.AVAILABLE;
    }

    public static Arena fromJson(JsonObject json) {
        Arena arena = new Arena(json.get("name").getAsString());
        if (json.has("spawns1v1")) {
            JsonObject spawns1v1Json = json.getAsJsonObject("spawns1v1");
            for (String key : spawns1v1Json.keySet()) {
                arena.spawns1v1.put(key, ArenaSpawn.fromJson(spawns1v1Json.getAsJsonObject(key)));
            }
        }
        if (json.has("spawns2v2")) {
            JsonObject spawns2v2Json = json.getAsJsonObject("spawns2v2");
            for (String key : spawns2v2Json.keySet()) {
                arena.spawns2v2.put(key, ArenaSpawn.fromJson(spawns2v2Json.getAsJsonObject(key)));
            }
        }
        return arena;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        JsonObject spawns1v1Json = new JsonObject();
        for (Map.Entry<String, ArenaSpawn> entry : this.spawns1v1.entrySet()) {
            spawns1v1Json.add(entry.getKey(), (JsonElement)entry.getValue().toJson());
        }
        json.add("spawns1v1", (JsonElement)spawns1v1Json);
        JsonObject spawns2v2Json = new JsonObject();
        for (Map.Entry<String, ArenaSpawn> entry : this.spawns2v2.entrySet()) {
            spawns2v2Json.add(entry.getKey(), (JsonElement)entry.getValue().toJson());
        }
        json.add("spawns2v2", (JsonElement)spawns2v2Json);
        return json;
    }

    public String getName() {
        return this.name;
    }

    public ArenaStatus getStatus() {
        return this.status;
    }

    public void setStatus(ArenaStatus status) {
        this.status = status;
    }

    public void setSpawn1v1(String spawnId, ArenaSpawn spawn) {
        this.spawns1v1.put(spawnId, spawn);
    }

    public ArenaSpawn getSpawn1v1(String spawnId) {
        return this.spawns1v1.get(spawnId);
    }

    public ArenaSpawn getSpawn1v1_1() {
        return this.spawns1v1.get("spawn1");
    }

    public ArenaSpawn getSpawn1v1_2() {
        return this.spawns1v1.get("spawn2");
    }

    public boolean is1v1Ready() {
        return this.spawns1v1.containsKey("spawn1") && this.spawns1v1.containsKey("spawn2");
    }

    public void setSpawn2v2(String spawnId, ArenaSpawn spawn) {
        this.spawns2v2.put(spawnId, spawn);
    }

    public ArenaSpawn getSpawn2v2(String spawnId) {
        return this.spawns2v2.get(spawnId);
    }

    public ArenaSpawn getRocket1() {
        return this.spawns2v2.get("rocket1");
    }

    public ArenaSpawn getRocket2() {
        return this.spawns2v2.get("rocket2");
    }

    public ArenaSpawn getPlasma1() {
        return this.spawns2v2.get("plasma1");
    }

    public ArenaSpawn getPlasma2() {
        return this.spawns2v2.get("plasma2");
    }

    public boolean is2v2Ready() {
        return this.spawns2v2.containsKey("rocket1") && this.spawns2v2.containsKey("rocket2") && this.spawns2v2.containsKey("plasma1") && this.spawns2v2.containsKey("plasma2");
    }

    public boolean isAvailable() {
        return this.status == ArenaStatus.AVAILABLE;
    }

    public String get1v1Status() {
        if (this.is1v1Ready()) {
            return "OK";
        }
        int count = this.spawns1v1.size();
        return count + "/2";
    }

    public String get2v2Status() {
        if (this.is2v2Ready()) {
            return "OK";
        }
        int count = this.spawns2v2.size();
        return count + "/4";
    }
}

