/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemonbattle;

import com.cobblemonbattle.arena.ArenaManager;
import com.cobblemonbattle.command.ArenaCommand;
import com.cobblemonbattle.command.DuelCommand;
import com.cobblemonbattle.duel.DuelManager;
import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobblemonBattle
implements ModInitializer {
    public static final String MOD_ID = "cobblemonbattle";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cobblemonbattle");
    private static CobblemonBattle instance;
    private ArenaManager arenaManager;
    private DuelManager duelManager;

    public void onInitialize() {
        instance = this;
        LOGGER.info("CobblemonBattle initializing...");
        this.arenaManager = new ArenaManager();
        this.duelManager = new DuelManager();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            DuelCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ArenaCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.arenaManager.load(server);
            LOGGER.info("CobblemonBattle loaded {} arenas", (Object)this.arenaManager.getArenas().size());
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            this.arenaManager.save();
            this.duelManager.cancelAllDuels();
            LOGGER.info("CobblemonBattle saved and cleaned up");
        });
        LOGGER.info("CobblemonBattle initialized!");
    }

    public static CobblemonBattle getInstance() {
        return instance;
    }

    public ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    public DuelManager getDuelManager() {
        return this.duelManager;
    }
}

