/*
 * Decompiled with CFR 0.152.
 */
package com.safari.world;

import com.safari.config.SafariConfig;
import com.safari.state.SafariWorldState;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class SafariWorldManager {
    public static void findAndSetSafeSpot(class_3218 world) {
        SafariWorldState.get().centerX = 0;
        SafariWorldState.get().centerZ = 0;
        SafariWorldState.get().spawnInitialized = false;
        SafariWorldState.get();
        SafariWorldState.save();
        SafariWorldManager.updateBorder(world, 0, 0);
        SafariWorldManager.ensureSpawnPoint(world);
    }

    public static void ensureSpawnPoint(class_3218 world) {
        if (SafariConfig.get().forceCustomSpawn) {
            SafariWorldManager.updateBorder(world, (int)SafariConfig.get().customSpawnX, (int)SafariConfig.get().customSpawnZ);
            return;
        }
        int centerX = SafariWorldState.get().centerX;
        int centerZ = SafariWorldState.get().centerZ;
        world.method_14178().method_12121(centerX >> 4, centerZ >> 4, class_2806.field_12803, true);
        if (!SafariWorldState.get().spawnInitialized) {
            int surfaceY = world.method_8624(class_2902.class_2903.field_13203, centerX, centerZ);
            int spawnY = surfaceY + SafariConfig.get().safariSpawnOffsetY;
            if (spawnY <= world.method_31607() + 1) {
                spawnY = Math.max(SafariConfig.get().safariSpawnY, 64) + SafariConfig.get().safariSpawnOffsetY;
            }
            SafariWorldState.get().spawnX = centerX;
            SafariWorldState.get().spawnY = spawnY;
            SafariWorldState.get().spawnZ = centerZ;
            SafariWorldState.get().spawnInitialized = true;
            SafariWorldState.get();
            SafariWorldState.save();
        }
        SafariWorldManager.updateBorder(world, SafariWorldState.get().spawnX, SafariWorldState.get().spawnZ);
    }

    public static void ensureSafariNpcNear(class_3218 world, class_2338 basePos) {
    }

    private static void ensureSafariNpc(class_3218 world, class_2338 basePos) {
    }

    private static void updateBorder(class_3218 world, int x, int z) {
        world.method_8621().method_11978((double)x, (double)z);
        world.method_8621().method_11969((double)SafariConfig.get().dimensionSize);
    }

    public static boolean isSafeSpot(class_3218 world, class_2338 pos) {
        return SafariWorldManager.isValidBiome(world, pos);
    }

    private static boolean isValidBiome(class_3218 world, class_2338 pos) {
        class_6880 biomeEntry = world.method_23753(pos);
        class_2960 biomeId = world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)((class_1959)biomeEntry.comp_349()));
        if (biomeId == null) {
            return false;
        }
        List<String> allowed = SafariConfig.get().allowedBiomes;
        if (allowed == null || allowed.isEmpty()) {
            return true;
        }
        String idStr = biomeId.toString();
        for (String entry : allowed) {
            if (!idStr.equals(entry)) continue;
            return true;
        }
        return false;
    }
}

