/*
 * Decompiled with CFR 0.152.
 */
package com.safari.state;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Random;
import net.fabricmc.loader.api.FabricLoader;

public class SafariWorldState {
    private static SafariWorldState INSTANCE;
    private static final File STATE_FILE;
    public long currentDailySeed;
    public int centerX = 0;
    public int centerZ = 0;
    public int spawnX = 0;
    public int spawnY = 160;
    public int spawnZ = 0;
    public boolean spawnInitialized = false;
    public boolean guideNpcSpawned = false;

    public static SafariWorldState get() {
        if (INSTANCE == null) {
            SafariWorldState.load();
        }
        return INSTANCE;
    }

    public static void load() {
        if (!STATE_FILE.exists()) {
            INSTANCE = new SafariWorldState();
            INSTANCE.resetDailySeed();
            SafariWorldState.save();
            return;
        }
        try (FileReader reader = new FileReader(STATE_FILE);){
            INSTANCE = (SafariWorldState)new Gson().fromJson((Reader)reader, SafariWorldState.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            INSTANCE = new SafariWorldState();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(STATE_FILE);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void resetDailySeed() {
        this.currentDailySeed = new Random().nextLong();
        this.centerX = 0;
        this.centerZ = 0;
        this.spawnInitialized = false;
        this.guideNpcSpawned = false;
        SafariWorldState.save();
    }

    static {
        STATE_FILE = FabricLoader.getInstance().getConfigDir().resolve("safari-state.json").toFile();
    }
}

