/*
 * Decompiled with CFR 0.152.
 */
package com.safari.shop;

import com.safari.config.SafariConfig;
import com.safari.economy.SafariEconomy;
import com.safari.item.ModItems;
import com.safari.session.SafariSessionManager;
import com.safari.shop.ShopInventory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class SafariShopScreenHandler
extends class_1703 {
    private static final int SHOP_ROWS = 3;
    private static final int SHOP_COLUMNS = 9;
    private static final int SHOP_SIZE = 27;
    private final class_1657 player;
    private final ShopInventory inventory;
    private final Map<Integer, ShopItem> shopItems = new LinkedHashMap<Integer, ShopItem>();

    public SafariShopScreenHandler(int syncId, class_1661 playerInventory) {
        super(class_3917.field_17326, syncId);
        int col;
        this.player = playerInventory.field_7546;
        this.inventory = new ShopInventory(27);
        SafariConfig cfg = SafariConfig.get();
        this.addShopItem(this.inventory, 10, ModItems.SAFARI_BALL, cfg.ballsPackSmallSize);
        this.addShopItem(this.inventory, 11, ModItems.SAFARI_BALL, cfg.ballsPackMediumSize);
        this.addShopItem(this.inventory, 12, ModItems.SAFARI_BALL, cfg.ballsPackLargeSize);
        this.addShopItem(this.inventory, 14, ModItems.SAFARI_TICKET_5, 1);
        this.addShopItem(this.inventory, 15, ModItems.SAFARI_TICKET_15, 1);
        this.addShopItem(this.inventory, 16, ModItems.SAFARI_TICKET_30, 1);
        class_1799 leaveItem = new class_1799((class_1935)class_1802.field_8634);
        leaveItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Sortir du Parc Safari").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        ArrayList<class_5250> leaveLore = new ArrayList<class_5250>();
        leaveLore.add(class_2561.method_43470((String)"Cliquez pour quitter le Safari").method_27692(class_124.field_1080));
        leaveItem.method_57379(class_9334.field_49632, (Object)new class_9290(leaveLore));
        this.inventory.method_5447(22, leaveItem);
        this.updateBalanceDisplay();
        for (int i = 0; i < 27; ++i) {
            this.method_7621(new ShopSlot(this.inventory, i, 8 + i % 9 * 18, 18 + i / 9 * 18));
        }
        int inventoryY = 84;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)playerInventory, col + row * 9 + 9, 8 + col * 18, inventoryY + row * 18));
            }
        }
        int hotbarY = 142;
        for (col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)playerInventory, col, 8 + col * 18, hotbarY));
        }
    }

    private void addShopItem(ShopInventory inventory, int slot, class_1792 item, int count) {
        class_1799 stack = new class_1799((class_1935)item);
        stack.method_7939(count);
        int price = this.getPrice(new ShopItem(item, count));
        if (price > 0) {
            ArrayList<class_5250> lore = new ArrayList<class_5250>();
            lore.add(class_2561.method_43469((String)"message.safari.price", (Object[])new Object[]{price}).method_27692(class_124.field_1080));
            stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
        }
        inventory.method_5447(slot, stack);
        this.shopItems.put(slot, new ShopItem(item, count));
    }

    public void method_7593(int slotId, int button, class_1713 actionType, class_1657 player) {
        if (slotId >= 0 && slotId < 27) {
            if (slotId == 22 && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7346();
                SafariSessionManager.endSession(serverPlayer);
                return;
            }
            if (this.shopItems.containsKey(slotId)) {
                this.handlePurchase(this.shopItems.get(slotId));
                return;
            }
        }
        super.method_7593(slotId, button, actionType, player);
    }

    private void handlePurchase(ShopItem item) {
        class_1657 class_16572 = this.player;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        if (!SafariSessionManager.isInSession(serverPlayer)) {
            this.player.method_7353((class_2561)class_2561.method_43471((String)"message.safari.must_be_in_session_buy").method_27692(class_124.field_1061), false);
            return;
        }
        int price = this.getPrice(item);
        if (!SafariEconomy.deduct(serverPlayer, price)) {
            this.player.method_7353((class_2561)class_2561.method_43469((String)"message.safari.need_money_buy", (Object[])new Object[]{price}).method_27692(class_124.field_1061), false);
            return;
        }
        class_1799 stack = new class_1799((class_1935)item.item(), item.count());
        if (!this.player.method_31548().method_7394(stack)) {
            this.player.method_7328(stack, false);
        }
        this.updateShopPrices();
        this.updateBalanceDisplay();
    }

    private void updateShopPrices() {
        for (Map.Entry<Integer, ShopItem> entry : this.shopItems.entrySet()) {
            class_1799 stack = this.inventory.method_5438(entry.getKey()).method_7972();
            int price = this.getPrice(entry.getValue());
            if (price > 0) {
                ArrayList<class_5250> lore = new ArrayList<class_5250>();
                lore.add(class_2561.method_43469((String)"message.safari.price", (Object[])new Object[]{price}).method_27692(class_124.field_1080));
                stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
            }
            this.inventory.method_5447(entry.getKey(), stack);
        }
        this.method_7623();
    }

    private void updateBalanceDisplay() {
        class_1657 class_16572 = this.player;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        int balance = SafariEconomy.getBalance(serverPlayer);
        class_1799 head = new class_1799((class_1935)class_1802.field_8575);
        head.method_57379(class_9334.field_49631, (Object)class_2561.method_43469((String)"message.safari.balance", (Object[])new Object[]{balance}).method_27692(class_124.field_1060));
        class_9296 component = new class_9296(serverPlayer.method_7334());
        head.method_57379(class_9334.field_49617, (Object)component);
        this.inventory.method_5447(4, head);
        this.method_7623();
    }

    private int getPrice(ShopItem item) {
        if (item.item() == ModItems.SAFARI_BALL) {
            SafariConfig cfg = SafariConfig.get();
            if (item.count() == cfg.ballsPackSmallSize) {
                return cfg.ballsPackSmallPrice;
            }
            if (item.count() == cfg.ballsPackMediumSize) {
                return cfg.ballsPackMediumPrice;
            }
            if (item.count() == cfg.ballsPackLargeSize) {
                return cfg.ballsPackLargePrice;
            }
            return 0;
        }
        SafariConfig timeCfg = SafariConfig.get();
        if (item.item() == ModItems.SAFARI_TICKET_5) {
            return timeCfg.timeTicket5Price;
        }
        if (item.item() == ModItems.SAFARI_TICKET_15) {
            return timeCfg.timeTicket15Price;
        }
        if (item.item() == ModItems.SAFARI_TICKET_30) {
            return timeCfg.timeTicket30Price;
        }
        return 0;
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    private static final class ShopSlot
    extends class_1735 {
        private ShopSlot(ShopInventory inventory, int index, int x, int y) {
            super((class_1263)inventory, index, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }

        public boolean method_7674(class_1657 playerEntity) {
            return false;
        }
    }

    private static final class ShopItem {
        private final class_1792 item;
        private final int count;

        private ShopItem(class_1792 item, int count) {
            this.item = item;
            this.count = count;
        }

        private class_1792 item() {
            return this.item;
        }

        private int count() {
            return this.count;
        }
    }
}

