/*
 * Decompiled with CFR 0.152.
 */
package com.safari.session;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.safari.SafariMod;
import com.safari.block.SafariBlocks;
import com.safari.config.SafariConfig;
import com.safari.economy.SafariEconomy;
import com.safari.item.ModItems;
import com.safari.session.SafariInventoryHandler;
import com.safari.session.SafariSession;
import com.safari.state.SafariWorldState;
import com.safari.world.SafariDimension;
import com.safari.world.SafariWorldManager;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class SafariSessionManager {
    private static final Map<UUID, SafariSession> activeSessions = new ConcurrentHashMap<UUID, SafariSession>();
    private static final Map<UUID, ResumeSession> pausedSessions = new ConcurrentHashMap<UUID, ResumeSession>();
    private static final Map<UUID, LastKnownPos> lastKnownPositions = new ConcurrentHashMap<UUID, LastKnownPos>();
    private static MinecraftServer server;
    private static final Map<UUID, Long> enterDenyCooldown;
    private static final Gson GSON;
    private static int ticksSinceLastPersist;

    public static void setServer(MinecraftServer srv) {
        server = srv;
        SafariSessionManager.loadPausedSessions();
    }

    public static void persistActiveSessionsForShutdown() {
        activeSessions.forEach((uuid, session) -> {
            if (pausedSessions.containsKey(uuid)) {
                return;
            }
            class_3222 player = session.getPlayer();
            ResumeSession resume = new ResumeSession(session.getTicksRemaining(), session.getReturnDimension(), session.getReturnPos(), session.getReturnYaw(), session.getReturnPitch(), player.method_24515(), player.method_36454(), player.method_36455());
            pausedSessions.put((UUID)uuid, resume);
        });
        SafariSessionManager.savePausedSessions();
    }

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> SafariSessionManager.tick());
    }

    public static boolean tryStartSession(class_3222 player, boolean chargeEntry) {
        if (SafariSessionManager.isInSession(player)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.safari.already_in_session").method_27692(class_124.field_1061), false);
            return false;
        }
        if (player.method_31548().method_7376() == -1) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.safari.inventory_full").method_27692(class_124.field_1061), false);
            return false;
        }
        if (chargeEntry) {
            int price = SafariConfig.get().entrancePrice;
            if (price > 0 && !SafariEconomy.hasEnough(player, price)) {
                player.method_7353((class_2561)class_2561.method_43469((String)"message.safari.need_money_entry", (Object[])new Object[]{price}).method_27692(class_124.field_1061), false);
                return false;
            }
            if (price > 0) {
                boolean paid = SafariEconomy.deduct(player, price);
                SafariMod.LOGGER.info("Safari entry payment: player={}, price={}, success={}", new Object[]{player.method_5477().getString(), price, paid});
                if (!paid) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"message.safari.need_money_entry", (Object[])new Object[]{price}).method_27692(class_124.field_1061), false);
                    return false;
                }
                player.method_7353((class_2561)class_2561.method_43469((String)"message.safari.paid_entry", (Object[])new Object[]{price}).method_27692(class_124.field_1060), false);
            }
        }
        SafariSessionManager.startSession(player);
        return true;
    }

    public static void startSession(class_3222 player) {
        double z;
        double y;
        double x;
        class_3218 safariWorld = player.method_5682().method_3847(SafariDimension.SAFARI_DIM_KEY);
        if (safariWorld == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.safari.dimension_not_loaded").method_27692(class_124.field_1061), false);
            return;
        }
        if (!SafariWorldManager.isSafeSpot(safariWorld, new class_2338(SafariWorldState.get().centerX, 64, SafariWorldState.get().centerZ))) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.safari.finding_safe_spot").method_27692(class_124.field_1054), true);
            SafariWorldManager.findAndSetSafeSpot(safariWorld);
        }
        SafariWorldManager.ensureSpawnPoint(safariWorld);
        if (player.method_31548().method_7376() == -1) {
            long last;
            long now = System.currentTimeMillis();
            if (now - (last = enterDenyCooldown.getOrDefault(player.method_5667(), 0L).longValue()) > 3000L) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.safari.need_empty_slot").method_27692(class_124.field_1061), false);
                enterDenyCooldown.put(player.method_5667(), now);
            }
            return;
        }
        long duration = (long)SafariConfig.get().sessionTimeMinutes * 60L * 20L;
        class_2338 safeReturnPos = SafariSessionManager.findSafeExitPos((class_3218)player.method_37908(), SafariSessionManager.getSafeReturnPos(player));
        SafariSession session = new SafariSession(player, duration, (class_5321<class_1937>)player.method_37908().method_27983(), safeReturnPos, player.method_36454(), player.method_36455());
        activeSessions.put(player.method_5667(), session);
        if (SafariConfig.get().forceCustomSpawn) {
            x = SafariConfig.get().customSpawnX;
            y = SafariConfig.get().customSpawnY;
            z = SafariConfig.get().customSpawnZ;
        } else {
            x = (double)SafariWorldState.get().spawnX + 0.5;
            z = (double)SafariWorldState.get().spawnZ + 0.5;
            y = SafariWorldState.get().spawnY;
            if (y <= (double)safariWorld.method_31607()) {
                y = SafariConfig.get().safariSpawnY + SafariConfig.get().safariSpawnOffsetY;
            }
        }
        player.method_14251(safariWorld, x, y, z, 0.0f, 0.0f);
        int fadeInTicks = Math.max(0, SafariConfig.get().entryTitleFadeInTicks);
        int stayTicks = Math.max(0, SafariConfig.get().entryTitleStayTicks);
        int fadeOutTicks = Math.max(0, SafariConfig.get().entryTitleFadeOutTicks);
        player.field_13987.method_14364((class_2596)new class_5905(fadeInTicks, stayTicks, fadeOutTicks));
        String entryTitle = SafariConfig.get().entryTitle;
        String entrySubtitle = SafariConfig.get().entrySubtitle;
        if (entryTitle != null && !entryTitle.isBlank()) {
            player.field_13987.method_14364((class_2596)new class_5904((class_2561)class_2561.method_43470((String)entryTitle)));
        }
        if (entrySubtitle != null && !entrySubtitle.isBlank()) {
            player.field_13987.method_14364((class_2596)new class_5903((class_2561)class_2561.method_43470((String)entrySubtitle)));
        }
        player.method_6092(new class_1293(class_1294.field_5907, 200, 255, false, false));
        player.method_6092(new class_1293(class_1294.field_5906, 200, 1, false, false));
        int initialBalls = SafariConfig.get().initialSafariBalls;
        if (initialBalls > 0) {
            SafariInventoryHandler.giveSafariKit(player, initialBalls);
        }
        class_1799 ticket = new class_1799((class_1935)ModItems.SAFARI_PARK_TICKET);
        if (!player.method_31548().method_7394(ticket)) {
            player.method_7328(ticket, false);
        }
        player.method_7353((class_2561)class_2561.method_43469((String)"message.safari.welcome", (Object[])new Object[]{SafariConfig.get().sessionTimeMinutes}).method_27692(class_124.field_1077), false);
        SafariMod.LOGGER.info("Safari enter: {} -> {},{},{}, duration={}m, balls={}", new Object[]{player.method_5477().getString(), x, y, z, SafariConfig.get().sessionTimeMinutes, initialBalls});
    }

    public static void endSession(class_3222 player) {
        SafariSession session = activeSessions.remove(player.method_5667());
        if (session != null) {
            class_3218 returnWorld = player.method_5682().method_3847(session.getReturnDimension());
            if (returnWorld != null) {
                class_2338 safePos = SafariSessionManager.findSafeExitPos(returnWorld, session.getReturnPos());
                player.method_14251(returnWorld, (double)safePos.method_10263(), (double)safePos.method_10264(), (double)safePos.method_10260(), session.getReturnYaw(), session.getReturnPitch());
                player.method_51850(80);
            } else {
                class_3218 overworld = player.method_5682().method_3847(class_1937.field_25179);
                player.method_14251(overworld, (double)overworld.method_43126().method_10263(), (double)overworld.method_43126().method_10264(), (double)overworld.method_43126().method_10260(), 0.0f, 0.0f);
            }
            if (!SafariConfig.get().carryOverSafariBalls) {
                SafariInventoryHandler.removeSafariBalls(player);
            }
            SafariInventoryHandler.removeSafariTickets(player);
            player.method_7353((class_2561)class_2561.method_43471((String)"message.safari.session_ended").method_27692(class_124.field_1061), false);
            SafariMod.LOGGER.info("Safari exit: {} -> {} {} {}", new Object[]{player.method_5477().getString(), session.getReturnDimension().method_29177(), session.getReturnPos().method_10263(), session.getReturnPos().method_10264()});
        }
    }

    public static void endSessionOnDeath(class_3222 player) {
        activeSessions.remove(player.method_5667());
        pausedSessions.remove(player.method_5667());
    }

    public static void pauseSession(class_3222 player) {
        SafariSession session = activeSessions.remove(player.method_5667());
        if (session == null) {
            return;
        }
        if (!player.method_37908().method_27983().equals(SafariDimension.SAFARI_DIM_KEY)) {
            SafariSessionManager.endSession(player);
            return;
        }
        ResumeSession resume = new ResumeSession(session.getTicksRemaining(), session.getReturnDimension(), session.getReturnPos(), session.getReturnYaw(), session.getReturnPitch(), player.method_24515(), player.method_36454(), player.method_36455());
        pausedSessions.put(player.method_5667(), resume);
        SafariSessionManager.savePausedSessions();
    }

    public static void resumeSession(class_3222 player) {
        ResumeSession resume = pausedSessions.remove(player.method_5667());
        if (resume == null) {
            return;
        }
        class_3218 safariWorld = player.method_5682().method_3847(SafariDimension.SAFARI_DIM_KEY);
        if (safariWorld == null) {
            return;
        }
        SafariSession session = new SafariSession(player, resume.ticksRemaining(), resume.returnDimension(), resume.returnPos(), resume.returnYaw(), resume.returnPitch());
        activeSessions.put(player.method_5667(), session);
        player.method_14251(safariWorld, (double)resume.safariPos().method_10263() + 0.5, (double)resume.safariPos().method_10264(), (double)resume.safariPos().method_10260() + 0.5, resume.safariYaw(), resume.safariPitch());
        SafariSessionManager.savePausedSessions();
    }

    private static void tick() {
        class_3218 safariWorld;
        if (++ticksSinceLastPersist >= 1200 && !activeSessions.isEmpty()) {
            ticksSinceLastPersist = 0;
            SafariSessionManager.persistSessionsSnapshot();
        }
        if (server != null) {
            class_3218 overworld = server.method_3847(class_1937.field_25179);
            class_3218 safariWorld2 = server.method_3847(SafariDimension.SAFARI_DIM_KEY);
            if (overworld != null && safariWorld2 != null) {
                safariWorld2.method_29199(overworld.method_8532());
            }
            for (class_3222 player : new ArrayList(server.method_3760().method_14571())) {
                if (player.method_37908().method_27983().equals(SafariDimension.SAFARI_DIM_KEY)) continue;
                lastKnownPositions.put(player.method_5667(), new LastKnownPos((class_5321<class_1937>)player.method_37908().method_27983(), player.method_24515(), player.method_36454(), player.method_36455()));
            }
        }
        activeSessions.values().forEach(session -> {
            session.tick();
            if (!session.getPlayer().method_37908().method_27983().equals(SafariDimension.SAFARI_DIM_KEY)) {
                SafariSessionManager.endSession(session.getPlayer());
                return;
            }
            if (session.getTicksRemaining() % 20L == 0L) {
                long seconds = session.getTicksRemaining() / 20L;
                long mins = seconds / 60L;
                long secs = seconds % 60L;
                class_5250 timeText = class_2561.method_43469((String)"message.safari.time_remaining", (Object[])new Object[]{mins, secs});
                timeText = timeText.method_27692(mins < 5L ? class_124.field_1061 : class_124.field_1054);
                session.getPlayer().method_7353((class_2561)timeText, true);
                if (seconds > 0L && seconds <= 10L) {
                    session.getPlayer().method_5783((class_3414)class_3417.field_15204.comp_349(), 0.8f, 1.4f);
                }
            }
            if (session.getPlayer().method_14239()) {
                // empty if block
            }
            if (session.isExpired()) {
                SafariSessionManager.endSession(session.getPlayer());
            }
        });
        if (server != null && (safariWorld = server.method_3847(SafariDimension.SAFARI_DIM_KEY)) != null) {
            for (class_3222 player : new ArrayList(safariWorld.method_18456())) {
                float targetPitch;
                float targetYaw;
                double targetZ;
                double targetY;
                double targetX;
                class_3218 targetWorld;
                UUID uuid = player.method_5667();
                if (activeSessions.containsKey(uuid) || pausedSessions.containsKey(uuid) || player.method_5687(2)) continue;
                LastKnownPos lastKnown = lastKnownPositions.get(uuid);
                if (lastKnown != null) {
                    targetWorld = server.method_3847(lastKnown.dimension());
                    if (targetWorld == null) {
                        targetWorld = server.method_3847(class_1937.field_25179);
                    }
                    class_2338 safePos = SafariSessionManager.findSafeExitPos(targetWorld, lastKnown.pos());
                    targetX = (double)safePos.method_10263() + 0.5;
                    targetY = safePos.method_10264();
                    targetZ = (double)safePos.method_10260() + 0.5;
                    targetYaw = lastKnown.yaw();
                    targetPitch = lastKnown.pitch();
                } else {
                    targetWorld = server.method_3847(class_1937.field_25179);
                    class_2338 spawnPos = targetWorld.method_43126();
                    targetX = (double)spawnPos.method_10263() + 0.5;
                    targetY = spawnPos.method_10264();
                    targetZ = (double)spawnPos.method_10260() + 0.5;
                    targetYaw = 0.0f;
                    targetPitch = 0.0f;
                }
                if (targetWorld == null) continue;
                player.method_14251(targetWorld, targetX, targetY, targetZ, targetYaw, targetPitch);
                player.method_7353((class_2561)class_2561.method_43471((String)"message.safari.cant_teleport").method_27692(class_124.field_1061), false);
            }
        }
    }

    public static boolean isInSession(class_3222 player) {
        return activeSessions.containsKey(player.method_5667());
    }

    public static SafariSession getSession(class_3222 player) {
        return activeSessions.get(player.method_5667());
    }

    private static File getSessionsFile() {
        if (server == null) {
            return null;
        }
        return server.method_27050(class_5218.field_24188).resolve("safari-sessions.json").toFile();
    }

    private static void loadPausedSessions() {
        File file = SafariSessionManager.getSessionsFile();
        if (file == null || !file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file);){
            PersistedSessions persisted = (PersistedSessions)GSON.fromJson((Reader)reader, PersistedSessions.class);
            if (persisted == null || persisted.sessions == null) {
                return;
            }
            pausedSessions.clear();
            for (Map.Entry<String, PersistedSession> entry : persisted.sessions.entrySet()) {
                UUID uuid = UUID.fromString(entry.getKey());
                PersistedSession data = entry.getValue();
                class_5321 returnDimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)data.returnDimension()));
                class_2338 returnPos = new class_2338(data.returnX(), data.returnY(), data.returnZ());
                class_2338 safariPos = new class_2338(data.safariX(), data.safariY(), data.safariZ());
                pausedSessions.put(uuid, new ResumeSession(data.ticksRemaining(), (class_5321<class_1937>)returnDimension, returnPos, data.returnYaw(), data.returnPitch(), safariPos, data.safariYaw(), data.safariPitch()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void savePausedSessions() {
        SafariSessionManager.saveSessionsToFile(pausedSessions);
    }

    private static void saveSessionsToFile(Map<UUID, ResumeSession> sessions) {
        File file = SafariSessionManager.getSessionsFile();
        if (file == null) {
            return;
        }
        PersistedSessions persisted = new PersistedSessions();
        persisted.sessions = new HashMap<String, PersistedSession>();
        for (Map.Entry<UUID, ResumeSession> entry : sessions.entrySet()) {
            UUID uuid = entry.getKey();
            ResumeSession data = entry.getValue();
            PersistedSession session = new PersistedSession(data.ticksRemaining(), data.returnDimension().method_29177().toString(), data.returnPos().method_10263(), data.returnPos().method_10264(), data.returnPos().method_10260(), data.returnYaw(), data.returnPitch(), data.safariPos().method_10263(), data.safariPos().method_10264(), data.safariPos().method_10260(), data.safariYaw(), data.safariPitch());
            persisted.sessions.put(uuid.toString(), session);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)persisted, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void persistSessionsSnapshot() {
        HashMap<UUID, ResumeSession> snapshot = new HashMap<UUID, ResumeSession>(pausedSessions);
        activeSessions.forEach((uuid, session) -> {
            if (!snapshot.containsKey(uuid)) {
                class_3222 player = session.getPlayer();
                snapshot.put((UUID)uuid, new ResumeSession(session.getTicksRemaining(), session.getReturnDimension(), session.getReturnPos(), session.getReturnYaw(), session.getReturnPitch(), player.method_24515(), player.method_36454(), player.method_36455()));
            }
        });
        SafariSessionManager.saveSessionsToFile(snapshot);
    }

    private static class_2338 getSafeReturnPos(class_3222 player) {
        class_2338 pos = player.method_24515();
        if (SafariSessionManager.isPortalBlock(player.method_37908(), pos)) {
            class_2350 dir = player.method_5735().method_10153();
            class_2338 candidate = pos.method_10093(dir);
            if (player.method_37908().method_8320(candidate).method_26215() && !SafariSessionManager.isPortalBlock(player.method_37908(), candidate)) {
                return candidate;
            }
        }
        return pos;
    }

    private static class_2338 findSafeExitPos(class_3218 world, class_2338 pos) {
        if (!SafariSessionManager.isPortalBlock((class_1937)world, pos) && !SafariSessionManager.isPortalNearby(world, pos)) {
            return pos;
        }
        for (int dy = 0; dy <= 1; ++dy) {
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    class_2338 candidate = pos.method_10069(dx, dy, dz);
                    if (SafariSessionManager.isPortalBlock((class_1937)world, candidate) || SafariSessionManager.isPortalNearby(world, candidate) || !world.method_8320(candidate).method_26215() || !world.method_8320(candidate.method_10084()).method_26215()) continue;
                    return candidate;
                }
            }
        }
        return pos;
    }

    private static boolean isPortalNearby(class_3218 world, class_2338 pos) {
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (!SafariSessionManager.isPortalBlock((class_1937)world, pos.method_10069(dx, dy, dz))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isPortalBlock(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_27852(SafariBlocks.SAFARI_PORTAL) || state.method_27852(SafariBlocks.SAFARI_PORTAL_FRAME);
    }

    static {
        enterDenyCooldown = new ConcurrentHashMap<UUID, Long>();
        GSON = new GsonBuilder().setPrettyPrinting().create();
        ticksSinceLastPersist = 0;
    }

    private record ResumeSession(long ticksRemaining, class_5321<class_1937> returnDimension, class_2338 returnPos, float returnYaw, float returnPitch, class_2338 safariPos, float safariYaw, float safariPitch) {
    }

    private record LastKnownPos(class_5321<class_1937> dimension, class_2338 pos, float yaw, float pitch) {
    }

    private static final class PersistedSessions {
        private Map<String, PersistedSession> sessions = new HashMap<String, PersistedSession>();

        private PersistedSessions() {
        }
    }

    private record PersistedSession(long ticksRemaining, String returnDimension, int returnX, int returnY, int returnZ, float returnYaw, float returnPitch, int safariX, int safariY, int safariZ, float safariYaw, float safariPitch) {
    }
}

