/*
 * Decompiled with CFR 0.152.
 */
package com.safari.network;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public final class SafariHandshake {
    public static final class_8710.class_9154<VersionRequestPayload> VERSION_REQUEST_ID = new class_8710.class_9154(class_2960.method_60655((String)"safari", (String)"version_request"));
    public static final class_8710.class_9154<VersionResponsePayload> VERSION_RESPONSE_ID = new class_8710.class_9154(class_2960.method_60655((String)"safari", (String)"version_response"));
    private static final int TIMEOUT_TICKS = 600;
    private static final int MAX_VERSION_LENGTH = 64;
    private static final class_8605.class_8606 HANDSHAKE_TASK_KEY = new class_8605.class_8606(class_2960.method_60655((String)"safari", (String)"version_handshake").toString());
    private static final Map<class_8610, Integer> pending = new ConcurrentHashMap<class_8610, Integer>();

    private SafariHandshake() {
    }

    public static void initServer() {
        PayloadTypeRegistry.configurationS2C().register(VERSION_REQUEST_ID, VersionRequestPayload.CODEC);
        PayloadTypeRegistry.configurationC2S().register(VERSION_RESPONSE_ID, VersionResponsePayload.CODEC);
        ServerConfigurationNetworking.registerGlobalReceiver(VERSION_RESPONSE_ID, (payload, context) -> context.server().execute(() -> SafariHandshake.handleVersionResponse(context.networkHandler(), payload.version())));
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            String serverVersion = SafariHandshake.getModVersion();
            if (!ServerConfigurationNetworking.canSend((class_8610)handler, VERSION_REQUEST_ID)) {
                handler.method_52396((class_2561)class_2561.method_43469((String)"message.safari.handshake_missing", (Object[])new Object[]{serverVersion}));
                return;
            }
            pending.put(handler, server.method_3780());
            handler.addTask((class_8605)new VersionHandshakeTask(serverVersion));
        });
        ServerConfigurationConnectionEvents.DISCONNECT.register((handler, server) -> pending.remove(handler));
        ServerTickEvents.END_SERVER_TICK.register(SafariHandshake::tickServer);
    }

    private static void handleVersionResponse(class_8610 handler, String clientVersion) {
        String serverVersion = SafariHandshake.getModVersion();
        pending.remove(handler);
        if (clientVersion == null || clientVersion.isBlank()) {
            handler.method_52396((class_2561)class_2561.method_43469((String)"message.safari.handshake_missing", (Object[])new Object[]{serverVersion}));
            return;
        }
        if (!serverVersion.equals(clientVersion)) {
            handler.method_52396((class_2561)class_2561.method_43469((String)"message.safari.handshake_mismatch", (Object[])new Object[]{serverVersion, clientVersion}));
            return;
        }
        handler.completeTask(HANDSHAKE_TASK_KEY);
    }

    private static void tickServer(MinecraftServer server) {
        if (pending.isEmpty()) {
            return;
        }
        int tick = server.method_3780();
        for (Map.Entry<class_8610, Integer> entry : pending.entrySet()) {
            if (tick - entry.getValue() < 600) continue;
            entry.getKey().method_52396((class_2561)class_2561.method_43469((String)"message.safari.handshake_timeout", (Object[])new Object[]{SafariHandshake.getModVersion()}));
            pending.remove(entry.getKey());
        }
    }

    private static String getModVersion() {
        return FabricLoader.getInstance().getModContainer("safari").map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
    }

    public record VersionRequestPayload(String serverVersion) implements class_8710
    {
        public static final class_9139<class_2540, VersionRequestPayload> CODEC = class_9139.method_56434((class_9139)class_9135.method_56364((int)64), VersionRequestPayload::serverVersion, VersionRequestPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return VERSION_REQUEST_ID;
        }
    }

    public record VersionResponsePayload(String version) implements class_8710
    {
        public static final class_9139<class_2540, VersionResponsePayload> CODEC = class_9139.method_56434((class_9139)class_9135.method_56364((int)64), VersionResponsePayload::version, VersionResponsePayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return VERSION_RESPONSE_ID;
        }
    }

    private record VersionHandshakeTask(String serverVersion) implements class_8605
    {
        public void method_52376(Consumer<class_2596<?>> sender) {
            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_8710)new VersionRequestPayload(this.serverVersion)));
        }

        public class_8605.class_8606 method_52375() {
            return HANDSHAKE_TASK_KEY;
        }
    }
}

