/*
 * Decompiled with CFR 0.152.
 */
package com.safari.logic;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class SafariSpawnRarity {
    private static final String[] POOL_FILES = new String[]{"common.json", "ucommon.json", "rare.json", "ultra_rare.json", "cafe.json", "enhanced_celestials.json"};
    private static final Map<String, String> BUCKET_BY_POKEMON = new HashMap<String, String>();
    private static final Map<String, Integer> BUCKET_RANK = Map.of("common", 0, "uncommon", 1, "rare", 2, "ultra-rare", 3);

    private SafariSpawnRarity() {
    }

    public static String getBucket(PokemonEntity entity) {
        String bucket;
        String name = entity.getPokemon().getSpecies().getName().toString().toLowerCase(Locale.ROOT);
        int colon = name.indexOf(58);
        if (colon >= 0) {
            name = name.substring(colon + 1);
        }
        if ((bucket = BUCKET_BY_POKEMON.get(name)) != null) {
            return bucket;
        }
        int space = name.indexOf(32);
        if (space > 0) {
            bucket = BUCKET_BY_POKEMON.get(name.substring(0, space));
        }
        return bucket;
    }

    private static void loadPools() {
        ClassLoader loader = SafariSpawnRarity.class.getClassLoader();
        Gson gson = new Gson();
        for (String file : POOL_FILES) {
            String path = "data/cobblemon/spawn_pool_world/safari/" + file;
            try (InputStreamReader reader = new InputStreamReader(loader.getResourceAsStream(path));){
                JsonObject root;
                JsonArray spawns;
                if (reader == null || (spawns = (root = JsonParser.parseReader((Reader)reader).getAsJsonObject()).getAsJsonArray("spawns")) == null) continue;
                for (int i = 0; i < spawns.size(); ++i) {
                    JsonObject spawn = spawns.get(i).getAsJsonObject();
                    if (!spawn.has("pokemon") || !spawn.has("bucket")) continue;
                    String pokemon = spawn.get("pokemon").getAsString().toLowerCase(Locale.ROOT);
                    String bucket = spawn.get("bucket").getAsString().toLowerCase(Locale.ROOT);
                    SafariSpawnRarity.register(pokemon, bucket);
                    int space = pokemon.indexOf(32);
                    if (space <= 0) continue;
                    SafariSpawnRarity.register(pokemon.substring(0, space), bucket);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void register(String pokemon, String bucket) {
        if (pokemon.isEmpty()) {
            return;
        }
        String existing = BUCKET_BY_POKEMON.get(pokemon);
        if (existing == null) {
            BUCKET_BY_POKEMON.put(pokemon, bucket);
            return;
        }
        int existingRank = BUCKET_RANK.getOrDefault(existing, 0);
        int nextRank = BUCKET_RANK.getOrDefault(bucket, 0);
        if (nextRank > existingRank) {
            BUCKET_BY_POKEMON.put(pokemon, bucket);
        }
    }

    static {
        SafariSpawnRarity.loadPools();
    }
}

