/*
 * Decompiled with CFR 0.152.
 */
package com.safari.events;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.safari.block.SafariBlocks;
import com.safari.config.SafariConfig;
import com.safari.item.ModItems;
import com.safari.session.SafariSessionManager;
import com.safari.world.SafariDimension;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1787;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2423;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.class_7264;
import net.minecraft.class_7923;

public class SafariEvents {
    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                PokemonBattle battle;
                if (!SafariEvents.isInSafari((class_1657)player) || (battle = BattleRegistry.getBattleByParticipatingPlayer((class_3222)player)) == null || battle.getEnded()) continue;
                battle.end();
            }
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (!world.method_27983().equals(SafariDimension.SAFARI_DIM_KEY)) {
                return;
            }
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                class_1799 stack = itemEntity.method_6983();
                class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
                if ("cobblemon".equals(itemId.method_12836()) && itemId.method_12832().equals("safari_ball")) {
                    itemEntity.method_6979(new class_1799((class_1935)ModItems.SAFARI_BALL, stack.method_7947()));
                }
                return;
            }
            if (entity.method_31747()) {
                return;
            }
            if (world.method_8503() != null) {
                world.method_8503().execute(() -> {
                    class_2960 id = class_7923.field_41177.method_10221((Object)entity.method_5864());
                    if (id.method_12836().equals("cobblemon") && entity instanceof PokemonEntity) {
                        PokemonEntity pokemonEntity = (PokemonEntity)entity;
                        if (!pokemonEntity.method_5752().contains("safari_level_set")) {
                            int min = Math.max(1, SafariConfig.get().safariMinLevel);
                            int max = Math.max(min, SafariConfig.get().safariMaxLevel);
                            int level = min + world.field_9229.method_43048(max - min + 1);
                            pokemonEntity.getPokemon().setLevel(level);
                            pokemonEntity.method_5780("safari_level_set");
                        }
                        if (!pokemonEntity.method_5752().contains("safari_shiny_checked")) {
                            SafariEvents.applySafariShinyRate(pokemonEntity, world.field_9229);
                            pokemonEntity.method_5780("safari_shiny_checked");
                        }
                    }
                });
            }
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            if (SafariEvents.isInSafari(player) && !player.method_7337()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.safari.no_break_blocks").method_27692(class_124.field_1061), true);
                return false;
            }
            return true;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2338 pos = hitResult.method_17777();
            if (world.field_9236) {
                return class_1269.field_5811;
            }
            if (!world.method_27983().equals(SafariDimension.SAFARI_DIM_KEY) && player.method_5998(hand).method_31574(class_1802.field_8884) && world.method_8320(pos).method_27852(SafariBlocks.SAFARI_PORTAL_FRAME) && SafariEvents.tryLightPortal(world, pos)) {
                player.method_5998(hand).method_7970(1, (class_1309)player, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
                return class_1269.field_5812;
            }
            if (SafariEvents.isInSafari(player) && !player.method_7337()) {
                class_1799 stack = player.method_5998(hand);
                if (stack != null && !stack.method_7960() && (stack.method_31574(ModItems.SAFARI_NPC_SPAWN_EGG) || stack.method_31574(ModItems.SAFARI_PORTAL_NPC_SPAWN_EGG))) {
                    return class_1269.field_5811;
                }
                if (SafariEvents.isFishingRod(stack)) {
                    return class_1269.field_5811;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            if (!SafariEvents.isInSafari(player)) {
                return class_1271.method_22430((Object)stack);
            }
            if (stack == null || stack.method_7960()) {
                return class_1271.method_22430((Object)stack);
            }
            if (SafariEvents.isFishingRod(stack)) {
                return class_1271.method_22430((Object)stack);
            }
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            if (itemId == null) {
                return class_1271.method_22430((Object)stack);
            }
            if ("safari".equals(itemId.method_12836())) {
                return class_1271.method_22430((Object)stack);
            }
            if (SafariEvents.isCobblemonBall(itemId)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.safari.only_safari_balls").method_27692(class_124.field_1061), true);
                return class_1271.method_22431((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (SafariSessionManager.isInSession(handler.method_32311())) {
                SafariSessionManager.pauseSession(handler.method_32311());
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> SafariSessionManager.resumeSession(handler.method_32311()));
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (SafariEvents.isInSafari(player)) {
                if (entity instanceof class_1690 || entity instanceof class_7264) {
                    return class_1269.field_5811;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
    }

    private static boolean isInSafari(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            return serverPlayer.method_37908().method_27983().equals(SafariDimension.SAFARI_DIM_KEY);
        }
        return false;
    }

    private static boolean tryLightPortal(class_1937 world, class_2338 clicked) {
        return SafariEvents.tryLightPortalAxis(world, clicked, class_2350.class_2351.field_11048) || SafariEvents.tryLightPortalAxis(world, clicked, class_2350.class_2351.field_11051);
    }

    private static boolean tryLightPortalAxis(class_1937 world, class_2338 clicked, class_2350.class_2351 axis) {
        class_2338 origin = SafariEvents.findFrameOrigin(world, clicked, axis);
        if (origin == null) {
            return false;
        }
        int width = SafariEvents.measureFrameWidth(world, origin, axis);
        int height = SafariEvents.measureFrameHeight(world, origin, axis);
        if (width < 4 || height < 5 || width > 23 || height > 23) {
            return false;
        }
        if (!SafariEvents.isValidFrame(world, origin, axis, width, height)) {
            return false;
        }
        SafariEvents.fillPortalInterior(world, origin, axis, width, height);
        return true;
    }

    private static class_2338 findFrameOrigin(class_1937 world, class_2338 start, class_2350.class_2351 axis) {
        class_2350 negative;
        if (!world.method_8320(start).method_27852(SafariBlocks.SAFARI_PORTAL_FRAME)) {
            return null;
        }
        class_2338 pos = start;
        int bottomY = world.method_31607();
        while (pos.method_10264() > bottomY && world.method_8320(pos.method_10074()).method_27852(SafariBlocks.SAFARI_PORTAL_FRAME)) {
            pos = pos.method_10074();
        }
        class_2350 class_23502 = negative = axis == class_2350.class_2351.field_11048 ? class_2350.field_11039 : class_2350.field_11043;
        while (world.method_8320(pos.method_10093(negative)).method_27852(SafariBlocks.SAFARI_PORTAL_FRAME)) {
            pos = pos.method_10093(negative);
        }
        return pos;
    }

    private static int measureFrameWidth(class_1937 world, class_2338 origin, class_2350.class_2351 axis) {
        class_2350 positive = axis == class_2350.class_2351.field_11048 ? class_2350.field_11034 : class_2350.field_11035;
        int width = 0;
        class_2338 pos = origin;
        while (width <= 23 && world.method_8320(pos).method_27852(SafariBlocks.SAFARI_PORTAL_FRAME)) {
            ++width;
            pos = pos.method_10093(positive);
        }
        return width;
    }

    private static int measureFrameHeight(class_1937 world, class_2338 origin, class_2350.class_2351 axis) {
        int height = 0;
        class_2338 pos = origin;
        while (height <= 23 && world.method_8320(pos).method_27852(SafariBlocks.SAFARI_PORTAL_FRAME)) {
            ++height;
            pos = pos.method_10084();
        }
        return height;
    }

    private static boolean isValidFrame(class_1937 world, class_2338 origin, class_2350.class_2351 axis, int width, int height) {
        for (int w = 0; w < width; ++w) {
            for (int h = 0; h < height; ++h) {
                class_2338 check;
                boolean isEdge = w == 0 || w == width - 1 || h == 0 || h == height - 1;
                class_2338 class_23382 = check = axis == class_2350.class_2351.field_11048 ? origin.method_10069(w, h, 0) : origin.method_10069(0, h, w);
                if (!(isEdge ? !world.method_8320(check).method_27852(SafariBlocks.SAFARI_PORTAL_FRAME) : !world.method_8320(check).method_26215())) continue;
                return false;
            }
        }
        return true;
    }

    private static void fillPortalInterior(class_1937 world, class_2338 origin, class_2350.class_2351 axis, int width, int height) {
        for (int w = 1; w < width - 1; ++w) {
            for (int h = 1; h < height - 1; ++h) {
                class_2338 place = axis == class_2350.class_2351.field_11048 ? origin.method_10069(w, h, 0) : origin.method_10069(0, h, w);
                world.method_8501(place, (class_2680)SafariBlocks.SAFARI_PORTAL.method_9564().method_11657((class_2769)class_2423.field_11310, (Comparable)axis));
            }
        }
    }

    private static boolean isSafariNpcEntityId(class_2960 id) {
        return "safari".equals(id.method_12836()) && ("safari_npc".equals(id.method_12832()) || "safari_portal_npc".equals(id.method_12832()));
    }

    private static boolean isFishingRod(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (stack.method_31574(class_1802.field_8378) || stack.method_7909() instanceof class_1787) {
            return true;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        return itemId != null && "cobblemon".equals(itemId.method_12836()) && itemId.method_12832().endsWith("_rod");
    }

    private static boolean isCobblemonBall(class_2960 itemId) {
        return itemId != null && "cobblemon".equals(itemId.method_12836()) && itemId.method_12832().endsWith("_ball");
    }

    private static void applySafariShinyRate(PokemonEntity pokemonEntity, class_5819 random) {
        float chance;
        Pokemon pokemon = pokemonEntity.getPokemon();
        if (pokemon.getShiny()) {
            return;
        }
        float configuredRate = Cobblemon.INSTANCE.getConfig().getShinyRate();
        if (configuredRate <= 0.0f) {
            return;
        }
        float f = chance = configuredRate > 1.0f ? 1.0f / configuredRate : configuredRate;
        if (chance > 0.0f && random.method_43057() < chance) {
            pokemon.setShiny(true);
            pokemon.updateAspects();
        }
    }
}

