/*
 * Decompiled with CFR 0.152.
 */
package com.safari.economy;

import com.safari.SafariMod;
import eu.pb4.common.economy.api.CommonEconomy;
import eu.pb4.common.economy.api.EconomyAccount;
import eu.pb4.common.economy.api.EconomyTransaction;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class SafariEconomy {
    private static final class_2960 ACCOUNT_ID = class_2960.method_60655((String)"guishop", (String)"account");

    public static boolean hasEnough(class_3222 player, int amount) {
        try {
            long amountInCents;
            EconomyAccount account = SafariEconomy.getAccount(player);
            if (account == null) {
                SafariMod.LOGGER.error("SafariEconomy: No economy account found for player {}", (Object)player.method_5477().getString());
                return false;
            }
            long balance = account.balance();
            return balance >= (amountInCents = (long)amount * 100L);
        }
        catch (Exception e) {
            SafariMod.LOGGER.error("SafariEconomy: Failed to check balance for player {}", (Object)player.method_5477().getString(), (Object)e);
            return false;
        }
    }

    public static boolean deduct(class_3222 player, int amount) {
        try {
            EconomyAccount account = SafariEconomy.getAccount(player);
            if (account == null) {
                SafariMod.LOGGER.error("SafariEconomy: No economy account found for player {}", (Object)player.method_5477().getString());
                return false;
            }
            int before = SafariEconomy.getBalance(player);
            long amountInCents = (long)amount * 100L;
            EconomyTransaction transaction = account.decreaseBalance(amountInCents);
            boolean success = transaction.isSuccessful();
            int after = SafariEconomy.getBalance(player);
            SafariMod.LOGGER.info("Safari economy deduct: player={}, amount={}, success={}, balanceBefore={}, balanceAfter={}", new Object[]{player.method_5477().getString(), amount, success, before, after});
            SafariEconomy.appendTransactionLog(player, "deduct", amount, success, before, after);
            return success;
        }
        catch (Exception e) {
            SafariMod.LOGGER.error("SafariEconomy: Failed to deduct from player {}", (Object)player.method_5477().getString(), (Object)e);
            return false;
        }
    }

    private static void appendTransactionLog(class_3222 player, String type, int amount, boolean success, int before, int after) {
        try {
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            Path logFile = server.method_27050(class_5218.field_24188).resolve("safari-transactions.log");
            String line = String.format("%s\t%s\t%s\t%s\tamount=%d\tsuccess=%s\tbalanceBefore=%d\tbalanceAfter=%d%n", Instant.now().toString(), player.method_5477().getString(), player.method_5667(), type, amount, success, before, after);
            Files.writeString(logFile, (CharSequence)line, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (Exception e) {
            SafariMod.LOGGER.warn("Safari economy log write failed", (Throwable)e);
        }
    }

    public static int getBalance(class_3222 player) {
        try {
            EconomyAccount account = SafariEconomy.getAccount(player);
            if (account == null) {
                return 0;
            }
            return (int)(account.balance() / 100L);
        }
        catch (Exception e) {
            SafariMod.LOGGER.error("SafariEconomy: Failed to get balance for player {}", (Object)player.method_5477().getString(), (Object)e);
            return 0;
        }
    }

    private static EconomyAccount getAccount(class_3222 player) {
        try {
            return CommonEconomy.getAccount((class_3222)player, (class_2960)ACCOUNT_ID);
        }
        catch (Exception e) {
            SafariMod.LOGGER.error("SafariEconomy: Failed to get economy account via Common Economy API", (Throwable)e);
            return null;
        }
    }
}

