/*
 * Decompiled with CFR 0.152.
 */
package com.safari.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;

public class SafariConfig {
    private static SafariConfig INSTANCE;
    private static File currentConfigFile;
    public int sessionTimeMinutes = 20;
    public int initialSafariBalls = 40;
    public boolean carryOverSafariBalls = false;
    public int entrancePrice = 2500;
    public int ballsPackSmallSize = 10;
    public int ballsPackSmallPrice = 1000;
    public int ballsPackMediumSize = 25;
    public int ballsPackMediumPrice = 2000;
    public int ballsPackLargeSize = 50;
    public int ballsPackLargePrice = 3500;
    public int maxBallsPurchasable = 100;
    public int timePurchaseMinutes = 30;
    public int timePurchasePrice = 1000;
    public int timeTicket5Price = 500;
    public int timeTicket15Price = 1500;
    public int timeTicket30Price = 3000;
    public double commonCatchRate = 0.45;
    public double uncommonCatchRate = 0.18;
    public double rareCatchRate = 0.1;
    public double ultraRareCatchRate = 0.05;
    public int dimensionSize = 2000;
    public boolean forceCustomSpawn = false;
    public double customSpawnX = 0.5;
    public double customSpawnY = 160.0;
    public double customSpawnZ = 0.5;
    public int safariSpawnY = 160;
    public int safariSpawnOffsetY = 3;
    public List<String> allowedBiomes = Arrays.asList("safari:safari_biome");
    public int safariMinLevel = 5;
    public int safariMaxLevel = 30;
    public String entryTitle = "Safari Warning";
    public String entrySubtitle = "Leaving ends your session and remaining time";
    public int entryTitleFadeInTicks = 10;
    public int entryTitleStayTicks = 60;
    public int entryTitleFadeOutTicks = 10;

    public static SafariConfig get() {
        if (INSTANCE == null) {
            INSTANCE = new SafariConfig();
        }
        return INSTANCE;
    }

    public static void load() {
        if (currentConfigFile != null) {
            SafariConfig.loadFromFile(currentConfigFile);
        }
    }

    public static void load(File worldDir) {
        currentConfigFile = new File(worldDir, "safari-config.json");
        SafariConfig.loadFromFile(currentConfigFile);
    }

    private static void loadFromFile(File configFile) {
        if (configFile == null) {
            return;
        }
        if (!configFile.exists()) {
            INSTANCE = new SafariConfig();
            SafariConfig.save();
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            Gson gson = new Gson();
            JsonObject raw = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            boolean shouldRewrite = raw.has("pack16BallsPrice") || raw.has("pack32BallsPrice") || raw.has("pack64BallsPrice") || raw.has("resetTimezone") || raw.has("enableDailyReset") || raw.has("spawnStructureId") || raw.has("starterBoostRadius") || raw.has("starterCullChance") || raw.has("starterSpecies") || raw.has("safariBallItem") || raw.has("logoutClearInventory") || raw.has("allowMultiplayerSessions") || raw.has("coreRadius") || raw.has("resetOffsetRange") || raw.has("spawnRateMultiplier") || !raw.has("entryTitle") || !raw.has("entrySubtitle") || !raw.has("entryTitleFadeInTicks") || !raw.has("entryTitleStayTicks") || !raw.has("entryTitleFadeOutTicks") || !raw.has("forceCustomSpawn") || !raw.has("customSpawnX") || !raw.has("customSpawnY") || !raw.has("customSpawnZ") || !raw.has("guideNpcSpawned") || !raw.has("spawnInitialized");
            INSTANCE = (SafariConfig)gson.fromJson((JsonElement)raw, SafariConfig.class);
            boolean normalized = SafariConfig.normalizeDefaults();
            if (shouldRewrite || normalized) {
                SafariConfig.save();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            INSTANCE = new SafariConfig();
        }
    }

    private static boolean normalizeDefaults() {
        boolean updated = false;
        if (SafariConfig.INSTANCE.sessionTimeMinutes <= 0) {
            SafariConfig.INSTANCE.sessionTimeMinutes = 30;
            updated = true;
        }
        if (SafariConfig.INSTANCE.timePurchaseMinutes <= 0) {
            SafariConfig.INSTANCE.timePurchaseMinutes = 30;
            updated = true;
        }
        if (SafariConfig.INSTANCE.timePurchasePrice < 0) {
            SafariConfig.INSTANCE.timePurchasePrice = 1000;
            updated = true;
        }
        if (SafariConfig.INSTANCE.allowedBiomes == null || SafariConfig.INSTANCE.allowedBiomes.isEmpty()) {
            SafariConfig.INSTANCE.allowedBiomes = Arrays.asList("safari:safari_biome");
            updated = true;
        }
        if (SafariConfig.INSTANCE.ultraRareCatchRate <= 0.0) {
            SafariConfig.INSTANCE.ultraRareCatchRate = 0.05;
            updated = true;
        }
        if (SafariConfig.INSTANCE.maxBallsPurchasable < 0) {
            SafariConfig.INSTANCE.maxBallsPurchasable = 0;
            updated = true;
        }
        if (SafariConfig.INSTANCE.entryTitle == null) {
            SafariConfig.INSTANCE.entryTitle = "Safari Warning";
            updated = true;
        }
        if (SafariConfig.INSTANCE.entrySubtitle == null) {
            SafariConfig.INSTANCE.entrySubtitle = "Leaving ends your session and remaining time";
            updated = true;
        }
        if (SafariConfig.INSTANCE.entryTitleFadeInTicks < 0) {
            SafariConfig.INSTANCE.entryTitleFadeInTicks = 10;
            updated = true;
        }
        if (SafariConfig.INSTANCE.entryTitleStayTicks < 0) {
            SafariConfig.INSTANCE.entryTitleStayTicks = 60;
            updated = true;
        }
        if (SafariConfig.INSTANCE.entryTitleFadeOutTicks < 0) {
            SafariConfig.INSTANCE.entryTitleFadeOutTicks = 10;
            updated = true;
        }
        return updated;
    }

    public static void save() {
        if (currentConfigFile == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(currentConfigFile);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

