/*
 * Decompiled with CFR 0.152.
 */
package com.safari.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.safari.config.SafariConfig;
import com.safari.economy.SafariEconomy;
import com.safari.item.ModItems;
import com.safari.session.SafariInventoryHandler;
import com.safari.session.SafariSession;
import com.safari.session.SafariSessionManager;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class SafariCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"safari").executes(SafariCommand::info)).then(class_2170.method_9247((String)"enter").executes(SafariCommand::enter))).then(class_2170.method_9247((String)"leave").executes(SafariCommand::leave))).then(class_2170.method_9247((String)"info").executes(SafariCommand::info))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"buy").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"balls").then(class_2170.method_9247((String)"small").executes(ctx -> SafariCommand.buyBalls((CommandContext<class_2168>)ctx, SafariConfig.get().ballsPackSmallSize)))).then(class_2170.method_9247((String)"medium").executes(ctx -> SafariCommand.buyBalls((CommandContext<class_2168>)ctx, SafariConfig.get().ballsPackMediumSize)))).then(class_2170.method_9247((String)"large").executes(ctx -> SafariCommand.buyBalls((CommandContext<class_2168>)ctx, SafariConfig.get().ballsPackLargeSize))))).then(class_2170.method_9247((String)"time").then(class_2170.method_9244((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(SafariCommand::buyTime)))).then(class_2170.method_9247((String)"ticket").then(class_2170.method_9244((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(SafariCommand::buyTicket))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(2))).executes(ctx -> {
            SafariConfig.load();
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"message.safari.config_reloaded").method_27692(class_124.field_1060));
            return 1;
        })));
    }

    private static int enter(CommandContext<class_2168> ctx) {
        try {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            return SafariSessionManager.tryStartSession(player, true) ? 1 : 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int leave(CommandContext<class_2168> ctx) {
        try {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            if (!SafariSessionManager.isInSession(player)) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"message.safari.not_in_session").method_27692(class_124.field_1061));
                return 0;
            }
            SafariSessionManager.endSession(player);
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int buyBalls(CommandContext<class_2168> ctx, int amount) {
        try {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            if (!SafariSessionManager.isInSession(player)) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"message.safari.must_be_in_safari_supplies").method_27692(class_124.field_1061));
                return 0;
            }
            SafariSession session = SafariSessionManager.getSession(player);
            if (session.getPurchasedBalls() + amount > SafariConfig.get().maxBallsPurchasable) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"message.safari.purchase_limit").method_27692(class_124.field_1061));
                return 0;
            }
            int price = amount == SafariConfig.get().ballsPackSmallSize ? SafariConfig.get().ballsPackSmallPrice : (amount == SafariConfig.get().ballsPackMediumSize ? SafariConfig.get().ballsPackMediumPrice : (amount == SafariConfig.get().ballsPackLargeSize ? SafariConfig.get().ballsPackLargePrice : 0));
            if (price > 0 && SafariEconomy.deduct(player, price)) {
                SafariInventoryHandler.giveSafariKit(player, amount);
                session.incrementPurchasedBalls(amount);
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)"message.safari.purchased_balls", (Object[])new Object[]{amount}).method_27692(class_124.field_1060));
                return 1;
            }
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"message.safari.not_enough_money").method_27692(class_124.field_1061));
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int buyTime(CommandContext<class_2168> ctx) {
        try {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            if (!SafariSessionManager.isInSession(player)) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"message.safari.must_be_in_safari_time").method_27692(class_124.field_1061));
                return 0;
            }
            SafariSession session = SafariSessionManager.getSession(player);
            int minutes = IntegerArgumentType.getInteger(ctx, (String)"minutes");
            int minutesPerPack = Math.max(1, SafariConfig.get().timePurchaseMinutes);
            int pricePerPack = Math.max(0, SafariConfig.get().timePurchasePrice);
            int totalMinutes = minutes;
            int totalPrice = (int)Math.ceil((double)minutes * (double)pricePerPack / (double)minutesPerPack);
            if (SafariEconomy.deduct(player, totalPrice)) {
                long ticks = (long)totalMinutes * 60L * 20L;
                session.addTime(ticks);
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)"message.safari.added_time", (Object[])new Object[]{totalMinutes}).method_27692(class_124.field_1060));
                return 1;
            }
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)"message.safari.need_money_time", (Object[])new Object[]{totalPrice}).method_27692(class_124.field_1061));
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int buyTicket(CommandContext<class_2168> ctx) {
        try {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            if (!SafariSessionManager.isInSession(player)) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"message.safari.must_be_in_safari_tickets").method_27692(class_124.field_1061));
                return 0;
            }
            int minutes = IntegerArgumentType.getInteger(ctx, (String)"minutes");
            class_1792 ticket = SafariCommand.getTicketItem(minutes);
            if (ticket == null) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"message.safari.invalid_ticket").method_27692(class_124.field_1061));
                return 0;
            }
            int minutesPerPack = Math.max(1, SafariConfig.get().timePurchaseMinutes);
            int pricePerPack = Math.max(0, SafariConfig.get().timePurchasePrice);
            int totalPrice = (int)Math.ceil((double)minutes * (double)pricePerPack / (double)minutesPerPack);
            if (!SafariEconomy.deduct(player, totalPrice)) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)"message.safari.need_money_ticket", (Object[])new Object[]{totalPrice}).method_27692(class_124.field_1061));
                return 0;
            }
            class_1799 stack = new class_1799((class_1935)ticket);
            if (!player.method_31548().method_7394(stack)) {
                player.method_7328(stack, false);
            }
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)"message.safari.purchased_ticket", (Object[])new Object[]{minutes}).method_27692(class_124.field_1060));
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static class_1792 getTicketItem(int minutes) {
        return switch (minutes) {
            case 5 -> ModItems.SAFARI_TICKET_5;
            case 15 -> ModItems.SAFARI_TICKET_15;
            case 30 -> ModItems.SAFARI_TICKET_30;
            default -> null;
        };
    }

    private static int info(CommandContext<class_2168> ctx) {
        try {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            if (!SafariSessionManager.isInSession(player)) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"message.safari.not_in_session_info").method_27692(class_124.field_1080));
                return 0;
            }
            SafariSession session = SafariSessionManager.getSession(player);
            long minutes = session.getTicksRemaining() / 20L / 60L;
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43469((String)"message.safari.session_info", (Object[])new Object[]{minutes}).method_27692(class_124.field_1077));
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

