/*
 * Decompiled with CFR 0.152.
 */
package com.cobblehunts.utils;

import com.cobblehunts.utils.CommandReward;
import com.cobblehunts.utils.HuntsConfig;
import com.cobblehunts.utils.ItemReward;
import com.cobblehunts.utils.LootReward;
import com.cobblehunts.utils.SerializableItemStack;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J!\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/cobblehunts/utils/LootRewardAdapter;", "Lcom/google/gson/TypeAdapter;", "Lcom/cobblehunts/utils/LootReward;", "<init>", "()V", "Lcom/google/gson/stream/JsonWriter;", "out", "value", "", "write", "(Lcom/google/gson/stream/JsonWriter;Lcom/cobblehunts/utils/LootReward;)V", "Lcom/google/gson/stream/JsonReader;", "in", "read", "(Lcom/google/gson/stream/JsonReader;)Lcom/cobblehunts/utils/LootReward;", "Companion", "cobblehunts"})
public final class LootRewardAdapter
extends TypeAdapter<LootReward> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Gson gson = new Gson();

    public void write(@NotNull JsonWriter out, @Nullable LootReward value) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        LootReward lootReward = value;
        if (lootReward instanceof ItemReward) {
            out.name("type").value("item");
            out.name("serializableItemStack");
            HuntsConfig.INSTANCE.getGson().toJson((Object)((ItemReward)value).getSerializableItemStack(), (Type)((Object)SerializableItemStack.class), out);
            out.name("chance").value(((ItemReward)value).getChance());
        } else if (lootReward instanceof CommandReward) {
            out.name("type").value("command");
            out.name("command").value(((CommandReward)value).getCommand());
            out.name("chance").value(((CommandReward)value).getChance());
            if (((CommandReward)value).getSerializableItemStack() != null) {
                out.name("serializableItemStack");
                HuntsConfig.INSTANCE.getGson().toJson((Object)((CommandReward)value).getSerializableItemStack(), (Type)((Object)SerializableItemStack.class), out);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        out.endObject();
    }

    @Nullable
    public LootReward read(@NotNull JsonReader in) {
        LootReward lootReward;
        String string;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        in.beginObject();
        String type = null;
        SerializableItemStack serializableItemStack = null;
        String command = null;
        Double chance = null;
        while (in.hasNext()) {
            string = in.nextName();
            if (string == null) continue;
            int n = -1;
            switch (string.hashCode()) {
                case -1361636556: {
                    if (string.equals("chance")) {
                        n = 1;
                    }
                    break;
                }
                case -199114506: {
                    if (string.equals("serializableItemStack")) {
                        n = 2;
                    }
                    break;
                }
                case 3575610: {
                    if (string.equals("type")) {
                        n = 3;
                    }
                    break;
                }
                case 1714018037: {
                    if (string.equals("displayItem")) {
                        n = 4;
                    }
                    break;
                }
                case 1225168091: {
                    if (string.equals("commandItemStackString")) {
                        n = 5;
                    }
                    break;
                }
                case 950394699: {
                    if (string.equals("command")) {
                        n = 6;
                    }
                    break;
                }
            }
            switch (n) {
                case 3: {
                    type = in.nextString();
                    break;
                }
                case 2: {
                    serializableItemStack = (SerializableItemStack)gson.fromJson(in, (Type)((Object)SerializableItemStack.class));
                    break;
                }
                case 6: {
                    command = in.nextString();
                    break;
                }
                case 1: {
                    chance = in.nextDouble();
                    break;
                }
                case 5: {
                    String string2 = in.nextString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextString(...)");
                    serializableItemStack = new SerializableItemStack(string2);
                    break;
                }
                case 4: {
                    in.skipValue();
                }
            }
        }
        in.endObject();
        string = type;
        if (Intrinsics.areEqual((Object)string, (Object)"item")) {
            SerializableItemStack serializableItemStack2 = serializableItemStack;
            Intrinsics.checkNotNull(serializableItemStack2);
            Double d = chance;
            Intrinsics.checkNotNull((Object)d);
            lootReward = new ItemReward(serializableItemStack2, d);
        } else if (Intrinsics.areEqual((Object)string, (Object)"command")) {
            String string3 = command;
            Intrinsics.checkNotNull((Object)string3);
            Double d = chance;
            Intrinsics.checkNotNull((Object)d);
            lootReward = new CommandReward(string3, d, serializableItemStack);
        } else {
            throw new IllegalArgumentException("Unknown LootReward type: " + type);
        }
        return lootReward;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblehunts/utils/LootRewardAdapter$Companion;", "", "<init>", "()V", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "cobblehunts"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

