/*
 * Decompiled with CFR 0.152.
 */
package fr.zooacademy.raiddensfix.mixin;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.necro.raid.dens.common.raids.RewardHandler;
import fr.zooacademy.raiddensfix.SpeciesTranslationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={RewardHandler.class}, remap=false)
public class RewardHandlerTranslationMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RaidDensFix");

    @Redirect(method={"executeCompletionCommands(Lnet/minecraft/class_3222;Z)V"}, at=@At(value="INVOKE", target="Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;getSpecies()Ljava/lang/String;"))
    private String raiddensfix_translateRewardSpecies(PokemonProperties properties) {
        String englishName = properties.getSpecies();
        if (englishName == null) {
            return null;
        }
        String frenchName = SpeciesTranslationService.INSTANCE.getFrenchName(englishName);
        if (!englishName.equals(frenchName)) {
            LOGGER.debug("[RaidDensFix] Translated reward command species: {} -> {}", (Object)englishName, (Object)frenchName);
        }
        return frenchName;
    }
}

