/*
 * Decompiled with CFR 0.152.
 */
package fr.zooacademy.raiddensfix.mixin;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.necro.raid.dens.common.data.dimension.RaidRegion;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.raids.helpers.RaidReadyManager;
import fr.zooacademy.raiddensfix.RaidRecoveryManager;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3738;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RaidReadyManager.class}, remap=false)
public class RaidReadyManagerMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RaidDensFix");

    @Inject(method={"startBattleWithCheck(Lcom/necro/raid/dens/common/raids/helpers/RaidReadyManager$ReadyCheckData;)V"}, at={@At(value="HEAD")})
    private static void raiddensfix_preValidatePlayers(RaidReadyManager.ReadyCheckData check, CallbackInfo ci) {
        ArrayList<class_3222> toRemove = new ArrayList<class_3222>();
        for (class_3222 player : check.playerList()) {
            if (player == null || !player.method_5805()) {
                toRemove.add(player);
                continue;
            }
            Pokemon validPokemon = RaidReadyManager.findFirstValidPokemon((class_3222)player);
            if (validPokemon != null) continue;
            LOGGER.warn("[RaidDensFix] Player {} has no valid Pokemon, removing from raid before TP", (Object)player.method_5477().getString());
            player.method_7353((class_2561)class_2561.method_43470((String)"[Raid Fix] Vous n'avez aucun Pokemon valide pour ce raid. Vous avez ete retire.").method_27694(style -> style.method_36139(0xFF5555)), false);
            toRemove.add(player);
        }
        for (class_3222 player : toRemove) {
            if (player == null) continue;
            check.participants().remove(player.method_5667());
            check.readyPlayers().remove(player.method_5667());
            check.playerList().remove(player);
            RaidJoinHelper.removeParticipant((class_1657)player);
        }
        if (!toRemove.isEmpty()) {
            LOGGER.info("[RaidDensFix] Removed {} invalid players from raid check", (Object)toRemove.size());
        }
    }

    @Inject(method={"startBattleWithCheck(Lcom/necro/raid/dens/common/raids/helpers/RaidReadyManager$ReadyCheckData;)V"}, at={@At(value="HEAD")})
    private static void raiddensfix_savePreRaidState(RaidReadyManager.ReadyCheckData check, CallbackInfo ci) {
        RaidRecoveryManager.savePreRaidState(new ArrayList(check.playerList()));
    }

    @Inject(method={"startBattleWithCheck(Lcom/necro/raid/dens/common/raids/helpers/RaidReadyManager$ReadyCheckData;)V"}, at={@At(value="TAIL")})
    private static void raiddensfix_postBattleSetup(RaidReadyManager.ReadyCheckData check, CallbackInfo ci) {
        if (check.playerList().isEmpty()) {
            return;
        }
        class_3222 firstPlayer = (class_3222)check.playerList().get(0);
        if (firstPlayer == null) {
            return;
        }
        MinecraftServer server = firstPlayer.method_5682();
        if (server == null) {
            return;
        }
        UUID raidId = check.raidId();
        RaidRegion region = check.region();
        RaidRecoveryManager.repositionBoss(raidId, region);
        ArrayList playersCopy = new ArrayList(check.playerList());
        server.method_18858((Runnable)new class_3738(server.method_3780() + 13, () -> RaidRecoveryManager.resyncPlayerPositions(playersCopy, region)));
        long currentTick = server.method_30002().method_8510();
        for (class_3222 player : check.playerList()) {
            if (player == null || !player.method_5805()) continue;
            RaidRecoveryManager.INSTANCE.scheduleWatchdog(player, currentTick);
        }
        LOGGER.debug("[RaidDensFix] Boss repositioned, player resync scheduled, watchdog set for {} players (ready check path)", (Object)check.playerList().size());
    }
}

