/*
 * Decompiled with CFR 0.152.
 */
package fr.zooacademy.raiddensfix.mixin;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.data.dimension.RaidRegion;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidInvitationManager;
import com.necro.raid.dens.common.raids.helpers.RaidRegionHelper;
import fr.zooacademy.raiddensfix.RaidRecoveryManager;
import fr.zooacademy.raiddensfix.SpeciesTranslationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3222;
import net.minecraft.class_3738;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RaidInvitationManager.class}, remap=false)
public class RaidInvitationManagerMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RaidDensFix");

    @Inject(method={"startRaidWithParticipants(Lnet/minecraft/class_3222;Lcom/necro/raid/dens/common/blocks/entity/RaidCrystalBlockEntity;Ljava/util/List;)V"}, at={@At(value="HEAD")})
    private static void raiddensfix_savePreRaidState(class_3222 host, RaidCrystalBlockEntity crystal, List<class_3222> participants, CallbackInfo ci) {
        ArrayList<class_3222> allPlayers = new ArrayList<class_3222>(participants);
        if (!allPlayers.contains(host)) {
            allPlayers.add(host);
        }
        RaidRecoveryManager.savePreRaidState(allPlayers);
    }

    @Inject(method={"startRaidWithParticipants(Lnet/minecraft/class_3222;Lcom/necro/raid/dens/common/blocks/entity/RaidCrystalBlockEntity;Ljava/util/List;)V"}, at={@At(value="TAIL")})
    private static void raiddensfix_postRaidSetup(class_3222 host, RaidCrystalBlockEntity crystal, List<class_3222> participants, CallbackInfo ci) {
        MinecraftServer server = host.method_5682();
        if (server == null) {
            return;
        }
        UUID raidId = null;
        for (Map.Entry entry : RaidHelper.ACTIVE_RAIDS.entrySet()) {
            RaidInstance instance = (RaidInstance)entry.getValue();
            if (instance == null || !instance.getPlayers().contains(host)) continue;
            raidId = (UUID)entry.getKey();
            break;
        }
        if (raidId == null) {
            LOGGER.warn("[RaidDensFix] Could not find raid ID for host {} in solo/invitation path", (Object)host.method_5477().getString());
            return;
        }
        RaidRegion region = RaidRegionHelper.getRegion(raidId);
        RaidRecoveryManager.repositionBoss(raidId, region);
        RaidRegion finalRegion = region;
        ArrayList<class_3222> participantsCopy = new ArrayList<class_3222>(participants);
        server.method_18858((Runnable)new class_3738(server.method_3780() + 13, () -> RaidRecoveryManager.resyncPlayerPositions(participantsCopy, finalRegion)));
        long currentTick = server.method_30002().method_8510();
        for (class_3222 player : participants) {
            if (player == null || !player.method_5805()) continue;
            RaidRecoveryManager.INSTANCE.scheduleWatchdog(player, currentTick);
        }
        LOGGER.debug("[RaidDensFix] Boss repositioned, player resync scheduled, watchdog set for {} players (invitation/solo path)", (Object)participants.size());
    }

    @Redirect(method={"sendInvitations(Lnet/minecraft/class_3222;Ljava/util/List;Ljava/util/UUID;)V"}, at=@At(value="INVOKE", target="Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;getSpecies()Ljava/lang/String;"))
    private static String raiddensfix_translateInvitationSpecies(PokemonProperties properties) {
        String englishName = properties.getSpecies();
        if (englishName == null) {
            return null;
        }
        String frenchName = SpeciesTranslationService.INSTANCE.getFrenchName(englishName);
        if (!englishName.equals(frenchName)) {
            LOGGER.debug("[RaidDensFix] Translated invitation species: {} -> {}", (Object)englishName, (Object)frenchName);
        }
        return frenchName;
    }
}

