/*
 * Decompiled with CFR 0.152.
 */
package fr.zooacademy.raiddensfix.mixin;

import com.necro.raid.dens.common.raids.helpers.RaidInventorySaveManager;
import fr.zooacademy.raiddensfix.RaidRecoveryManager;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RaidInventorySaveManager.class}, remap=false)
public class RaidInventorySaveMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RaidDensFix");

    @Inject(method={"saveAndClearInventory(Lnet/minecraft/class_3222;)V"}, at={@At(value="HEAD")})
    private static void raiddensfix_persistBeforeClear(class_3222 player, CallbackInfo ci) {
        RaidRecoveryManager.INSTANCE.persistInventoryToDisk(player);
        RaidRecoveryManager.INSTANCE.saveRaidItems(player);
        LOGGER.debug("[RaidDensFix] Inventory persisted to disk for {} before save-and-clear", (Object)player.method_5477().getString());
    }

    @Inject(method={"saveAndClearInventory(Lnet/minecraft/class_3222;)V"}, at={@At(value="TAIL")})
    private static void raiddensfix_restoreAfterClear(class_3222 player, CallbackInfo ci) {
        if (RaidRecoveryManager.INSTANCE.restoreFromDisk(player, false)) {
            LOGGER.info("[RaidDensFix] Inventory re-given to {} after clear \u2014 player keeps their items", (Object)player.method_5477().getString());
        }
        RaidRecoveryManager.INSTANCE.restoreRaidItems(player);
    }

    @Inject(method={"restoreInventory(Lnet/minecraft/class_3222;)V"}, at={@At(value="HEAD")})
    private static void raiddensfix_removeRaidItemsBeforeRestore(class_3222 player, CallbackInfo ci) {
        RaidRecoveryManager.INSTANCE.removeRaidItemsFromInventory(player);
    }

    @Inject(method={"restoreInventory(Lnet/minecraft/class_3222;)V"}, at={@At(value="TAIL")})
    private static void raiddensfix_cleanupAfterRestore(class_3222 player, CallbackInfo ci) {
        RaidRecoveryManager.INSTANCE.cleanupDiskBackup(player.method_5667());
        LOGGER.debug("[RaidDensFix] Disk backup cleaned up for {} after restore", (Object)player.method_5477().getString());
    }
}

