/*
 * Decompiled with CFR 0.152.
 */
package fr.zooacademy.raiddensfix.mixin;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import fr.zooacademy.raiddensfix.SpeciesTranslationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={RaidCrystalBlock.class}, remap=false)
public class RaidCrystalTranslationMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RaidDensFix");

    @Redirect(method={"startOrJoinRaid(Lnet/minecraft/class_1657;Lnet/minecraft/class_2680;Lcom/necro/raid/dens/common/blocks/entity/RaidCrystalBlockEntity;Lnet/minecraft/class_1799;)Z"}, at=@At(value="INVOKE", target="Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;getSpecies()Ljava/lang/String;"))
    private String raiddensfix_translateConfirmSpecies(PokemonProperties properties) {
        String englishName = properties.getSpecies();
        if (englishName == null) {
            return null;
        }
        String frenchName = SpeciesTranslationService.INSTANCE.getFrenchName(englishName);
        if (!englishName.equals(frenchName)) {
            LOGGER.debug("[RaidDensFix] Translated crystal confirm species: {} -> {}", (Object)englishName, (Object)frenchName);
        }
        return frenchName;
    }
}

