/*
 * Decompiled with CFR 0.152.
 */
package fr.zooacademy.raiddensfix.mixin;

import com.mojang.brigadier.context.CommandContext;
import com.necro.raid.dens.common.commands.RaidAdminCommands;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidInventorySaveManager;
import com.necro.raid.dens.common.util.RaidUtils;
import fr.zooacademy.raiddensfix.RaidRecoveryManager;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RaidAdminCommands.class}, remap=false)
public class RaidAdminCommandsMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RaidDensFix");

    @Inject(method={"refreshPlayer(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_3222;)I"}, at={@At(value="RETURN")})
    private static void raiddensfix_enhanceRefresh(CommandContext<class_2168> context, class_3222 player, CallbackInfoReturnable<Integer> cir) {
        if ((Integer)cir.getReturnValue() != 1) {
            return;
        }
        LOGGER.info("[RaidDensFix] Enhancing /crd refresh for {}", (Object)player.method_5477().getString());
        if (RaidInventorySaveManager.hasSavedInventory((class_3222)player)) {
            RaidInventorySaveManager.restoreInventory((class_3222)player);
            LOGGER.info("[RaidDensFix] Inventory restored for {} via /crd refresh", (Object)player.method_5477().getString());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("[Raid Fix] Inventaire restaure pour " + player.method_5477().getString())), true);
        } else {
            RaidRecoveryManager.INSTANCE.onPlayerJoin(player);
        }
        if (RaidUtils.isRaidDimension((class_1937)player.method_37908())) {
            RaidHelper.teleportFromRaid((class_3222)player);
            LOGGER.info("[RaidDensFix] Player {} teleported out of raid dimension via /crd refresh", (Object)player.method_5477().getString());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"[Raid Fix] Joueur teleporte hors de la dimension raid"), true);
        }
        RaidRecoveryManager.INSTANCE.cleanupDiskBackup(player.method_5667());
    }
}

