/*
 * Decompiled with CFR 0.152.
 */
package fr.zooacademy.raiddensfix.mixin;

import com.cobblehunts.utils.HuntPokemonEntry;
import fr.zooacademy.raiddensfix.SpeciesTranslationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(targets={"com/cobblehunts/gui/huntsgui/HuntsGuiUtils"}, remap=false)
public class CobbleHuntsTranslationMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RaidDensFix");

    @Redirect(method={"createActivePokemonItem(Lcom/cobblehunts/HuntInstance;Ljava/lang/String;Ljava/lang/Long;)Lnet/minecraft/class_1799;"}, at=@At(value="INVOKE", target="Lcom/cobblehunts/utils/HuntPokemonEntry;getSpecies()Ljava/lang/String;", ordinal=1))
    private String raiddensfix_activeFrenchSpecies(HuntPokemonEntry entry) {
        return CobbleHuntsTranslationMixin.translateSpecies(entry.getSpecies());
    }

    @Redirect(method={"createPreviewPokemonItem(Lcom/cobblehunts/HuntInstance;Ljava/lang/String;)Lnet/minecraft/class_1799;"}, at=@At(value="INVOKE", target="Lcom/cobblehunts/utils/HuntPokemonEntry;getSpecies()Ljava/lang/String;", ordinal=1))
    private String raiddensfix_previewFrenchSpecies(HuntPokemonEntry entry) {
        return CobbleHuntsTranslationMixin.translateSpecies(entry.getSpecies());
    }

    private static String translateSpecies(String speciesId) {
        String frenchName;
        String englishName = speciesId.substring(0, 1).toUpperCase() + speciesId.substring(1);
        if (!englishName.equals(frenchName = SpeciesTranslationService.INSTANCE.getFrenchName(englishName))) {
            return frenchName.substring(0, 1).toLowerCase() + frenchName.substring(1);
        }
        return speciesId;
    }
}

