/*
 * Decompiled with CFR 0.152.
 */
package fr.zooacademy.raiddensfix;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Species;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0015\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\nR\u001c\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00078\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00078\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00078\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0012R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0017R$\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lfr/zooacademy/raiddensfix/SpeciesTranslationService;", "", "<init>", "()V", "", "load", "buildEnglishMap", "", "englishName", "getFrenchName", "(Ljava/lang/String;)Ljava/lang/String;", "text", "translateInString", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/slf4j/Logger;", "LANG_PATH", "Ljava/lang/String;", "SPECIES_KEY_PREFIX", "SPECIES_KEY_SUFFIX", "", "showdownIdToFrench", "Ljava/util/Map;", "englishToFrench", "englishExactToFrench", "", "value", "loaded", "Z", "getLoaded", "()Z", "raid-dens-fix"})
public final class SpeciesTranslationService {
    @NotNull
    public static final SpeciesTranslationService INSTANCE = new SpeciesTranslationService();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RaidDensFix");
    @NotNull
    private static final String LANG_PATH = "assets/cobblemon/lang/fr_fr.json";
    @NotNull
    private static final String SPECIES_KEY_PREFIX = "cobblemon.species.";
    @NotNull
    private static final String SPECIES_KEY_SUFFIX = ".name";
    @NotNull
    private static final Map<String, String> showdownIdToFrench = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> englishToFrench = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> englishExactToFrench = new LinkedHashMap();
    private static boolean loaded;

    private SpeciesTranslationService() {
    }

    public final boolean getLoaded() {
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        try {
            Object object;
            InputStream resource = this.getClass().getClassLoader().getResourceAsStream(LANG_PATH);
            if (resource == null) {
                LOGGER.warn("[RaidDensFix] Could not find {} on classpath, French translation disabled", (Object)LANG_PATH);
                return;
            }
            Type type2 = new TypeToken<Map<String, ? extends String>>(){}.getType();
            Closeable closeable = resource;
            Throwable object22 = null;
            try {
                Map map;
                Object stream = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    InputStreamReader reader = (InputStreamReader)closeable2;
                    boolean bl2 = false;
                    map = (Map)new Gson().fromJson((Reader)reader, type2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                }
                stream = map;
                object = stream;
            }
            catch (Throwable bl) {
                Throwable throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, object22);
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"use(...)");
            Object langMap = object;
            int count = 0;
            for (Map.Entry entry : langMap.entrySet()) {
                String key = (String)entry.getKey();
                String frenchName = (String)entry.getValue();
                if (!StringsKt.startsWith$default((String)key, (String)SPECIES_KEY_PREFIX, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)key, (String)SPECIES_KEY_SUFFIX, (boolean)false, (int)2, null)) continue;
                String showdownId = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)key, (CharSequence)SPECIES_KEY_PREFIX), (CharSequence)SPECIES_KEY_SUFFIX);
                showdownIdToFrench.put(showdownId, frenchName);
                ++count;
            }
            LOGGER.info("[RaidDensFix] Loaded {} French species names from lang file", (Object)count);
            loaded = true;
        }
        catch (Exception e) {
            LOGGER.error("[RaidDensFix] Failed to load French translations: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public final void buildEnglishMap() {
        if (!loaded) {
            return;
        }
        try {
            Collection species = PokemonSpecies.getSpecies();
            int mapped = 0;
            for (Species sp : species) {
                String showdownId = sp.showdownId();
                String frenchName = showdownIdToFrench.get(showdownId);
                if (frenchName == null) continue;
                String englishName = sp.getName();
                String string = englishName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                englishToFrench.put(string, frenchName);
                englishExactToFrench.put(englishName, frenchName);
                ++mapped;
            }
            LOGGER.info("[RaidDensFix] Mapped {} English\u2192French species names", (Object)mapped);
        }
        catch (Exception e) {
            LOGGER.error("[RaidDensFix] Failed to build English\u2192French map: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @NotNull
    public final String getFrenchName(@NotNull String englishName) {
        Intrinsics.checkNotNullParameter((Object)englishName, (String)"englishName");
        String string = englishExactToFrench.get(englishName);
        if (string == null) {
            String string2 = englishName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            string = englishToFrench.get(string2);
            if (string == null) {
                string = englishName;
            }
        }
        return string;
    }

    @NotNull
    public final String translateInString(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!loaded || englishExactToFrench.isEmpty()) {
            return text;
        }
        String result = text;
        for (Map.Entry<String, String> entry : englishExactToFrench.entrySet()) {
            String english = entry.getKey();
            String french = entry.getValue();
            if (!StringsKt.contains$default((CharSequence)result, (CharSequence)english, (boolean)false, (int)2, null)) continue;
            result = StringsKt.replace$default((String)result, (String)english, (String)french, (boolean)false, (int)4, null);
        }
        return result;
    }
}

